//
//  Demo.CH
//
// Copyright (c) 1992 Delcom International Software Engineering
//
//  System header file for the Delcom Interface Library Demo Program
//

#include "CUAClip.ch"
#include "Mouse.ch"

#include "Inkey.ch"

#define  K_SPACE     32       // Inkey.ch missed this one!
#define  K_ALT_END   415      // Need this for 'clean' quits.

//
// Standard Box definitions
//
// Single-line top and left side, double-line bottom and right side
//
#define B_STANDARD   ( CHR(218) + CHR(196) + CHR(191) + CHR(179) + ;
								CHR(217) + CHR(196) + CHR(192) + CHR(179) )

// No border (uses space character)
#define B_NONE       ( CHR(32) + CHR(32) + CHR(32) + CHR(32) + ;
								CHR(32) + CHR(32) + CHR(32) + CHR(32) )

// Single-line box
#define B_SINGLE     ( CHR(218) + CHR(196) + CHR(191) + CHR(179) + ;
								CHR(217) + CHR(196) + CHR(192) + CHR(179) )

// Double-line box
#define B_DOUBLE     ( CHR(201) + CHR(205) + CHR(187) + CHR(186) + ;
								CHR(188) + CHR(205) + CHR(200) + CHR(186) )

#define  _CRLF          CHR(13) + CHR(10)
#define  _TAB           CHR(9)

//
// Remap SAVESCREEN/RESTSCREEN, DISPBEGIN/DISPEND, and SCROLL
//
#xtranslate SETMODE( <rows>, <cols> ) => M_SetMode( <rows>, <cols> )

#xtranslate SAVESCREEN( <top>, <left>, <bottom>, <right> )     ;
			=> M_SaveScreen( <top>, <left>, <bottom>, <right> )

#xtranslate SAVESCREEN() => M_SaveScreen()


#xtranslate RESTSCREEN( <top>, <left>, <bottom>, <right>, <screen> )       ;
			=> M_RestScreen( <top>, <left>, <bottom>, <right>, <screen> )

#xtranslate DISPBEGIN() => M_Disp( 0 )

#xtranslate DISPEND() => M_Disp( 1 )

#xtranslate SCROLL( <top>, <left>, <bottom>, <right>, <rows> )             ;
			=> M_Scroll( <top>, <left>, <bottom>, <right>, <rows> )

#xtranslate CLS => M_Scroll(); SetPos(0,0)

#xtranslate CLEAR SCREEN => CLS

#xtranslate @ <top>, <left> CLEAR TO <bottom>, <right>                     ;
		=> M_Scroll( <top>, <left>, <bottom>, <right> );                     ;
			SetPos( <top>, <left> )
