; __GETPARAMS
;
; Purpose:    Return parameter information to calling process
;
; Call with:  Nothing
;
; Returns:    DX:AX points to a contiguous array of parameter blocks.
;             CX contains parameter count.
;
;             The parameter block is 14 bytes in length.  The first word
;             contains the data type (as returned by __ParInfo).  The
;             remaining 12 bytes differ depending on the data type.  See
;             the various structures declared below.
;
;             Note:  The array of parameter blocks is allocated by a call
;             to __XAlloc.  Don't forget to __XFree the pointer when you're
;             finished!
;
; Assembly:   tasm /jIDEAL /M2 getparam
;
; Comments:   This routine is useful for reducing overhead in your ASM
;             routines.  If you've ever built a library of assembler
;             modules, you know how bloated they become with all the calls
;             to __ParInfo, __ParNI, __ParC, and so on.  This routine
;             attempts to alleviate the problem by providing parameter
;             retrieval services that can be used by all your assembler
;             routines.  So instead of having each ASM module make its own
;             calls to several different __Par routines, they can all make
;             one single call to __GetParams.  In a library of many ASM
;             functions, this can reduce your overhead tremendously.
;
;             I welcome your comments and questions.  Please contact me if you
;             would like to offer feedback.
;
;                                 Ted Means 73067,3332
;                                 July, 1991
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

Public   __GetParams

OrigOfs  EQU       Word Ptr BP - 8
Buffer   EQU       DWord Ptr BP - 6
BufOfs   EQU       Word Ptr BP - 6
BufSeg   EQU       Word Ptr BP - 4
PCount   EQU       Word Ptr BP - 2
ParamBlk EQU       (PB ES:BX)
PBSize   EQU       14

Struc    PChar
StrLen   DW        ?
PtrOfs   DW        ?
PtrSeg   DW        ?
Junk     DB        6 dup(?)
Ends     PChar

Struc    PNumeric
LowWord  DW        ?
HighWord DW        ?
Float    DQ        ?
Ends     PNumeric

Struc    PLogical
LValue   DW        ?
Junk     DT        ?
Ends     PLogical

Struc    PDate
DValue   DQ        ?
Junk     DD        ?
Ends     PDate

Struc    PArray
ArrLen   DW        ?
Junk     DT        ?
Ends     PArray

Union    Info
CData    PChar     ?
NData    PNumeric  ?
LData    PLogical  ?
DData    PDate     ?
AData    PArray    ?
Ends     Info

Struc    PB
DataType DW        ?
Data     Info      ?
Ends     PB


Extrn    __ParInfo:Far
Extrn    __ParInfa:Far
Extrn    __ParCLen:Far
Extrn    __ParC:Far
Extrn    __ParNL:Far
Extrn    __ParND:Far
Extrn    __ParDS:Far
Extrn    __ParL:Far
Extrn    __StorCLen:Far
Extrn    __XAlloc:Far

Segment  _DevCon   Word      Public    "CODE"
         Assume    CS:_DevCon

Proc     __GetParams         Far

         Push      BP                        ; Save BP
         Mov       BP,SP                     ; Set up stack reference
         Sub       SP,8                      ; Allocate room for locals

         Xor       AX,AX                     ; Clear AX
         Push      AX                        ; Put on stack to get PCount
         Call      __ParInfo                 ; Get PCount
         Add       SP,2                      ; Realign stack
         Mov       [PCount],AX               ; Store PCount for later

         Mov       DX,PBSize                 ; Set multiplicand
         Mul       DX                        ; Compute buffer size
         Push      AX                        ; Put size on stack
         Call      __XAlloc                  ; Allocate buffer
         Add       SP,2                      ; Realign stack

         Mov       [BufSeg],DX               ; Store segment
         Mov       [BufOfs],AX               ; Store offset
         Mov       [OrigOfs],AX              ; Store original offset
         Or        DX,AX                     ; Check for null pointer
         Mov       CX,[PCount]               ; Load loop terminal value
         JNZ       Top                       ; If not, continue
         Mov       SP,BP                     ; Realign stack
         Pop       BP
         STC                                 ; Set carry to indicate error
         RetF                                ; Exit with carry set

Top:     Push      CX                        ; Save loop controller
         Mov       AX,CX                     ; Get current loop counter
         Sub       AX,[PCount]               ; Subtract PCount
         Neg       AX                        ; Get absolute value
         Inc       AX                        ; Get param number
         Push      AX                        ; Put param number on stack
         Call      __ParInfo                 ; Get data type
         LES       BX,[Buffer]               ; Load buffer address
         Mov       [ParamBlk.DataType],AX    ; Store data type in buffer

         Test      AX,1                      ; Check for character
         JNZ       Char
         Test      AX,2                      ; Check for numeric
         JNZ       Numeric
         Test      AX,4                      ; Check for logical
         JNZ       Logical
         Test      AX,8                      ; Check for date
         JNZ       Date
         Test      AX,512                    ; Check for array
         JNZ       Array
         Jmp       Bottom                    ; Unexpected data type, ignore

Char:    Call      __ParCLen                 ; Get length of string
         LES       BX,[Buffer]               ; Load buffer address
         Mov       [ParamBlk.Data.CData.StrLen],AX
         Push      AX                        ; Put length on stack
         Xor       AX,AX                     ; Clear AX
         Push      AX                        ; Put null pointer on stack
         Push      AX
         Call      __StorCLen                ; Make string safe to write to
         Add       SP,6                      ; Realign stack
         Call      __ParC                    ; Get pointer to string
         LES       BX,[Buffer]               ; Load pointer to buffer
         Mov       [ParamBlk.Data.CData.PtrSeg],DX
         Mov       [ParamBlk.Data.CData.PtrOfs],AX
         Jmp       Short Bottom              ; Go to bottom of loop

Numeric: Call      __ParNL                   ; Get value as integer
         LES       BX,[Buffer]               ; Load buffer address
         Mov       [ParamBlk.Data.NData.LowWord],AX
         Mov       [ParamBlk.Data.NData.HighWord],DX
         Call      __ParND                   ; Get value as float
         Mov       CX,6                      ; Set structure offset
StrDup:  Push      DS                        ; Save DS
         Push      SI                        ; Save SI
         Push      DI                        ; Save DI
         Mov       DS,DX                     ; Move segment to DS
         Mov       SI,AX                     ; Move offset to SI
         LES       DI,[Buffer]               ; Get address of buffer
         Add       DI,CX                     ; Point DI to value location
         Mov       CX,4                      ; Set length
         Rep       Movsw                     ; Copy value to buffer
         Pop       DI                        ; Restore DI
         Pop       SI                        ; Restore SI
         Pop       DS                        ; Restore DS
         Jmp       Short Bottom              ; Go to bottom of loop

Logical: Call      __ParL                    ; Get value as logical
         LES       BX,[Buffer]               ; Load buffer address
         Mov       [ParamBlk.Data.LData.LValue],AX
         Jmp       Short Bottom              ; Go to bottom of loop

Date:    Call      __ParDS                   ; Get pointer to date
         Mov       CX,2                      ; Set structure offset
         Jmp       StrDup                    ; Avoid needless code duplication

Array:   Pop       DX                        ; Get param # back
         Xor       AX,AX                     ; Clear AX
         Push      AX                        ; Request element count
         Push      DX                        ; Put param # back
         Call      __ParInfa                 ; Get element count
         Add       SP,2                      ; Realign stack
         LES       BX,[Buffer]               ; Load buffer address
         Mov       [ParamBlk.Data.AData.ArrLen],AX

Bottom:  Add       SP,2                      ; Realign stack
         Add       [BufOfs],PBSize           ; Adjust offset
         Pop       CX                        ; Restore loop controller
         Dec       CX                        ; Decrement loop counter
         JCXZ      Done                      ; Quit if finished
         Jmp       Top                       ; Go to top of loop

Done:    Mov       DX,[BufSeg]               ; Load param block segment
         Mov       AX,[OrigOfs]              ; Load param block offset
         Mov       CX,[PCount]               ; Load PCount
         Mov       SP,BP                     ; Realign stack
         Pop       BP                        ; Restore BP
         CLC                                 ; Clear carry to indicate no error
Exit:    Ret

Endp     __GetParams
Ends     _DevCon
End
