Program dbView;
{----------------------------------------------------------------------
	An enhancement to the Norton Commander (tm) dBASE VIEWER

	Written by Pepijn Smits
	Tel +31-10-2120589, Fax +31-10-2121205 or CIS 74750,733

	Allows you to use the Norton Commander DBVIEW.EXE for:
		MS-FoxPro, CA-Clipper and SIx Driver DBF/FPT files.
		SuccesWare DBF/SMT files.

	Usage:	Rename original DBVIEW.EXE from NC to DBVIEW.CMD, then
		copy this DBVIEW.EXE to the NC directory.

	Works as Follows: When DBVIEW is called, the program
	looks for a FPT or SMT file with the same name. If no
 	such file is found, nothing is done, but the original DBVIEW
	is called. In the case a FPT or SMT file is found, DBVIEW.EXE
	opens the DBF and writes a dummy header byte (indicating DBT
 	memos), and then calls DBVIEW which will work properly. When
	returning, the original byte is returned in the header. Also the
	original date & time are restored.

	Writing in the file can de done without problems, as NC's
	DBVIEW also assumes exclusive use.

	This program is hereby placed in the public domain. Feel free
	to use or modify at will. No warranty of any kind, it is
	supplied AS IS, thank you.

	A possible enhancement would be to update the LastRec field
	in the DBF header to reflect actual record count, DBVIEW is often
	confused as to the length. Let me know if you do so. The Turbo
	Pascal source is supplied.

	Named trademarks mentionned for identifications purposes only
----------------------------------------------------------------------}
{$M 1024,0,1024}

Uses
  Dos;

Const
  DbtByte : Byte = $83;

Var
  fptDTA, smtDTA : SearchRec;
  fptCode, smtCode : Byte;
  dbfName, fptName, smtName, ProgName : String;
  HeaderByte : Byte;
  HeaderChanged : Boolean;
  OrigTime : LongInt;
  F : File;
  Comline : ^String;

Begin
  Comline := Ptr(Prefixseg,128);
  HeaderChanged := FALSE;
  dbfName := ParamStr(1);
  fptName := Copy(dbfName,1,Length(dbfName)-3) + 'FPT';
  smtName := Copy(dbfName,1,Length(dbfName)-3) + 'SMT';
  ProgName := ParamStr(0);
  ProgName := Copy(ProgName,1,Length(ProgName)-3) + 'CMD';
  FindFirst(fptName,0,fptDTA); fptCode := DosError;	{ is there an FPT? }
  FindFirst(smtName,0,fptDTA); smtCode := DosError; 	{ or a SMT? }
  if (fptCode = 0 ) or (smtCode = 0) then		{ Got a FPT or SMT file! }
  begin
    HeaderChanged := TRUE;
    assign(f,dbfName);
    reset(f,1);
    Blockread(f,HeaderByte,1);
    GetFtime(f,OrigTime);
    Seek(f,0);
    Blockwrite(f,dbtByte,1); 				{ Write DBT code }
    close(f);
  end;
  SwapVectors;
  Exec(ProgName,Comline^);
  SwapVectors;
  if HeaderChanged Then
  Begin
    assign(f,dbfName);
    reset(f,1);
    blockwrite(f,HeaderByte,1);
    setFtime(f,OrigTime);
    close(f);
  end;
End.
