/* DBASE.H Definition of data structs used in dBASE files */
/* Published by Kent Porter of Dr. Dobbs                  */        

#define char unsigned char

/* dBASE header record for .DBF files */
typedef struct {
   char     id,               /* identification */
            yy,mm,dd;         /* date stamp, last update */
	 long     nrecs;            /* number of records in file */
   unsigned headerlen,        /* number of bytes in header */
            reclen;           /* number of bytes per record */
   char     res[2],           /* first reserved field */
            incompletexn,     /* incomplete transction = 1 (dBASEIV) */
            encrypted,        /* encrypted file = 1 (dBASEIV) */
            lan[12],          /* for LAN version */
            mdx,              /* .MDX file exists = 1 (dBASEIV) */
            res2[3];          /* second reserved field */

    } HEADREC;


/* dBASE field descriptor record (one per field) */
typedef struct {
   char  name[11],         /* field name */
         type;             /* field type in ASCII */
   char  res1[4],          /* first reserved area */
         length,           /* field length in bytes */
         decimals,         /* number of decimals */
         res[2],           /* second reserved area */
         workarea,         /* work area ID */
         res3[11];         /* third reserved area */

    } FLDDES;
