'  sample QuickBasic code for accessing dBase III/IV .DBF files

DEFINT A-Z

'  sub declarations
DECLARE SUB DbfFldInfo ()
DECLARE SUB DbfGetFld (FldNum%, RecBuff$, Fld$)
DECLARE SUB DbfGetRec (RecNum!, RecBuff$, DelFlag$)
DECLARE SUB DbfOpen (DbfName$)
DECLARE SUB ErrorMsg ()

'  define the DBF header structure
TYPE DbfHeaderDesc
   ValFile    AS STRING * 1
   LUpDate    AS STRING * 3
   RecCount   AS LONG
   HdrSize    AS INTEGER
   RecSize    AS INTEGER
   Reserved1  AS STRING * 2
   IsMarked   AS STRING * 1
   Encrypted  AS STRING * 1
   Reserved2  AS STRING * 12
   MdxFlag    AS STRING * 1
   Reserved3  AS STRING * 3
END TYPE

'  define the header structure for the array of field descriptors
TYPE DbfFieldDesc
   FName      AS STRING * 11
   FType      AS STRING * 1
   Reserved1  AS STRING * 4
   FLgth      AS STRING * 1
   FDecs      AS STRING * 1
   Reserved2  AS STRING * 2
   WorkArea   AS STRING * 1
   Reserved3  AS STRING * 10
   IndexFlag  AS STRING * 1
END TYPE

'  define global variables
DIM SHARED DbfHdr AS DbfHeaderDesc, DbfFld AS DbfFieldDesc
DIM SHARED VerNum, HdrSize, RecCount!, RecSize, TotFields, LUpDate$
DIM SHARED MemoFlag$, MdxFlag$, EncryptFlag$, IsMarkedFlag$
DIM SHARED FldName$(TotFields), FldType$(TotFields), FldLgth(TotFields)
DIM SHARED FldDecs(TotFields), FldStPos(TotFields), FldIndex$(TotFields)

'  a rather trivial error trap.....
ON ERROR GOTO ErrorTrap

'  here we go.... get the DBF file name
CmdLine$ = ""
'  for compiled version add the following line.....
'  IF COMMAND$ <> "" THEN CmdLine$ = COMMAND$
IF CmdLine$ = "" THEN
   CLS
   INPUT "Enter .DBF File Name: ", DbfName$
   DbfName$ = UCASE$(DbfName$)
ELSE
   DbfName$ = UCASE$(CmdLine$)
END IF

'  if no extension, supply one
IF INSTR(DbfName$, ".") = 0 THEN DbfName$ = DbfName$ + ".DBF"

'  open the file
CALL DbfOpen(DbfName$)

'  redimension the arrays for the field info and get the info
REDIM FldName$(TotFields), FldType$(TotFields), FldLgth(TotFields)
REDIM FldDecs(TotFields), FldStPos(TotFields), FldIndex$(TotFields)
CALL DbfFldInfo

'  display header record information
CLS
PRINT DbfName$; TAB(40); "DBF Version "; VerNum
PRINT
PRINT "Total Records.... "; RecCount!; TAB(40); "Memo Flag........  "; MemoFlag$
PRINT "Record Size...... "; RecSize; TAB(40); "Production MDX...  "; MdxFlag$
PRINT "Fields/Record ... "; TotFields; TAB(40); "Encryption.......  "; EncryptFlag$
PRINT "Last Update......  "; LUpDate$; TAB(40); "IsMarked.........  "; IsMarkedFlag$
PRINT

'  display the field descriptor information
PRINT "Field  Field Name  Type       Width    Dec    Index"
Types$ = "Character Numeric   Float     Date      Logical   Memo      "
LineKnt = 8
FieldNum = 1
DO WHILE FieldNum <= TotFields
   PRINT SPACE$(5 - LEN(STR$(FieldNum))) + STR$(FieldNum);
   PRINT "  " + FldName$(FieldNum);
   TypePos = INSTR(Types$, FldType$(FieldNum))
   IF TypePos > 0 THEN St$ = MID$(Types$, TypePos, 10) ELSE St$ = "????????? "
   PRINT " " + St$;
   PRINT SPACE$(6 - LEN(STR$(FldLgth(FieldNum)))) + STR$(FldLgth(FieldNum));
   IF FldType$(FieldNum) = "N" OR FldType$(FieldNum) = "F" THEN
      St$ = SPACE$(7 - LEN(STR$(FldDecs(FieldNum)))) + STR$(FldDecs(FieldNum))
   ELSE
      St$ = SPACE$(7)
   END IF
   PRINT St$;
   IF ASC(FldIndex$(FieldNum)) > 0 THEN St$ = "Y" ELSE St$ = "N"
   PRINT SPACE$(8) + St$
   LineKnt = LineKnt + 1
   IF LineKnt > 21 THEN
      PRINT
      PRINT "Press any key to continue....";
      DO WHILE INKEY$ = ""
      LOOP
      LineKnt = 0
      CLS
   END IF
   FieldNum = FieldNum + 1
LOOP
PRINT "** Total **" + SPACE$(18);
PRINT SPACE$(6 - LEN(STR$(RecSize))) + STR$(RecSize)

'  see if we want to start listing individual records
PRINT
PRINT "List records (Y/N)? ";
KeyPressed$ = ""
DO WHILE KeyPressed$ = ""
   KeyPressed$ = INKEY$
LOOP
IF UCASE$(KeyPressed$) = "Y" THEN RecNum! = 1 ELSE RecNum! = RecCount! + 1

'  begin loop to print individual records
DO WHILE RecNum! <= RecCount!

   '  get a record from the data file
   CALL DbfGetRec(RecNum!, RecBuff$, DelFlag$)

   '  print contents of one record
   CLS
   PRINT "Record Number", RecNum!; DelFlag$; TAB(40); "Total "; RecCount!
   LineKnt = 1
   FldNum = 1
   DO WHILE FldNum <= TotFields

      '  get field contents for current record
      CALL DbfGetFld(FldNum, RecBuff$, Fld$)

      '  print the field formatted according to field type
      PRINT FldName$(FldNum);
      SELECT CASE FldType$(FldNum)
         CASE "C"
            IF LEN(Fld$) <= 60 THEN
               PRINT Fld$
            ELSE
               PRINT LEFT$(Fld$, 60)
            END IF
         CASE "D"
            PRINT MID$(Fld$, 5, 2) + "/" + MID$(Fld$, 7, 2) + "/" + MID$(Fld$, 3, 2)
         CASE "F"
            PRINT Fld$
         CASE "L"
            PRINT "." + Fld$ + "."
         CASE "M"
            IF LEFT$(Fld$, 1) = " " THEN
               PRINT "memo"
            ELSE
               PRINT "MEMO"
            END IF
         CASE "N"
            PRINT Fld$
         CASE ELSE
            PRINT
      END SELECT
      LineKnt = LineKnt + 1
      IF LineKnt > 21 THEN
         PRINT
         PRINT "Press any key to continue....";
         DO WHILE INKEY$ = ""
         LOOP
         CLS
         PRINT "Record Number", RecNum!; DelFlag$; TAB(40); "Total "; RecCount!
         LineKnt = 1
      END IF
      FldNum = FldNum + 1
   LOOP

   '  check for eof, and if not there, see if we want to continue
   IF RecNum! >= RecCount! THEN
      PRINT
      PRINT "END OF FILE -- Press any key to exit"
      DO WHILE INKEY$ = ""
      LOOP
      RecNum! = RecCount! + 1
   ELSE
      PRINT
      PRINT "Continue (Y(es)/N(o)/G(o) To Record Num)? ";
      KeyPressed$ = ""
      DO WHILE KeyPressed$ = ""
         KeyPressed$ = INKEY$
      LOOP
      SELECT CASE UCASE$(KeyPressed$)
         CASE "Y"
            RecNum! = RecNum! + 1
         CASE "G"
            PRINT "G"
            INPUT "Record Number? ", NewRecNum!
            IF NewRecNum! <= 0 THEN NewRecNum! = 1
            IF NewRecNum! > RecCount! THEN NewRecNum! = RecCount!
            RecNum! = NewRecNum!
         CASE ELSE
            RecNum! = RecCount! + 1
      END SELECT
   END IF
LOOP

'  that's all folks!
END

'  and, the trivial error trap.....
ErrorTrap:
   CALL ErrorMsg
   END

'  DbfFldInfo ..... loops through the header record for each field and
'                   builds arrays of field info
'
SUB DbfFldInfo

   '  set file pointer to beginning of field descriptors in the header
   SEEK #1, 33

   '  loop for each field
   FieldNum = 1
   StPos = 1                            ' keep track of field starting positions
   DO WHILE FieldNum <= TotFields

      '  read info for one field
      GET #1, , DbfFld

      St$ = DbfFld.FName                ' note that field name is terminated
      IF INSTR(St$, CHR$(0)) > 0 THEN   ' with an ascii null, so we need to
         NullPos = INSTR(St$, CHR$(0))  ' strip it and pad with blanks
         St$ = LEFT$(St$, NullPos - 1) + SPACE$(LEN(St$) - NullPos + 1)
      END IF
      FldName$(FieldNum) = St$
      FldType$(FieldNum) = DbfFld.FType
      FldLgth(FieldNum) = ASC(DbfFld.FLgth)
      FldDecs(FieldNum) = ASC(DbfFld.FDecs)
      FldIndex$(FieldNum) = DbfFld.IndexFlag
      FldStPos(FieldNum) = StPos
      StPos = StPos + FldLgth(FieldNum)
      FieldNum = FieldNum + 1
   LOOP

END SUB

'  DbfGetFld ..... pulls a given field out of the record buffer
'
'                  FldNum   = field number to get
'                  RecBuff$ = buffer containing current input record
'                  Fld$     = returned field string
'
SUB DbfGetFld (FldNum, RecBuff$, Fld$)

   Fld$ = MID$(RecBuff$, FldStPos(FldNum), FldLgth(FldNum))

END SUB

'  DbfGetRec ..... get a record from the database
'
'                  RecNum!  = record number to get
'                  RecBuff$ = returned buffer with the specified record
'                  DelFlag$ = returned delete flag for the record
'
SUB DbfGetRec (RecNum!, RecBuff$, DelFlag$)

   ' position the file pointer to the requested record
   RecPos = HdrSize + ((RecNum! - 1) * RecSize) + 1
   SEEK #1, RecPos

   ' read the delete flag, and then the actual record
   DelFlag$ = INPUT$(1, 1)
   RecBuff$ = INPUT$(RecSize, 1)

END SUB

'
'  DbfOpen ..... open a DBF file, verify that it is a valid dBase III/IV
'                file, and process the file header.  note that the checks
'                to verify file validity are not foolproof, i.e., it is
'                possible for a non-dBase file to pass the tests (although
'                somewhat unlikely).
'
'                DbfName$ = name of DBF file with extension
'
SUB DbfOpen (DbfName$)

   ' attempt to open file for input in order to verify that it exists
   OPEN DbfName$ FOR INPUT AS #1
   CLOSE #1

   ' file exists so open it as binary so we can process it correctly
   OPEN DbfName$ FOR BINARY AS #1

   ' read the file header and attempt to verify that we've got a valid .DBF
   ' file.  if any test fails, generate bogus error code 201.
   GET #1, , DbfHdr
   VerNum = ASC(DbfHdr.ValFile) AND &H7&
   IF VerNum <> 3 THEN ERROR 201
   IF DbfHdr.RecSize < 2 OR DbfHdr.RecSize > 4000 THEN ERROR 201
   IF DbfHdr.HdrSize < 63 OR DbfHdr.HdrSize > 8193 THEN ERROR 201
   IF DbfHdr.RecCount > 100000000 THEN ERROR 201

   ' close enough, so process it
   Yr$ = LTRIM$(RTRIM$(STR$(ASC(MID$(DbfHdr.LUpDate, 1, 1)))))
   Mo$ = LTRIM$(RTRIM$(STR$(ASC(MID$(DbfHdr.LUpDate, 2, 1)))))
   Day$ = LTRIM$(RTRIM$(STR$(ASC(MID$(DbfHdr.LUpDate, 3, 1)))))
   LUpDate$ = Mo$ + "/" + Day$ + "/" + Yr$
   MemoFlag = ASC(DbfHdr.ValFile) AND &HC0&
   IF MemoFlag > 0 THEN MemoFlag$ = "On" ELSE MemoFlag$ = "Off"
   IF ASC(DbfHdr.MdxFlag) > 0 THEN MdxFlag$ = "On" ELSE MdxFlag$ = "Off"
   IF ASC(DbfHdr.Encrypted) > 0 THEN EncryptFlag$ = "On" ELSE EncryptFlag$ = "Off"
   IF ASC(DbfHdr.IsMarked) > 0 THEN IsMarkedFlag$ = "On" ELSE IsMarkedFlag$ = "Off"
   RecCount! = DbfHdr.RecCount
   RecSize = DbfHdr.RecSize
   HdrSize = DbfHdr.HdrSize
   TotFields = (DbfHdr.HdrSize - 33) / 32

END SUB

'
'  ErrorMsg ..... display an error message for a given error number
'                 and abort the program.  note that error 201 is not
'                 a standard error code, but rather a program generated
'                 code for invalid dBase files.
'
SUB ErrorMsg
   SELECT CASE ERR
      CASE 52 TO 53
         PRINT "Invalid file name";
      CASE 201
         PRINT "Not a valid dBase III or IV .DBF file";
      CASE ELSE
         PRINT "Unrecoverable error "; ERR;
   END SELECT
   PRINT " -- Program aborted"
END SUB

