





                                       DBFOPEN
                              DONATED TO PUBLIC DOMAIN

          John T. Opincar, Jr.
          CID: 71631,541
          April 12, 1990

          DBFOPEN contains five functions: initdbfopen(), open(), isopen(),
          dclose(), and setorder().  These functions were designed to take
          the tedium out of managing databases, indexes, and areas.

          BEFORE YOU CAN USE THESE FUNCTIONS, YOU MUST PUT THE NAMES OF THE
          DATABASES AND THEIR RESPECITVE INDEXES INTO DICTION.DBF.  The
          structure of DICTION.DBF is fairly self-explanatory, except that
          the fields INDEX1..N must filled contiguously from INDEX1.
          Furthermore, INDEXCOUNT must accurately reflect the number of
          indexes listed in the record.

          Initdbfopen() will automatically rebuild DICTDATA.NTX if it does
          not exist.  After you modify the contents of DICTION.DBF, you
          should delete DICTDATA.NTX so that it will be rebuilt to refelect
          your changes.

          Data dictionaries are quite useful.  Mine is actually more
          complex than the one used with these functions, containing
          information such as index keys, pictures, valid clauses, field
          labels for input screens, etc.  I simplified this one to make it
          generally applicable, but you should consider expanding it to
          suit your own needs.

          The philosophy behind these functions is to USE and CLOSE
          databases only when absolutely necessary.  Open() only has to USE
          the database and incur the subsequent disk accesses if the
          database has not been previously opened, or, had to be closed to
          make room for databases opened more recently.  Dclose() never
          actually CLOSEs databases but only tells open() that they can be
          closed when necessary, ie the maximum number specified with
          initdbfopen() is exceeded.

          These functions were also designed to make managing databases and
          indexes more memnonic by allowing you to refer them by their
          names as opposed to numbers.

          Finally, by allowing you to specify the maximum number databases
          which can be open simultaneously, these functions allow you to
          arrive at the optimal compromise between memory consumption and
          execution time.

          If you have any questions or comments, don't hesitate to get in
          touch with me through nanforum or e-mail.
















          NOTE -- These functions were written for a multi-user
          environment.  If your application will not be running on a
          network, you can remove the network specific code.  But, this
          probably is not worth trouble.

          IMPORTANT NOTE -- You must enclose database and index names in
          quotes when passing them to these functions, eg open('clients',
          'cliename').

          One last comment.  Before you ask me why dclose() is necessary,
          consider the following scenario.  A record from a database with a
          large number of fields is being READ.  Several of the fields have
          VALIDs which call UDFs to verify input by looking the input up in
          a cross-reference database.  Depending on the maximum number of
          databases set with initdbfopen(), opening these subsequent
          databases could result in the main database being closed.  BUT,
          if the main database has not been dclosed, the cross-reference
          databases will replace each other in the priority queue, instead
          of the main database which must be open during the entire READ.

          If this cannot happen in your code, you could modify open() to
          ignore the opens array and dispense with dclose() altogether.
          Before you do this, though, I suggest you think carefully about
          what situations you might encounter in your code.










































          -----------------------------------------------------------------
                                     INITDBFOPEN
          -----------------------------------------------------------------

          Syntax:    initdbfopen(<expN>)

          Purpose:   Initializes supporting data structures.

          Arguments: <expN> is the maximum number of database that can be
                     opened simultaneously.

          Usage:     This function must be called before any of the other
                     functions are called, but it only should be called
                     once.  It opens DICTION.DBF, declares necessary public
                     variables, and initializes the data structures.  If it
                     cannot find DICTDATA.NTX, then that index will be
                     rebuilt.  This is useful when you change the contents
                     of DICTION.DBF because you can just erase DICTDATA.NTX
                     and it will be rebuilt to reflect your changes.















































          -----------------------------------------------------------------
                                        OPEN
          -----------------------------------------------------------------

          Syntax:    open(<expC1>, [<expC2>])

          Purpose:   USE the specified database if necessary, SELECT the
                     specified database, and set the controlling index, if
                     specified.

          Arguments: <expC1> is the name of the database to USE/SELECT.

                     <expC2> is an optional name of an index to be set to
                     the controlling index.  If this parameter is not
                     passed, then no index will control the order.

          Returns:   A logical.  .T. if the database and its supporting
                     indexes were successfully opened, .F. otherwise.

          Usage:     Open() will check to see if the specified database is
                     already in USE.  If it is not, then it will be opened
                     in an unused area, and all of the indexes listed in
                     DICTION.DBF will be opened with it.

                     If the database was not already in USE and opening it
                     caused the maximum number of areas specified with
                     initdbfopen() to be exceeded, then the open() will
                     take the following action:
                        * the specified database will be inserted at the
                          top of the priority queue
                        * open() will search from the bottom of the
                          priority queue for the first dclosed() database
                          and then physically CLOSE it.
                        * if there is no room in the queue, ie none of the
                          database has been dclosed(), the error system
                          will be called.

                      If open cannot open the requested database due to
                      EXCLUSIVE USE by another user, .F. will be returned.



























          -----------------------------------------------------------------
                                       DCLOSE
          -----------------------------------------------------------------

          Syntax:    dclose(<expC>)

          Purpose:   To "close" the specfied database.  The database is not
                     actually closed, but its slot in the priority queue is
                     made available.

          Arguments: <expC> is the name of the database to "close."

          Returns:   No return value.

          Usage:     Dclose() doesn't actually close the database, but only
                     marks the database so that if its slot is needed
                     later, it can be physically CLOSED.  Dclose() should
                     be called after the database has been opened with
                     open(), but is not longer needed.















































          -----------------------------------------------------------------
                                       ISOPEN
          -----------------------------------------------------------------

          Syntax:    isopen(<expC>)

          Purpose:   To determine whether the specified database has been
                     dclosed().  NOTE that a .F. return value does not
                     necessarily mean that the database is not in USE, only
                     that it has been dclosed and will be removed from the
                     queue and physically CLOSED if necessary.

          Arguments: <expC> is the name of the database.

          Returns:   A logical.  .T. if the database is open and has not
                     been dclosed().  .F. otherwise.

          Usage:     Isopen() allows you to determine whether the specified
                     database is in the priority queue AND has not been
                     dclosed().  This is useful when a VALID or hot key
                     function needs to acces a database, but if it has
                     already been opened() by the interrupted function,
                     then it should NOT be dclosed() on return.











































          -----------------------------------------------------------------
                                      SETORDER
          -----------------------------------------------------------------

          Syntax:    setorder([<expC>])

          Purpose:   To query and optionally set the index controlling the
                     order of the currently SELECTed database.

          Arguments: <expC> is an optional parameter specifying the name of
                     the index which will become the controlling index.

          Returns:   A character string.  The name of the currently
                     controlling index.  If no index was currently
                     controlling the order, then a null ('') string is
                     returned.

          Usage:     Setorder() allows you to manipulate indexes by
                     referring to them by name, as opposed to their ordinal
                     position when they were opened.  If you don't want any
                     index to control the order of the database, just pass
                     a null ('') string as the index name.  If you only
                     want to query which index is currently controlling,
                     then don't pass an index name at all.




































