;               dbega.asm - ega color control for dBASE

;       Author:   Jay Parsons, Somerset Data Systems, Inc.
;                 Voice (908) 766-5845, Fax (908) 766-0711
;                 Compuserve 70160,340, A-T BBS Jparsons

;       Version 1.1    August 16, 1991

;       Assemble, link and convert to a .bin with
;       Exe2bin, ignoring the "No stack" warning.
;       Sample batch file to automate the make:

;               MASM dbega,,;     or TASM dbega
;               LINK dbega,,;     or TLINK dbega
;               EXE2BIN dbega

;       Syntax to use the .bin within dBASE (after
;               "LOAD dbega"):

;               CALL dbega WITH String

;       where "String" is a variable or constant
;       containing 17 characters.  It may contain more;
;       extras will be ignored.  The characters specify
;       the colors to be placed in palette registers
;       0-15, in order, with the 17th character
;       specifying the border color.  If a call is made
;       with fewer than 17 characters, no changes will
;       be made.

;       Chr() values of the characters specify colors
;       in six bits indicating the presence or absence
;       of red, green and blue at 1/3 and at 2/3 value,
;       "rgbRGB". 000000 is black, 111111 bright white,
;       000111 dull white and 110100, with full red and
;       1/3 green, is tangerine.

;       Since chr(0) cannot be stored as part of a
;       dBASE string, specify black as chr(128).  The
;       .bin routine actually uses only the value
;       modulus 64 of each chr() value given.

cseg    segment para public 'code'
        assume cs:cseg,ds:cseg

start:  mov ax,cs               ; point es to code
        mov es,ax               ; for interrupt, too
        mov dx,offset buffer    ; save for interrupt
        mov di,dx               ; point di to buffer
        mov si,bx               ; point to string
        mov bx,111111b          ; 6 bits, 0 in bh
        mov cx,17               ; do 17 bytes
mloop:  lodsb                   ; get byte
        cmp al,bh               ; test for end
        jz done                 ; and quit if so
        and al,bl               ; mask it
        stosb                   ; save it
        loop mloop
        mov ax,1002h            ; set all registers
        int 10h                 ; ROM video interrupt
done:   retf
buffer  db 17 dup (0)

cseg    ends
end     start

