// (C) Antonio Linares, 1993. Designing new DataBase Classes at RunTime

// You should use -public domain- Objects.lib to test this prototype

#include "Objects.ch"
#include "InKey.ch"

//----------------------------------------------------------------------------//

function Main()

   local Agenda := TDb():New( "c:\agenda.dbf" ) // We are going to build a new
                                                // Class taking the info of the
                                                // fields from within the DBF

   SET COLOR TO "W+/B, W+/R,,, N/BG"
   CLS

   Agenda:Read()                                   // Load Info from Dbf

                                                   // Nombre, Apellidos...
                                                   // they are Fields names
   @ 2, 2 SAY "Nombre   :" GET Agenda:Nombre       // We are using an Object!
   @ 3, 2 SAY "Direccion:" GET Agenda:Apellidos    // We are using automatically
   READ                                            // a buffer to edit fields

   if LastKey() != K_ESC
      Agenda:Write()                               // Save changes to Disk
   endif

return

//----------------------------------------------------------------------------//

CLASS TDb

   DATA aBuffer

   METHOD New( cDbfName )
   METHOD Read()
   METHOD Write() BLOCK { | Self | AEval( ::aBuffer,;
                        { | u, n | FieldPut( n, u ) } ) }
ENDCLASS

//----------------------------------------------------------------------------//

METHOD New( cDbfName ) CLASS TDb

   local oDb, n

   USE ( cDbfName )

   ClsNew( Alias(), { { || TDb() } } )    // Objects.lib functions
   for n = 1 to FCount()
       ClsAddMethod( Field( n ), &( "{ | Self | Self[ 1 ][" + Str( n ) + "] }" ) )
       ClsAddMethod( "_" + Field( n ), &( "{ | Self, u | Self[ 1 ][" + Str( n ) + "] := u }" ) )
   next
   oDb = __ClassIns( nClsMake() )
   oDb:aBuffer = Array( FCount() )

return oDb

//----------------------------------------------------------------------------//

METHOD Read() CLASS TDb

   AEval( ::aBuffer, { | u, n | ::aBuffer[ n ] := FieldGet( n ) } )

return

//----------------------------------------------------------------------------//
