* Program Name: datadump.prg * GENERIC DATA DUMP PRINTING ROUTINE
* Author: J.Bundy *         * WRITTEN SPECIFICALLY FOR USE WITH
* (c) 1988 by DataBex *     * CLIPPER SUMMER '87 VERSION.
* SHAREWARE "DataDump" v1.00
**************************************************************************
* Created: 5/28/1988 at 11:46                                            *
* main =                                                                 *
* Revision:  Last Revised: 7/22/1988 at 12:00                            *
* Called From:                                                           *
* -- Data Base Files --   ---- Index Files ----   ----- Other Files ---- *
* THE DATABASE & INDEX USED ARE THE CURRENTLY SELECTED ONES.             *
*                                                                        *
*                                                                        *
*************************** ALL RIGHTS RESERVED **************************
* Purpose:
*    This program offers one generic approach to data dump reporting of 
*  large databases in a semi-acceptable and meaningful format.  Its purpose
*  is function, not beauty; information, not flash.  It has been designed as 
*  an alternative to "LIST TO PRINT" or other such similar commands.
*
*    Other than extreme use under grueling conditions, this program has
*  not undergone any other testing, enhancements, or modifications.  It
*  certainly has its limitations, but it has its functions also.
*
*    The specific problem of data "wrapping" around on a page when there
*  are too many fields to quickly "LIST TO PRINT" in a dBASE environment, 
*  is what this program was originally designed to do.  The data will be
*  presented in a 232 column format (you must change the page width variable
*  in the source if the connected printer will not support that width), with
*  the field names being printed above each column of associated data. One
*  line per record, per page.  If there are more columns than will fit on
*  a page, (which is the whole idea anyway), then first all the records will
*  be printed for all the fields that will fit in 232 columns, then starting
*  with the next field, the remainder of the fields will be printed. 
*  ALWAYS ONE RECORD PER LINE.  The default "key" field which serves as 
*  identification from page to page is the first field.  You must change
*  this if this is not particularly suited to your application at hand.
*  Do change simply pass a parameter to "DATADUMP.PRG" when calling it.
*  The parameter must be a valid field name of the database in use at
*  the time "datadump" is called.
*
*  When the last field/column is printed the indicator <end> is printed
*  in the header at the top of the page. This lets you know there are no
*  more FIELDS to print.  The report will stop when all of the RECORDS have
*  been printed or until printing is interrupted.
*
*  Printing may be interrupted at any time by striking any key.
*
*  Fields may be selected either individually in a random fashion, or
*  by blocks of fields, in a contiguous fashion.  
*
*  When selecting fields individually, you need to specify IN ADVANCE what
*  is the LAST field that will possibly be used.  The system simply needs to
*  know IN ADVANCE the maximum POTENTIAL size of the report.  The report
*  will not include any fields beyond that LAST field specified.  Other than
*  that, there are not any idiosyncrasies that have been noted.  
*
*  When selecting fields by block, the fields MUST BE CONTINGUOUS.
*
*  Of course, you have the option of simply selecting ALL fields.
*
*  The little front end program called "DT.PRG" is certainly no more than
*  that: a little front end program.  There is no error trapping for 
*  file or index existence, no pretty titles or labels.  Anybody can design
*  a better front end than this.  It does work however!
*
*  All of my working comments and notes have been left in the code.
*  Hopefully they can be of use in understanding the internals of the 
*  program.  If not, don't worry about it; just use the program.
*
*  If you find this to your liking, share it with another developer you like.
*  If not, share it with a developer you don't like.
*
*  You are free to modify, destroy, enhance, expound, elaborate, and other-
*  wise do anything you want to do with any/all of this code, EXCEPT SELL IT.
*  It is simply one approach to a generic reporting facility, used in either
*  a stand-alone fashion, or even integrated into an application if you wish. 
*  
*
*
*
*
*
*
*
*
***PARAMETERS
PARA KFIELD
* PAGE WIDTH 80,132,232
* SCREEN/PRINTER
* KEY FIELD (field to be printed on following pages if than 1 page of fields.)
* ?? OTHERS ??
* # of fields per page
* names of fields for page break
oldcolor=setcolor() && save previous color
save screen
*******************************
** VARIABLE/ARRAY DEFINITION **
*******************************
PRIVATE HH,PG,L,FTITLE
SET SCOR OFF
FTITLE='Field-Block Specific Data Report'
NEWKEY=0
RWIDE=232 && MAXIMUM REPORT WIDTH
CENTER=INT(RWIDE/2) && SET CENTER ACCORDING TO WIDTH
HH='Y' && HEADER INDICATOR
PG=1   && PAGE COUNTER
L=1    && LINE COUNTER
STOR "REPL('-',RWIDE)" TO LINE1
STOR "REPL('=',RWIDE)" TO LINE2
STOR "REPL('_',RWIDE)" TO LINEU
*STOR "REPL(CHR(196),RWIDE)" TO LINE1
*STOR "REPL(CHR(205),RWIDE)" TO LINE2
*STOR "REPL('_',RWIDE)" TO LINEU
*** TITLE VARIABLES
STOR '' TO TITLE0,TITLE1,TITLE2,TITLE3,TITLE4,TITLE5
STOR 'DATA REPORT' TO TITLE0
TITLE1=ALIAS()
INTERRUPT=0
*** declare arrays of field name, type, length, and decimal
XF=FCOUNT()
DECL fnam[fcount()], ftyp[fcount()], flen[fcount()], fdec[fcount()]
*** declare report field header
DECL fhead[fcount()], fcol[fcount()], flast[fcount()], fsele[fcount()]
AFIELDS(fnam, ftyp, flen, fdec)
AFILL(flast,FCOUNT()+1) && DEFAULT LAST TO MAX+1 /* OFF */
AFILL(fsele,FCOUNT()+1) && DEFAULT SELECTED TO MAX+1 /* OFF */
***DEFAULT KEY FIELD AS FIELD 1
if pcount()=0
   kfield=FNAM[1]
endi
KNUM=ASCAN( fnam, (KFIELD) ) && number of the array element for KFIELD (KEY FIELD)
*** ASSIGN KEY FIELD HEADER & COLUMN DATA
IF KNUM<>0
   fhead[KNUM]=KFIELD
   fcol[KNUM]=5
ENDI
FIRST=0
XFLAST=XF
***************************************************
** SPECIFIC #  OR AS MANY AS CAN FIT ON ONE PAGE **
***************************************************
SET COLO TO gr+/rb
clea
@ 00,00 TO 24,79 
*** SCREEN INFO
SET COLO TO W+/R
@ 00,(40-(LEN(FTITLE)/2)) say ftitle
@ 01,01 CLEA TO 01,78
@ 01,01 say 'File: '+title1
@ 01,20 say 'Total Fields: '+str(fcount(),len(ltrim(str(fcount()))))
@ 01,50 say 'Key Field: '+kfield
SET COLO TO gr+/rb
STOR ' ' TO CH
@ 08,20 say '͸'
@ 09,20 say ' A)ll fields               '
@ 10,20 say ' S)elect fields            '
@ 11,20 say ' B)locks of fields         '
@ 12,20 say '   (contiguous)            '
@ 13,20 say ' eX)it                     '
@ 14,20 say ';'
@ 15,20 say ' Please Select (A/B/S/X)' GET CH PICT '!' VALID(CH$'ABSX')
READ
*************
***  EXIT ***
*************
IF CH$'X'
   CLOS DATA
   REST SCREEN
   SETCOLOR(OLDCOLOR)
   RETU
ENDI
************************************ 
** CHOICE TITLE / BLOCK or SELECT **
************************************
STITLE=''
DO CASE
   CASE CH$'B'
      STOR ' SELECT BY BLOCK ' TO STITLE
   CASE CH$'S'
      STOR ' SELECT BY FIELD ' TO STITLE
ENDC
****
SET COLO TO GR+/N
@ 02,50 SAY STITLE
SET COLO TO gr+/rb
@ 03,01 CLEA TO 23,78
IF CH$'BS'
   @ 03,20 SAY 'SELECT LAST FIELD TO PRINT OR <ESC> FOR ALL'
   set colo to w+/r
   @ 04,19 to 21,32 doub
   FLD=ACHOICE(05,20,20,31,fnam)
   XFLAST=IIF(FLD=0,XF,FLD)
   SET COLO TO GR+/RB
@ 03,01 CLEA TO 23,78
   @ 03,20 SAY 'First field chosen is starting field'
ENDI
********* GO AROUND THIS IF OPTION IS "A"
IF .NOT. CH$'A'
set colo to gr+/b
@ 04,39 clea to 23,73
@ 04,39 to 23,73
@ 04,40 say 'PAGE/LAST FIELD ON PAGE'
set colo to w+/r
@ 04,19 to 21,32 doub
T=1
R=5
C=40
INITE=1
INITR=0
MORE='Y'
XPASS=0 && SET FLAG TO FALSE
DO WHIL .T.
   FLD=ACHOICE(05,20,20,31,fnam,.T.," ",INITE,INITR)
   IF FLD=0
      EXIT
   ENDI
   *** CHOSEN VALUES HERE
   FSELE[FLD]=FLD
   FLAST[FLD]=FLD
    INITR=ROW()-4
    INITE=IIF((FLD+1)<=XF,(FLD+1),FLD)
*   INITE=IIF((INITE+INITR)<=XF,FLD+(INITR+1),FLD)
    INITR=0 && RESET TO TOP
   IF CH$'BS'.and.XPASS=0
      SET COLO TO GR+/RB
      @ 03,20 CLEA TO 03,78
      @ 03,20 SAY 'Enter LAST field to Print per page. <ESC>=Finished.'
      FIRST=FLD
      XPASS=1 && TURN OFF FLAG
   ENDI
   set colo to GR+/B
   @ R,C SAY SPAC(15) && CLEAN FOR MULTIPLE PASSES
   @ R,C SAY STR(T,LEN(LTRIM(STR(T))))+'.)'+FNAM[FLD]
   R=R+1
   T=T+1
   IF R>22
      R=5
      C=IIF(C=40,C+17,40)
   ENDI
   set colo to w+/r
ENDD
ENDI && OPTION .NOT. "A"
**************END OF GO AROUND
SET COLO TO GR+/RB
@ 03,01 CLEA TO 23,78
****************************
** FCOUNT PROCESSING LOOP **
****************************
i=IIF(FIRST=0,1+FIRST,FIRST)
*** RESET XF IN CASE NOT STARTING WITH FIRST FIELD
XF=XFLAST
do whil i<=XF
   CWIDE=5 && INITIAL CURRENT REPORT WIDTH TO ZERO
   *** INCREASE WIDTH FOR KEY FIELD
   cwide=(cwide+IIF( ((flen[KNUM])+2)<(len(fnam[KNUM])+2),len(fnam[KNUM])+2,(flen[KNUM])+2) )
   pass=1
   oldi=i && starting place
   DO WHIL CWIDE <=RWIDE .AND. I<=XF
      *** IF "S" SELECT FIELDS ONLY
      IF CH$'S'
         IF FSELE[I]<>I
            I=I+1
            LOOP
         ENDI
      ENDI
      *** CHECK IF KEY FIELD OR NOT
      IF I=KNUM
         I=I+1
         LOOP
      ENDI
      fcol[i]=cwide && assign field column #
      cwide=(cwide+IIF( ((flen[i])+2)<(len(fnam[i])+2),len(fnam[i])+2,(flen[i])+2) )
      IF CWIDE>RWIDE
         LOOP
      ENDI
      fhead[i]=fnam[i] && assign field header
      *** USE LAST FIELD INDICATOR
      IF CH$'B'.AND.I<>FIRST && BLOCK SELECT INDICATOR
         IF I=FLAST[I] && LAST FIELD INDICATOR
            CWIDE=RWIDE+1
         ENDI
      ENDI
      i=(i+1)
      pass=(pass+1)
   endd
      *** [ more >>> ] indicator
      MORE=IIF(I<XF,'Y','N')
   ***************************
   ** DATA PRINTING SECTION **
   ***************************
   GO TOP
   CREC1=1
   LREC1=RECC()
   interrupt=0
***set up prinutil box
***
*** PRINUTIL : format file
*** Generated February 19, 1988
***
set devi to scre
SET COLOR TO +GR/N
@ 10,20,16,58 BOX "Ŀ"
@ 10,20 SAY ""
@ 10,45 SAY "͸"
@ 16,20 SAY ""
@ 16,57 SAY ";"
SET COLOR TO N/BG
@ 11,21,15,57 BOX "         "
SET COLOR TO +W/B
@ 10,33 SAY ""+chr(16)+" Printing "+chr(17)+""
@ 16,22 SAY "Press ANY KEY to interrupt printing"
SET COLO TO GR+/RB
set devi to prin
***
   @ 12,22 CLEA TO 12,56
   DO WHIL .NOT. EOF().AND.INTERRUPT=0
      SET DEVI TO SCRE
      @ 12,22 SAY 'PROCESSING # '+STR(CREC1,LEN(LTRIM(STR(CREC1))))+' OF '+STR(LREC1,LEN(LTRIM(STR(LREC1))))
      SET DEVI TO PRIN
      ************
      ** HEADER **
      ************
      IF HH='Y'
         @ 01,00 SAY &LINE1
         @ 02,(CENTER-(LEN(TITLE0)/2)) SAY TITLE0
         @ 02,RWIDE-10 SAY iif(MORE='Y', 'more >>>', '( end.)')
         @ 03,01 SAY 'RUN DATE: '+DTOC(DATE())
         @ 03,(CENTER-(LEN(TITLE1)/2)) SAY TITLE1
         @ 03,RWIDE-10 SAY 'PAGE: '+STR(PG,(LEN(LTRIM(STR(PG)))))
         @ 04,00 SAY &LINE1
         ****
         @ 05,05 say FHEAD[KNUM]
         FOR X=oldi TO i-1
            DO CASE
               CASE CH$'S'  && SELECT FIELDS ONLY
               IF FSELE[X]=X
                  @ 05,fcol[x] say iif(x=knum,'',FHEAD[X])
               endi
               CASE CH$'AB'  && BLOCKS OF CONTIGUOUS FIELDS
                  @ 05,fcol[x] say iif(x=knum,'',FHEAD[X])
            ENDC
         NEXT
         @ 06,00 SAY &LINE1
         HH='N'
         PG=(PG+1)
         L=7
      ENDI
      ************
      ** DETAIL **
      ************
      @ L,05 SAY A->&KFIELD.
      FOR X=oldi to i-1
               XFIELD=+FNAM[X]
         do case
            case ch$'S' && select fields only
            if fsele[X]=X
               ** @ L,fcol[x] say A->(XFIELD) && /* THIS DOES NOT WORK ! */
               @ L,fcol[x] say iif(x=knum,'',a->&xfield.)
            endi
            case ch$'AB' && BLOCKS OF CONTIGUOUS FIELDS
               @ L,fcol[x] say iif(x=knum,'',a->&xfield.)
         endc
      NEXT
      L=L+1
      IF L>55
         HH='Y'
      ENDI
      SKIP
      CREC1=(CREC1+1)
      **********PRINTING INTERRUPT
      INTERRUPT=INKEY()
      IF INTERRUPT<>0 && KEY HAS BEEN PRESSED
         SET ESCA OFF
         SET DEVI TO SCRE
         SET COLO TO GR+/N
         @ 17,22 SAY '    A KEY HAS BEEN PRESSED     '
         @ 18,22 SAY 'Press <ESC> to  ABORT Printing '
         @ 19,22 say 'or any other key to continue...'
         newkey=0
         do whil newkey=0
            newkey=inkey()
         endd
         IF NEWKEY<>27
            INTERRUPT=0
         ELSE
            EXIT && BREAK OUT OF LOOP
         ENDI
         SET COLO TO GR+/RB
         @ 17,22 SAY '                               '
         @ 18,22 SAY '                               '
         @ 19,22 say '                               '
         SET DEVI TO PRIN
         SET ESCA ON
      ENDI && INTERRUPT=0
   ENDD && EOF()
   IF NEWKEY=27
      I=(XF+1)
   ENDI
   HH='Y'
ENDD && XF
***FLUSH & TOF()
SET DEVI TO PRIN
@ 0,0 SAY ' '
SET DEVI TO SCRE
rest screen
setcolor(oldcolor)
RETU
*** END OF DATADUMP.PRG

