/*************************************************************************
   C O M A N D O S     P A R A     U S A R     C O N     C U A W I S E

  (c) Francisco Morero Peyrona
 
**************************************************************************/

static bKDown, bKUp



//------------------------- PUSH BUTTON ----------------------------------

#command @ <nRow>, <nCol> BUTTON <cLabel>                                ;
                         [WHEN <bWhen>]                                  ;
                         [EXECUTE <bExec>]                               ;
                         [COLOR <cColor>]                                ;
                                                                         ;
      => AAdd( GetList, PbtNew( <nRow>, <nCol>, <cLabel>, [<{bWhen}>],   ;
                                [<{bExec}>], [<cColor>] ) )



//-------------------------- LIST BOX ------------------------------------

#command @ <nRow>, <nCol> GET <uVar> LISTBOX <aArray>                     ;
                         [LABEL <cLabel>]                                 ;
                         [SIZE <nAlto>, <nAncho>]                         ;
                         [WHEN <bWhen>]                                   ;
                         [VALID <bValid>]                                 ;
                         [BOX <cBox>]                                     ;
                         [COLOR <cColor>]                                 ;
                                                                          ;
      => AAdd( GetList, ListNew( <nRow>, <nCol>, [<nAlto>], [<nAncho>],   ;
                        { | u | If( u == nil, <uVar>, <uVar> := u ) },    ;
                        <"uVar">, <aArray>, [<cLabel>], [<{bWhen}>],      ;
                        [<{bValid}>], [<cBox>], [<cColor>] ) )



//--------------------------- COMBO BOX ----------------------------------

#command @ <nRow>, <nCol> SAY <cLabel> GET <uVar> COMBO <aItems>          ;
                         [PICTURE <cPic>]                                 ;
                         [HIGH <nAlto>]                                   ;
                         [WHEN <bWhen>]                                   ;
                         [VALID <bValid>]                                 ;
                         [BOX <cBox>]                                     ;
                         [COLOR <cColor>]                                 ;
                                                                          ;
      => SetPos( <nRow>, <nCol> ) ; DevOut( <cLabel>,                     ;
           aStr2Array( If( <cColor> == nil, SetColor(), <cColor> )[1] ) );;
         AAdd( GetList, ComboNew( <nRow>, <nCol>, <cLabel>,               ;
               { |x| If( x == nil, <uVar>, <uVar> := x ) },               ;
               <"uVar">, <aItems>, <cPic>, <nAlto>, <{bWhen}>, <{bValid}>,;
               <cBox>, <cColor> ) )



//--------------------------- CHECK BUTTON -------------------------------

#command @ <nRow>, <nCol> GET <lVar> CHECK <cItem>                       ;
                         [LABEL <cLabel>]                                ;
                         [WHEN <bWhen>]                                  ;
                         [VALID <bValid>]                                ;
                         [COLOR <cColor>]                                ;
                                                                         ;
         => AAdd( GetList, CheckNew( <nRow>, <nCol>,                     ;
            { |x| If( x == nil, <lVar>, <lVar> := x ) },                 ;
            <"lVar">, <cItem>, [<cLabel>],                               ;
            [<{bWhen}>], [<{bValid}>], [<cColor>] ) )



//------------------------- CHECK BUTTON MENU ----------------------------

#command GET <lVar> CHECK <cItem> ADD                                    ;
                                                                         ;
      => CheckAdd( { |x| If( x == nil, <lVar>, <lVar> := x ) }, <cItem> )



//------------------------- RADIO BUTTON MENU -----------------------------

#command @ <nRow>, <nCol> GET <nVar> RADIO <aArray> [LABEL <cLabel>]      ;
                         [WHEN <bWhen>]                                   ;
                         [VALID <bValid>]                                 ;
                         [COLOR <cColor>]                                 ;
                                                                          ;
      => AAdd( GetList, RadioNew( <nRow>, <nCol>,                         ;
                        { | u | If( u == nil, <nVar>, <nVar> := u ) },    ;
                        <"nVar">, <aArray>, [<cLabel>],           ;
                        [<{bWhen}>], [<{bValid}>], [<cColor>] ) )



//------------------ ACCIONES EN BOTONES Y OTRAS COSAS  -------------------

#define BTM_OK     __Keyboard( Chr( 23 ) )   // K_CTRL_END
#define BTM_CANCEL __Keyboard( Chr( 27 ) )   // K_ESC

#command CUAREAD => bKDown := SetKey( 24 )                               ;;
                    bKUp   := SetKey( 5 )                                ;;
                    SetKey( 24, { || ComboCua( GetActive() ) } )         ;;
                    SetKey(  5, { || nil } )                             ;;
                    READ                                                 ;;
                    SetKey( 24, bKDown )                                 ;;
                    SetKey(  5, bKUp )
