*****************************************************
*
*  Simple Sample Program to demonstrate the use
*  of CShelp.
*
*****************************************************

PUBLIC HELPFILE
PRIVATE MSEL, STARTCOLOR

HELPFILE = "SAMPLE.HLP"
STARTCOLOR = SETCOLOR()

SET WRAP ON
SET CURSOR OFF
SET CONFIRM ON
SET SCOREBOARD OFF
SET MESSAGE TO 22 CENTER

if iscolor()
   c_cute      = "RB+/N"
   c_menu      = "N/W,W+/N"
   c_says      = "W+/B,W+/BR,,,N/B"
   c_gets      = "N/W,GR+/N,,,R/W"
else
   c_cute      = "W+/N"
   c_menu      = "N/W,W+/N"
   c_says      = "W/N, N/W"
   c_gets      = "W/N, N/W"
endif

SAVE SCREEN TO STARTUP

set color to &c_cute
@ 0,0 clear

TEXT
              
          ۲          JUST A SIMPLE LITTLE            ۲
          ۲۰۲
          ۲                           ۰۲     P
    S     ۲                           ۰۲
          ۲۰۲     R
    A     ۲                                        ۰۲
          ۲                                        ۰۲     O
    M     ۲                                        ۰۲
          ۲                                        ۰۲     G
    P     ۲                                        ۰۲
          ۲                                        ۰۲     R
    L     ۲                                        ۰۲
          ۲۰۲     A
    E     ۲                              ۰۲
          ۲                              ۰۲     M
          
          ۲  ͻ۲  ۲
          ۲   HIT THE <F1> KEY FOR HELP ۲  ۲
          ۲  ͼ۲  ۲
          ۲    ۲
          ۲                                        ۲
          
ENDTEXT
SET COLOR TO &c_menu
@ 07,19 CLEAR TO 13,58
@ 07,20 TO 13,57 DOUBLE
SAVE SCREEN TO MAINSCREEN

DO WHILE .T.
    set color to &c_menu
    @08,21 PROMPT "                FILE                " ;
                          MESSAGE " Update and maintain database. "
    @10,21 PROMPT "                DOS!                " ;
                          MESSAGE " Shell out to Operating System."
    @12,21 PROMPT "                QUIT                " ;
                          MESSAGE "    Quit and return to DOS     "
    MENU TO MSEL
    DO CASE
       CASE M->MSEL = 1
          DO FILESTUFF
       CASE M->MSEL = 2
          SET COLOR TO "W/N"
          @ 0,0 CLEAR
          RUN COMMAND
       CASE M->MSEL = 3
          IF AnswerYes(" Are you sure you want to return to DOS ")
              POPSTAT("Sorry about that last query but I just couldn't"+;
                      " help myself",5)
              SETCOLOR(STARTCOLOR)
              EXIT
          ENDIF
    ENDCASE
    set color to &c_says
    REST SCREEN FROM MAINSCREEN
ENDDO
SET CURSOR ON
RESTORE SCREEN FROM STARTUP
@ 24,0
RETURN

PROCEDURE FILESTUFF
PRIVATE OldColor
OldColor=SetColor(c_gets)
USE SAMPLE
PRIVATE SEL2, V_NAME, V_STREET, V_CITY, V_STATE, V_ZIP, V_PHONE, V_SEX, V_AGE
PRIVATE PANEL1
DO SETPANEL
DO WHILE .T.
    RESTORE SCREEN FROM PANEL1
    IF !eof()
        DO READ_VARS
    ELSE
        DO BLANKVARS
    ENDIF
    DO DISPLAY
    SET COLOR TO &c_says
    @ 01,10 SAY str(RecNo(),5)+" of "+str(LastRec(),5)
    @ 01,50 SAY if( deleted() , "<  D E L E T E D > ", "                  ")
    SET COLOR TO &c_gets
    @ 14,15 PROMPT " ADD "  MESSAGE "   Add a new record to the database.   "
    @ 14,21 PROMPT " UPD "  MESSAGE "Update the currently displayed record. "
    @ 14,27 PROMPT " DEL "  MESSAGE "        Delete/Undelete Toggle         "
    @ 14,33 PROMPT " PREV "   MESSAGE " Move back one record in the database. "
    @ 14,40 PROMPT " NEXT "   MESSAGE "Move ahead one record in the database. "
    @ 14,47 PROMPT " ERASE "  MESSAGE "           Pack the database           "
    @ 14,55 PROMPT " QUIT "  MESSAGE "        Return to the Main Menu        "
    MENU TO SEL2
    DO CASE
       CASE SEL2 = 1
          DO ADD
       CASE SEL2 = 2
          IF !EOF()
              DO READ_VARS
          ELSE
              LOOP
          ENDIF
          DO UPD
          IF UPDATED() .AND. !LASTKEY() == 27
             DO STORE_IT
          ENDIF
       CASE SEL2 = 3
          IF DELETED()
             RECALL
          ELSE
             DELETE
          ENDIF
       CASE SEL2 = 4
          SKIP -1
          IF BOF()
             STAT_MSG("Beginning of file.")
          ENDIF
       CASE SEL2 = 5
          SKIP
          IF EOF()
             STAT_MSG("End of File.")
             SKIP -1
          ENDIF
       CASE SEL2 = 6
          IF AnswerYes("Are you sure you want to PACK the database NOW")
               SET COLOR TO &c_says
               @ 0,0 SAY "Packing Database.."
               PACK
               @ 0,0
          ENDIF
       CASE SEL2 = 7
            EXIT
    ENDCASE
ENDDO
CLOSE DATABASE
RETURN

PROCEDURE ADD
PRIVATE OldRec
OldRec=RecNo()
DO BLANKVARS
@ 3,11 GET V_NAME   PICT "@K!"
@ 3,49 GET V_STREET PICT "@K!"
@ 5,11 GET V_CITY   PICT "@K!"
@ 5,48 GET V_STATE  PICT "@K!"
@ 5,63 GET V_ZIP    PICT "@K!"
@ 8,40 GET V_PHONE  PICT "@K! (###) ###-####"
@ 9,40 GET V_AGE    PICT "@K!"
@ 10,40 GET V_SEX   PICT "@K!"
SET CURSOR ON
READ
SET CURSOR OFF
IF UPDATE() .AND. !LASTKEY() == 27
    APPEND BLANK
    DO STORE_IT
    STAT_MSG("One record added to Database.")
ELSE
    POPSTAT("NO NEW RECORD ADDED.. ABORTED BY OPERATOR!",5)
    Goto OldRec
ENDIF
RETURN

PROCEDURE UPD
   @ 3,11 GET V_NAME   PICT "@K!"
   @ 3,49 GET V_STREET PICT "@K!"
   @ 5,11 GET V_CITY   PICT "@K!"
   @ 5,48 GET V_STATE  PICT "@K!"
   @ 5,63 GET V_ZIP    PICT "@K!"
   @ 8,40 GET V_PHONE  PICT "@K! (###) ###-####"
   @ 9,40 GET V_AGE    PICT "@K!"
   @ 10,40 GET V_SEX   PICT "@K!"
   SET CURSOR ON
   READ
   SET CURSOR OFF
RETURN


PROCEDURE BLANKVARS
    V_NAME  = SPACE(24)
    V_STREET = SPACE(24)
    V_CITY = SPACE(24)
    V_STATE = SPACE(2)
    V_ZIP = SPACE(5)
    V_PHONE = SPACE(14)
    V_SEX = " "
    V_AGE = SPACE(3)
RETURN

PROCEDURE SETPANEL
SET COLOR TO &c_says
@ 0,0 CLEAR
SET COLOR TO &c_gets
TEXT

   Ŀ
    NAME:                              STREET:                             
   Ĵ
    CITY:                              STATE:     ZIP CODE:               
   Ĵ
                                                                            
                         Phone Number:                                      
                                  Age:                                      
                                  Sex:                                      
                                                                            
   


ENDTEXT
SAVE SCREEN TO PANEL1
RETURN


PROCEDURE READ_VARS
IF !eof()
   STORE NAME TO V_NAME
   STORE STREET TO V_STREET
   STORE CITY TO V_CITY
   STORE STATE TO V_STATE
   STORE ZIP TO V_ZIP
   STORE PHONE TO V_PHONE
   STORE SEX TO V_SEX
   STORE AGE TO V_AGE
ELSE
   STAT_MSG("End of File.")
ENDIF
RETURN

PROCEDURE DISPLAY
    @ 3,11 SAY V_NAME
    @ 3,49 SAY V_STREET
    @ 5,11 SAY V_CITY
    @ 5,48 SAY V_STATE
    @ 5,63 SAY V_ZIP
    @ 8,40 SAY V_PHONE PICT "(###) ###-####"
    @ 9,40 SAY V_AGE
    @ 10,40 SAY V_SEX
RETURN

PROCEDURE STORE_IT
REPLACE NAME WITH V_NAME, STREET WITH V_STREET, CITY WITH V_CITY, ;
        STATE WITH V_STATE, ZIP WITH V_ZIP, PHONE WITH V_PHONE, SEX ;
        WITH V_SEX, AGE WITH V_AGE
RETURN

PROCEDURE BEEP
TONE(499, 2)
RETURN

PROCEDURE STAT_MSG
PARAMETERS STRING
@ 0,0 SAY STRING
BEEP()
@ 0,0
RETURN


PROCEDURE POPSTAT
PARAMETERS STRING, DELAY
PRIVATE OldColor, BS, BL, WINBUFF
OldColor=SetColor("W+/R")
BL = LEN(M->STRING) + 5
BS = 39 - INT( BL / 2 )
WINBUFF = SAVESCREEN(12,BS,14,BS+BL)
@ 12,BS CLEAR TO 14,BS+BL
@ 12,BS TO 14,BS+BL
@ 13,BS+2 SAY LTRIM(M->STRING)
INKEY(DELAY)
SetColor(OldColor)
RESTSCREEN(12,BS,14,BS+BL,WINBUFF)
RETURN

FUNCTION CENTERTEXT
PARAMETERS S, W
PRIVATE PADDING
PADDING=SPACE( W - LEN(S) % 2)
S = PADDING+S+PADDING
S = IF( LEN(S) < W, S+" ",S)
RETURN S

FUNCTION AnswerYes
PARAMETERS STRING
PRIVATE C, OldColor, BS, BL, WINBUFF, Ret_val
C = ' '
OldColor=SetColor("W+/G")
BL = LEN(M->STRING) + 9
BS = 39 - INT( BL / 2 )
WINBUFF = SAVESCREEN(12,BS,14,BS+BL)
@ 12,BS CLEAR TO 14,BS+BL
@ 12,BS TO 14,BS+BL
DO WHILE !M->C $ "YN"+CHR(27)
    @ 13,BS+1 SAY M->STRING+"( Y/N )"
    C = UPPER(CHR(INKEY()))
ENDDO
Ret_val=if( C=='Y',.T.,.F.)
SetColor(OldColor)
RESTSCREEN(12,BS,14,BS+BL,WINBUFF)
RETURN Ret_val
