******************* Source Code for Communications **********************
* This is to provide Communications for "RepMan".
*
* Online Search
* Author: Les M. Guyse
* November 1987
*
* Create a database with the following structure and create 22 blank records.
*
* Structure for database: comphone.dbf
* Field  Field Name  Type       Width    Dec
*    1  NAME        Character     20
*    2  PHONE       Character     11
*    3  MULTINUM    Logical        1
*    4  USERID      Character     10
*    5  PASSWORD    Character     14
*    6  BAUDRATE    Numeric        5
*    7  DUPLEX      Character      1
*    8  WORDLENGTH  Numeric        1
*    9  STOPBITS    Numeric        1
*   10  PARITY      Numeric        1
*** Total **                      66

CLEAR

SET SCOREBOARD OFF

STATCOL='W+/N'                  && Enhanced: Black on White
HELPCOL='W+/N'
NORM='W/N,N/W,N,,N/W'           && Monochrome mode
REV='N/W'
HI='W+/N'
REVHI='N+/W'
NORMFL='W*/N'
REVFL='N*/W'
NORMHIFL='W+*/N'
REVHIFL='N+*/W'

SET COLOR TO &NORM
CLEAR
@ 04,05 SAY " "
@ 05,05 SAY " "
@ 06,05 SAY " "
@ 07,05 SAY "                                  "
@ 08,05 SAY "      Online Search Presents      "
@ 09,05 SAY "                                  "
@ 10,05 SAY "          C o m m M a n  !        "
@ 11,05 SAY "                                  "
@ 12,05 SAY "۱ "
@ 13,05 SAY " "
@ 14,05 SAY " "
@ 15,05 SAY " "

* Check to see what comm ports exist and see if there is any active device
* presently responding.
STORE .F. TO port1,port2,active1,active2,smodem1,smodem2
STORE -1 TO port

* Set up default baud protocol values
mbaud = 1200
mparity = 0
msbits = 1
mwlength = 8
mduplex = "1"
mdial = "T"

DO PORTCHK WITH port1,port2,active1,active2,smodem1,smodem2

SET COLOR TO &NORM
@ 00,00 CLEAR TO 03,79
SET COLOR TO &REV
@ 00,00
SET COLOR TO &REVFL
@ 00,10 SAY "Initializing Communications and Selecting SmartModem Port..."
SET COLOR TO &NORM

DO CASE
    CASE active1 .AND. smodem1
        port = 1
    CASE active2 .AND. smodem2
        port = 2
ENDCASE

IF port < 1
    ? CHR(7)
    CLEAR
    @ 10,13 SAY "Sorry, I didn't detect any Smartmodems on any COM port!"
    @ 11,13 SAY "    Please check your configuration and try again."
    CLOSECOMM(1)
    SWDELAY(1 * 18)
    CLOSECOMM(2)
    SWDELAY(2 * 18)
    INKEY(0)
    CLEAR
    QUIT
ENDIF

merror = OPENCOMM(port,2000,400)
SWDELAY(1 * 18)
IF merror <> 0
    ? CHR(7)
ENDIF

merror = SMRESET(port)
SWDELAY(1 * 18)
IF merror <> 0
    ? CHR(7)
ENDIF

merror = SETBAUD(port,mbaud,mparity,msbits,mwlength)
SWDELAY(1 * 18)
IF merror <> 0
    ? CHR(7)
ENDIF

merror = SMDIALMODE(port,mdial)
SWDELAY(1 * 18)
IF merror <> 0
    ? CHR(7)
ENDIF
    
RXFLUSH(port)
TXCHAR(port,CHR(12))  && This should clear the screen when in Terminal Mode.

DO TERMINAL WITH port,mbaud,mparity,msbits,mwlength,mduplex,mdial

CLEAR
SET COLOR TO &REV
@ 00,00
SET COLOR TO &REVFL
@ 00,29 SAY "Resetting Equipment..."
SET COLOR TO &NORM
SMESCAPE(port)
SMSWHOOK(port,"0")
SWDELAY(1 * 18)
CLOSECOMM(port)
SWDELAY(1 * 18)

CLEAR
RELEASE port,mbaud,mparity,msbits,mwlength,mduplex,mdial
QUIT
*****************************************************************************
PROCEDURE TERMINAL

PARAMETERS port,mbaud,mparity,msbits,mwlength,mduplex,mdial

SET KEY 28 TO GUYCOMMHLP

CLEAR

DO WHILE .T.

    IF NUM_COLOR("F")=7 .AND. NUM_COLOR("B")=0  && i.e. Monochrome
        SET COLOR TO &NORM
    ELSE
        SET COLOR TO &REV
    ENDIF

    @ 00,00  && This erases the ALT F10 Header while in this

    mtask = 1
    SET MESSAGE TO   && THIS DISABLES MESSAGE GENERATION

    @ 00,00 PROMPT "Std-Term."
    @ 00,10 PROMPT "Ansi-Term."
    @ 00,21 PROMPT "Log-On"
    @ 00,29 PROMPT "Protocol-Set"
    @ 00,43 PROMPT "Modem-Cmds"
    IF STATUSCD(port)
        @ 00,55 PROMPT "DisConn"
    ELSE
        @ 00,55 PROMPT "Dialer"
    ENDIF
    @ 00,64 PROMPT "Transfer"
    @ 00,76 PROMPT "Quit"

    MENU TO mtask

    SET COLOR TO &NORM

    DO CASE
        CASE mtask = 1
            termexit = "A-F10"
            DO DISP_STAT WITH port,mbaud,mparity,msbits,mwlength,mduplex,mdial,termexit
            SWEMTTY(port,1,24,NUM_COLOR("B"),NUM_COLOR("F"))
        CASE mtask = 2
            termexit = "ESC"
            DO DISP_STAT WITH port,mbaud,mparity,msbits,mwlength,mduplex,mdial,termexit
            SWEMANSI(port,27)
        CASE mtask = 3
            DO LOG_ON WITH port
        CASE mtask = 4
            DO SET_BAUD WITH port,mbaud,mparity,msbits,mwlength,mduplex
        CASE mtask = 5
            DO SMCOMMANDS WITH port
        CASE mtask = 6
            IF STATUSCD(port)
                ? CHR(7)
                @ 00,00
                manswer = " "
                @ 00,00 SAY "Disconnect?" GET manswer;
                PICTURE "!" VALID manswer $ "YN"
                READ
                IF manswer = "Y"
                    SET COLOR TO &REV
                    @ 00,00
                    SET COLOR TO &REVFL
                    @ 00,32 SAY "Disconnecting..."
                    SET COLOR TO &NORM
                    SMESCAPE(port)
                    SMSWHOOK(port,"0")
                    SWDELAY(1 * 18)
                ENDIF
                RELEASE manswer
            ELSE
                DO PHONEBOOK WITH port,mbaud,mparity,msbits,mwlength,mduplex
            ENDIF
        CASE mtask = 7
            DO TRANSFER WITH port
        CASE mtask = 8
            EXIT
    ENDCASE

ENDDO

CLEAR
RETURN
*****************************************************************************
PROCEDURE TRANSFER

    PARAMETERS port

    IF ! STATUSCD(port)
        @ 00,00
        ? CHR(7)
        @ 00,19 SAY "Aborted!  You are not online with anyone!"
        INKEY(1)
    RETURN
ENDIF

IF NUM_COLOR("F")=7 .AND. NUM_COLOR("B")=0  && i.e. Monochrome
    SET COLOR TO &NORM
ELSE
    SET COLOR TO &REV
ENDIF

mtask = 1
@ 00,00  && This erases the Header

@ 00,00 PROMPT "Recieve Xmodem"
@ 00,15 PROMPT "Transmit Xmodem"

MENU TO mtask

IF LASTKEY()=27
    ? CHR(7)
    RETURN
ENDIF

SET COLOR TO &NORM
@ 00,00

mfilename = SPACE(25)
@ 00,2 SAY "Filename:" GET mfilename
READ

IF EMPTY(mfilename)
    ? CHR(7)
    RETURN
ENDIF

SET COLOR TO &REV
@ 00,00  && This erases the Header
SET COLOR TO &REVFL

DO CASE
    CASE mtask = 1
        @ 00,32 SAY "Recieving File..."
        merror = RXXMODEM(port,mfilename)
    CASE mtask = 2
        IF FILE(mfilename)
            @ 00,30 SAY "Transmitting File..."
            merror = TXXMODEM(port,mfilename)
        ELSE
            ? CHR(7)
        ENDIF
ENDCASE

IF merror <> 0
    ? CHR(7)
ENDIF

RELEASE mfilename
RETURN
*****************************************************************************

PROCEDURE DISP_STAT

PARAMETERS port,mbaud,mparity,msbits,mwlength,mduplex,mdial,termexit

SET COLOR TO &REV
@ 00,00
@ 00,00 SAY termexit+" Menu"
@ 00,13 SAY "Port "+STR(port,1)

IF mduplex = "F"
    @ 00,22 SAY [Dplx=Full]
ELSE
    @ 00,22 SAY [Dplx=Half]
ENDIF

@ 00,33 SAY "Baud Rate="+LTRIM(STR(mbaud,5))
@ 00,49 SAY "Word Len.="+STR(mwlength,1)
@ 00,62 SAY "S.Bits="+STR(msbits,1)
    
DO CASE
    CASE mparity = 0
        mdpar = "N"
    CASE mparity = 1
        mdpar = "O"
    CASE mparity = 2
        mdpar = "E"
ENDCASE
@ 00,72 SAY "Parity="+mdpar
RELEASE mdpar

SET COLOR TO &NORM

SETCURPOS(1,0)

RETURN
****************************************************************************
PROCEDURE PHONEBOOK

PARAMETERS port,mbaud,mparity,msbits,mwlength,mduplex

SAVE SCREEN TO mphonebk

IF FILE("COMPHONE.DBF")
    USE COMPHONE
ELSE
    ? CHR(7)
    @ 10,20 SAY "Sorry, I can't find the COMPHONE database"
    INKEY(0)
    CLEAR
    RESTORE SCREEN FROM mphonebk
    RELEASE mphonebk
    RETURN
ENDIF

CLEAR

DO DISPHONE   && Displays the phone book to screen.

DO WHILE .T.

    IF NUM_COLOR("F")=7 .AND. NUM_COLOR("B")=0  && i.e. Monochrome
        SET COLOR TO &NORM
    ELSE
        SET COLOR TO &REV
    ENDIF

    @ 00,00  && This erases the ALT F10 Header while in this

    mtask = 1
    SET MESSAGE TO   && THIS DISABLES MESSAGE GENERATION

    @ 00,00 PROMPT "Auto-Dial"
    @ 00,16 PROMPT "Manual-Dial"
    @ 00,34 PROMPT "Listing-Edit"
    @ 00,53 PROMPT "PreDials-Edit"
    @ 00,74 PROMPT "Return"

    MENU TO mtask

    SET COLOR TO &NORM

    DO CASE
        CASE mtask = 1
            @ 00,00
            mnumber = 0
            @ 00,01 SAY "Listing Number?" GET mnumber PICTURE "@Z ##";
            VALID (mnumber > 0 .AND. mnumber < 21)
            READ

            @ 00,00
            SET COLOR TO &NORMFL
            @ 00,00 SAY "Working..."
            SET COLOR TO &NORM

            IF LASTKEY() = 27
                LOOP
            ENDIF

            GOTO mnumber

            mbaud = BAUDRATE
            mparity = PARITY
            msbits = STOPBITS
            mwlength = WORDLENGTH
            mduplex = DUPLEX

            merror = SMFULLHALF(port,IIF(DUPLEX="F","1","0"))
            SWDELAY(1 * 18)
            IF merror != 0
                ? CHR(7)
                @ 00,00
                @ 00,00 SAY "Duplex Setting Error!"
                ?? merror
                INKEY(1)
            ENDIF

            merror = SETBAUD(port,BAUDRATE,PARITY,STOPBITS,WORDLENGTH)
            IF merror != 0
                ? CHR(7)
                @ 00,00
                @ 00,00 SAY "Protocol Setting Error!"
                ?? merror
                INKEY(1)
            ENDIF

            IF MULTINUM        && If multiple phone numbers were set TRUE
                DO PROCMULTI
            ELSE
                GOTO mnumber
                merror = SMDIAL(port,PHONE)
                TXSTRING(port,"ATO")
                TXCHAR(port,CHR(13))
                SWDELAY(1 * 18)
            ENDIF

            IF merror != 0
                ? CHR(7)
            ENDIF

            merror = RXFLUSH(port)
            merror = TXFLUSH(port)

            GOTO mnumber
            RELEASE mnumber,mname

        CASE mtask = 2
            @ 00,00
            mpnumber = SPACE(11)
            @ 00,01 SAY "Enter Phone Number" GET mpnumber PICTURE "###########"
            READ
            IF ! EMPTY(mpnumber)
                merror = SMDIAL(port,mpnumber)
                IF merror != 0
                    ? CHR(7)
                ENDIF
            ENDIF
            RELEASE mpnumber
        CASE mtask = 3
            @ 00,00
            mnumber = 0
            @ 00,01 SAY "Listing Number?" GET mnumber PICTURE "@Z ##";
            VALID (mnumber > 0 .AND. mnumber < 21)
            READ

            * This will compute the correct starting row for phonebook display.
            mrow = mnumber + 3

            IF LASTKEY() <> 27
                GOTO mnumber
                @  mrow,04  GET  NAME
                @  mrow,25  GET  PHONE
                @  mrow,38  GET  MULTINUM
                @  mrow,40  GET  BAUDRATE VALID FBAUDRATE(BAUDRATE)
                @  mrow,46  GET  DUPLEX PICTURE "!" VALID DUPLEX $ "FH"
                @  mrow,48  GET  WORDLENGTH PICTURE "#" RANGE 7,8
                @  mrow,50  GET  STOPBITS PICTURE "#" RANGE 1,2
                @  mrow,52  GET  PARITY PICTURE "#" RANGE 0,2
                @  mrow,54  GET  USERID
                @  mrow,65  GET  PASSWORD
                READ
                DO DISPHONE
            ENDIF
          
            RELEASE mrow,mnumber

        CASE mtask = 4
            @ 00,00
            GOTO 21
            mpredial_1 = NAME
            GOTO 22
            mpredial_2 = NAME

            @ 00,00 SAY "PreDial #1 ([,] = 1 second delays)" GET mpredial_1
            READ
            @ 00,00 SAY "PreDial #2 ([,] = 1 second delays)" GET mpredial_2
            READ

            * Records 21 and 22 will hold the predial numbers
            GOTO 21
            REPLACE NAME WITH mpredial_1
            GOTO 22
            REPLACE NAME WITH mpredial_2
            RELEASE mpredial_1,mpredial_2

        CASE mtask = 5
            EXIT
    ENDCASE

    IF LASTKEY() = 27
        SMSWHOOK(port,"0")  && Hang up the Phone
    ENDIF

ENDDO

RESTORE SCREEN FROM mphonebk
RELEASE mphonebk

RETURN
*****************************************************************************
PROCEDURE PROCMULTI

mtask = 1
DO WHILE .T.
    @ 00,00
    @ 00,00 PROMPT "First Pre-Dial"
    @ 00,23 PROMPT "Second Pre-Dial"
    @ 00,47 PROMPT "Actual Phone Number"
    @ 00,74 PROMPT "Return"
    MENU TO mtask
  
    DO CASE
        CASE mtask = 1
            GOTO 21
            mname = RTRIM(NAME)+";"
            merror = SMDIAL(port,mname)
        CASE mtask = 2
            GOTO 22
            mname = RTRIM(NAME)+";"
            merror = SMDIAL(port,mname)
        CASE mtask = 3
            GOTO mnumber
            mname = RTRIM(PHONE)+";"
            merror = SMDIAL(port,mname)
        CASE mtask = 4
            EXIT
    ENDCASE

    mtask = 4

    IF LASTKEY() = 27
        SMSWHOOK(port,"0")  && Hang up the Phone
    ENDIF

    SWDELAY(1 * 18)  && Used to delay the light bar menu selection switching
ENDDO

TXSTRING(port,"ATO")
TXCHAR(port,CHR(13))
SWDELAY(1 * 18)

RETURN
******************
PROCEDURE DISPHONE

CLEAR
GOTO TOP

@  1,  0  TO 24, 79
@  2,  1  SAY "#          Name            Phone    Mul Baud D L S P  User ID     Password"
@  3,  1  TO  3, 78

DO WHILE ! EOF() .AND. RECNO()<=20

    @  ROW()+1,01 SAY RTRIM(STR(RECNO(),2))

    IF ! EMPTY(NAME)
        @  ROW(),  04  SAY  NAME
        @  ROW(),  25  SAY  PHONE
        @  ROW(),  38  SAY  MULTINUM
        @  ROW(),  40  SAY  STR(BAUDRATE,5)
        @  ROW(),  46  SAY  DUPLEX
        @  ROW(),  48  SAY  STR(WORDLENGTH,1)
        @  ROW(),  50  SAY  STR(STOPBITS,1)
        @  ROW(),  52  SAY  STR(PARITY,1)
        @  ROW(),  54  SAY  REPLICATE("*",10)
        @  ROW(),  65  SAY  REPLICATE("*",14)
    ENDIF

    SKIP
ENDDO

RETURN
*****************************************************************************
PROCEDURE LOG_ON

PARAMETERS port

IF ! STATUSCD(port)
    @ 00,00
    ? CHR(7)
    @ 00,20 SAY "Aborted!  You are not online with anyone!"
    INKEY(1)
    RETURN
ENDIF

@ 00,00

mtask = 1
SET MESSAGE TO   && THIS DISABLES MESSAGE GENERATION

@ 00,68 SAY "Listing # "+STR(RECNO(),2)
@ 00,00 PROMPT "User-ID(Send)"
@ 00,24 PROMPT "Password(Send)"
@ 00,44 PROMPT "Return"

MENU TO mtask

SET COLOR TO &NORM
@ 00,00

DO CASE
    CASE mtask = 1
        merror1 = TXSTRING(port,USERID)
        merror2 = TXCHAR(port,CHR(13))
        IF merror1 > 0 .AND.  merror2 = 0
            @ 00,01 SAY "User ID transmitted!"
        ELSE
            ? CHR(7)
            @ 00,01 SAY "User ID Transmission Error!"
            ?? merror1
            ?? " "
            ?? merror2
        ENDIF
        INKEY(1)
        RELEASE merror1,merror2
    CASE mtask = 2
        merror1 = TXSTRING(port,PASSWORD)
        merror2 = TXCHAR(port,CHR(13))
        IF merror1 > 0 .AND.  merror2 = 0
            @ 00,01 SAY "User Password transmitted!"
        ELSE
            ? CHR(7)
            @ 00,00 SAY "Password Transmission Error!"
            ?? merror1
            ?? " "
            ?? merror2
        ENDIF
        INKEY(1)
        RELEASE merror1,merror2
    CASE mtask = 3
        @ 00,00
ENDCASE

RETURN
*****************************************************************************
PROCEDURE SET_BAUD

PARAMETERS port,mbaud,mparity,msbits,mwlength,mduplex

SAVE SCREEN
SET COLOR TO &HELPCOL

* Select Stop Bits

mtask = 1

@ 03,18 CLEAR TO 07,23
@ 04,17 TO 08,24
@ 03,18 SAY "Duplex"

@ 05,18 PROMPT "Full D"
@ 07,18 PROMPT "Half D"

MENU to mtask

DO CASE
    CASE mtask=1
        mduplex = "1"
    CASE mtask=2
        mduplex = "0"
ENDCASE
******************
* Select Baud Rate

mtask = 8

@ 03,30 CLEAR TO 19,34
@ 04,29 TO 20,35
@ 03,28 SAY "Baud Rate"

@ 05,30 PROMPT "   50"
@ 06,30 PROMPT "   75"
@ 07,30 PROMPT "  110"
@ 08,30 PROMPT "  134"
@ 09,30 PROMPT "  150"
@ 10,30 PROMPT "  300"
@ 11,30 PROMPT "  600"
@ 12,30 PROMPT " 1200"
@ 13,30 PROMPT " 1800"
@ 14,30 PROMPT " 2000"
@ 15,30 PROMPT " 2400"
@ 16,30 PROMPT " 3600"
@ 17,30 PROMPT " 4800"
@ 18,30 PROMPT " 9600"
@ 19,30 PROMPT "19200"

MENU to mtask

DO CASE
    CASE mtask=1
        mbaud = 50
    CASE mtask=2
        mbaud = 75
    CASE mtask=3
        mbaud = 110
    CASE mtask=4
        mbaud = 134
    CASE mtask=5
        mbaud = 150
    CASE mtask=6
        mbaud = 300
    CASE mtask=7
        mbaud = 600
    CASE mtask=8
        mbaud = 1200
    CASE mtask=9
        mbaud = 1800
    CASE mtask=10
        mbaud = 2000
    CASE mtask=11
        mbaud = 2400
    CASE mtask=12
        mbaud = 3600
    CASE mtask=13
        mbaud = 4800
    CASE mtask=14
        mbaud = 9600
    CASE mtask=15
        mbaud = 19200
ENDCASE
******************
* Select Parity

mtask = 1

@ 03,40 CLEAR TO 09,43
@ 04,39 TO 10,44
@ 03,39 SAY "Parity"

@ 05,40 PROMPT "None"
@ 07,40 PROMPT "Odd "
@ 09,40 PROMPT "Even"

MENU to mtask

DO CASE
    CASE mtask=1
        mparity = 0
    CASE mtask=2
        mparity = 1
    CASE mtask=3
        mparity = 2
ENDCASE
******************
* Select Word Length

mtask = 2

@ 03,50 CLEAR TO 07,55
@ 04,49 TO 08,56
@ 03,48 SAY "Word Length"

@ 05,50 PROMPT "7 Bits"
@ 07,50 PROMPT "8 Bits"

MENU to mtask

DO CASE
    CASE mtask=1
        mwlength = 7
    CASE mtask=2
        mwlength = 8
ENDCASE
******************
* Select Stop Bits

mtask = 1

@ 03,63 CLEAR TO 07,68
@ 04,62 TO 08,69
@ 03,61 SAY "Stop Bits"

@ 05,63 PROMPT "1 Bit "
@ 07,63 PROMPT "2 Bits"

MENU to mtask

DO CASE
    CASE mtask=1
        msbits = 1
    CASE mtask=2
        msbits = 2
ENDCASE

SET COLOR TO &REV
@ 00,0
SET COLOR TO &REVFL
@ 00,24 SAY "Setting Baud Rate and Protocol ..."
SET COLOR TO &NORM

merror = SMFULLHALF(port,mduplex)
SWDELAY(1 * 18)

merror = SETBAUD(port,mbaud,mparity,msbits,mwlength)
SWDELAY(1 * 18)

IF merror = 0
ELSE
    ? CHR(7)
ENDIF

RESTORE SCREEN

RETURN
*****************************************************************************
PROCEDURE SMCOMMANDS

    PARAMETERS port

    SAVE SCREEN
    SET COLOR TO &HELPCOL

    mtask = 4

    @ 03,40 CLEAR TO 19,62
    @ 02,39 TO 20,63

    DO WHILE .T.

        @ 03,40 PROMPT " Deactivate Phone Line "
        @ 05,40 PROMPT "  Activate Phone Line  "
        @ 07,40 PROMPT " Go Online in Ans.Mode "
        @ 09,40 PROMPT " Local Mode for Modem  "
        @ 11,40 PROMPT " Online Mode for Modem "
        @ 19,40 PROMPT "        Return         "

        MENU to mtask

        DO CASE
            CASE mtask=1
                SMSWHOOK(port,"1")
            CASE mtask=2
                SMSWHOOK(port,"0")
            CASE mtask=3
                TXSTRING(port,"ATA")
                TXCHAR(port,CHR(13))
            CASE mtask=4
                SMESCAPE(port)
            CASE mtask=5
                TXSTRING(port,"ATO")
                TXCHAR(port,CHR(13))
            CASE mtask=6
                EXIT
        ENDCASE

        mtask = 6
    ENDDO

    RESTORE SCREEN

RETURN
*****************************************************************************
* This procedure check to see what ports exists and if there is any active
* device presently responding.

PROCEDURE PORTCHK

    PARAMETERS port1,port2,active1,active2,smodem1,smodem2

    SET COLOR TO &REV
    @ 00,00
    SET COLOR TO &REVFL
    @ 00,22 SAY "Checking Communications Equipment ..."
    SET COLOR TO &NORM

    IF DEVICEPRES(1)
        port1 = .T.
        ********************************* Open COMM Port #1
        merror = OPENCOMM(1,400,400)

        IF merror = 0
            ***************************** Now set the baud rate to 1200
            merror = SETBAUD(1,1200,0,1,8)  && port,baud,parity,stopbits,wordlen
            SWDELAY(1 * 18)

            IF merror = 0
                ************************** Send out a Reset to Port
                merror = SMRESET(1)
                SWDELAY(1 * 18)
                ************************** Check to see if the Modem has Responded
                IF RXEMPTY(1)
                    ? CHR(7)
                    ? "No Active Device on COM1!"
                ELSE
                    active1 = .T.
                    * Determine if the Device is responding like a SmartModem
                    * Response should be A T Z CR CR LF O K
                    modemrchk = CHR(65)+CHR(84)+CHR(90)+CHR(13)+CHR(13)+CHR(10)+;
                    CHR(79)+CHR(75)
                    modemresp = ""
                    DO WHILE (! RXEMPTY(1)) .AND. (modemresp <> modemrchk)
                        modemresp = modemresp + CHR(RXCHAR(1))
                    ENDDO
                    * Check if Recieve Buffer is empty. If it is then assume that
                    * the Device is not a Smartmodem and then Flush the buffer.
                    IF ! RXEMPTY(1)
                        smodem1 = .T.  && Indicate that its a Smartmodem.
                        RXFLUSH(1)
                    ELSE
                        ? CHR(7)
                        ? "The Active Device on COM1 Does Not Appear To Be A SmartModem!"
                    ENDIF
                ENDIF
            ELSE
                ? CHR(7)
                ? "Port Baud Rate Programming Error!"
                ?
            ENDIF
        ELSE
            ? CHR(7)
            ? "Communication OPENPORT Error has occurred!"
            ?
        ENDIF
    ELSE
        ? CHR(7)
        ? "Communications Port #1 Not Detected!"
        ?
    ENDIF
    merror = CLOSECOMM(1)
    SWDELAY(1 * 18)

    IF DEVICEPRES(2)
        port2 = .T.
        ********************************* Open COMM Port #2
        merror = OPENCOMM(2,400,400)

        IF merror = 0
            ***************************** Now set the baud rate to 1200
            merror = SETBAUD(2,1200,0,1,8)  && port,baud,parity,stopbits,wordlen
            SWDELAY(1 * 18)

            IF merror = 0
                ************************** Send out a Reset to Port
                merror = SMRESET(2)
                SWDELAY(1 * 18)
                ************************** Check to see if the Modem has Responded
                IF RXEMPTY(2)
                    ? CHR(7)
                    ? "No Active Device on COM2!"
                ELSE
                    active2 = .T.
                    * Determine if the Device is responding like a SmartModem
                    * Response should be A T Z CR CR LF O K
                    modemrchk = CHR(65)+CHR(84)+CHR(90)+CHR(13)+CHR(13)+CHR(10)+;
                    CHR(79)+CHR(75)
                    modemresp = ""
                    DO WHILE (! RXEMPTY(2)) .AND. (modemresp <> modemrchk)
                        modemresp = modemresp + CHR(RXCHAR(2))
                    ENDDO
                    * Check if Recieve Buffer is empty. If it is then assume that
                    * the Device is not a Smartmodem and then Flush the buffer.
                    IF ! RXEMPTY(2)
                        smodem2 = .T.  && Indicate that its a Smartmodem.
                        RXFLUSH(2)
                    ELSE
                        ? CHR(7)
                        ? "The Active Device on COM2 Does Not Appear To Be A SmartModem!"
                    ENDIF
                ENDIF
            ELSE
                ? CHR(7)
                ? "Port Baud Rate Programming Error!"
                ?
            ENDIF
        ELSE
            ? CHR(7)
            ? "Communication OPENPORT Error has occurred!"
            ?
        ENDIF
    ELSE
        ? CHR(7)
        ? "Communications Port #2 Not Detected!"
        ?
    ENDIF
    merror = CLOSECOMM(2)
    SWDELAY( 1 * 18)

    RELEASE modemresp,modemrchk
RETURN
*****************************************************************************
FUNCTION FMULTINUM

    PARAMETERS MULTINUM

    IF ! MULTINUM
    RETURN(.T.)
ENDIF

@ 00,00
@ 00,00 SAY "First PreDial Number:" GET PREDIAL_1
@ 00,35 SAY "Second PreDial Number:" GET PREDIAL_2
READ

IF EMPTY(PREDIAL_1) .AND. EMPTY(PREDIAL_2)
    REPLACE MULTINUM WITH .F.
ENDIF

RETURN(.T.)
***************** EOF FMULTINUM
FUNCTION FBAUDRATE

    PARAMETERS MBAUDRATE

    merror = .T.

    DO CASE
        CASE MBAUDRATE == 50
            merror = .F.
        CASE MBAUDRATE == 75
            merror = .F.
        CASE MBAUDRATE == 110
            merror = .F.
        CASE MBAUDRATE == 134
            merror = .F.
        CASE MBAUDRATE == 150
            merror = .F.
        CASE MBAUDRATE == 300
            merror = .F.
        CASE MBAUDRATE == 600
            merror = .F.
        CASE MBAUDRATE == 1200
            merror = .F.
        CASE MBAUDRATE == 1800
            merror = .F.
        CASE MBAUDRATE == 2000
            merror = .F.
        CASE MBAUDRATE == 2400
            merror = .F.
        CASE MBAUDRATE == 3600
            merror = .F.
        CASE MBAUDRATE == 4800
            merror = .F.
        CASE MBAUDRATE == 9600
            merror = .F.
        CASE MBAUDRATE == 19200
            merror = .F.
    ENDCASE

    RELEASE MBAUDRATE

    IF merror
        @ 00,00
        @ 00,00 SAY "F1 Help"
        ? CHR(7)
        RETURN(.F.)
    ENDIF

@ 00,00

RETURN(.T.)
**************** EOF FBAUDRATE
* Pass the half of color/pair desired.  i.e. F-foreground or B-background
FUNCTION NUM_COLOR

PARAMETERS col_half

IF ! col_half $ "FB"
  ? CHR(7)
  RETURN(-1)
ENDIF

* Extracts the Color Letter imbedded in the SET COLOR TO macro string (NORM).

colormacro = norm
mcolstring = ""
mchar = ""

IF col_half = "F"
  FOR I = 1 TO LEN(colormacro)
      mchar = SUBSTR(colormacro,I,1)
      IF mchar = "/"
          I = LEN(colormacro)
      ELSE
          IF mchar $ "*+"
              mchar = ""
          ENDIF
          mcolstring = mcolstring + mchar
      ENDIF
  NEXT
ELSE
  I=1
  mchar = ""
  DO WHILE mchar <> "/"
    mchar = SUBSTR(colormacro,I,1)
    I=I+1
  ENDDO
  DO WHILE mchar <> ","
    mchar = SUBSTR(colormacro,I,1)
    IF ! mchar $ "*+/,"
        mcolstring = mcolstring + mchar
    ENDIF
    I=I+1
  ENDDO
ENDIF

DO CASE
  CASE mcolstring == "N"
    col_num = 0
  CASE mcolstring == "B"
    col_num = 1
  CASE mcolstring == "G"
    col_num = 2
  CASE mcolstring == "BG"
    col_num = 3
  CASE mcolstring == "R"
    col_num = 4
  CASE mcolstring == "RB"
    col_num = 5
  CASE mcolstring == "GR"
    col_num = 6
  CASE mcolstring == "W"
    col_num = 7
ENDCASE

RETURN(col_num)
****************
**************** HELP PROGRAM FOR GuyComm ROUTINE

PROCEDURE GUYCOMMHLP

PARAMETERS CALL_PRG,LINE_NUM,INPUT_VAR

IF CALL_PRG = "GUYCOMMHLP"
  RETURN
ENDIF

SAVE SCREEN TO mhelpscrn
SET COLOR TO &HELPCOL

DO CASE

  CASE INPUT_VAR="DUPLEX"
     mtask = 1

     @ 03,63 CLEAR TO 07,68
     @ 04,62 TO 08,69
     @ 03,63 SAY "Duplex"

     @ 05,63 PROMPT "Full D"
     @ 07,63 PROMPT "Half D"

     MENU to mtask

     DO CASE
       CASE mtask=1
         mduplex = "F"
       CASE mtask=2
         mduplex = "H"
     ENDCASE

     REPLACE DUPLEX WITH mduplex

     SET COLOR TO &NORM
     RESTORE SCREEN FROM mhelpscrn
     RELEASE mhelpscrn

     RETURN

  CASE INPUT_VAR="STOPBITS"
     * Select Stop Bits

     mtask = 1

     @ 03,63 CLEAR TO 07,68
     @ 04,62 TO 08,69
     @ 03,61 SAY "Stop Bits"

     @ 05,63 PROMPT "1 Bit "
     @ 07,63 PROMPT "2 Bits"

     MENU to mtask

     DO CASE
       CASE mtask=1
         msbits = 1
       CASE mtask=2
         msbits = 2
     ENDCASE

     REPLACE STOPBITS WITH msbits

     SET COLOR TO &NORM
     RESTORE SCREEN FROM mhelpscrn
     RELEASE mhelpscrn

     RETURN
 
 CASE INPUT_VAR="WORDLENGTH"
     * Select Word Length

     mtask = 2

     @ 03,50 CLEAR TO 07,55
     @ 04,49 TO 08,56
     @ 03,48 SAY "Word Length"

     @ 05,50 PROMPT "7 Bits"
     @ 07,50 PROMPT "8 Bits"

     MENU to mtask

     DO CASE
       CASE mtask=1
         mwlength = 7
       CASE mtask=2
         mwlength = 8
     ENDCASE
 
     REPLACE WORDLENGTH WITH mwlength

     SET COLOR TO &NORM
     RESTORE SCREEN FROM mhelpscrn
     RELEASE mhelpscrn

     RETURN
     ******************
   CASE INPUT_VAR="PARITY"
     * Select Parity

     mtask = 1

     @ 03,40 CLEAR TO 09,43
     @ 04,39 TO 10,44
     @ 03,39 SAY "Parity"

     @ 05,40 PROMPT "None"
     @ 07,40 PROMPT "Odd "
     @ 09,40 PROMPT "Even"

     MENU to mtask

     DO CASE
       CASE mtask=1
         mparity = 0
       CASE mtask=2
         mparity = 1
       CASE mtask=3
         mparity = 2
     ENDCASE

     REPLACE PARITY WITH mparity

     SET COLOR TO &NORM
     RESTORE SCREEN FROM mhelpscrn
     RELEASE mhelpscrn

     RETURN
     ******************
   CASE INPUT_VAR="BAUDRATE"
     @ 03,30 CLEAR TO 19,34
     @ 04,29 TO 20,35
     @ 03,28 SAY "Baud Rate"
     
     @ 05,30 PROMPT "   50"
     @ 06,30 PROMPT "   75"
     @ 07,30 PROMPT "  110"
     @ 08,30 PROMPT "  134"
     @ 09,30 PROMPT "  150"
     @ 10,30 PROMPT "  300"
     @ 11,30 PROMPT "  600"
     @ 12,30 PROMPT " 1200"
     @ 13,30 PROMPT " 1800"
     @ 14,30 PROMPT " 2000"
     @ 15,30 PROMPT " 2400"
     @ 16,30 PROMPT " 3600"
     @ 17,30 PROMPT " 4800"
     @ 18,30 PROMPT " 9600"
     @ 19,30 PROMPT "19200"

     MENU to mtask
     
     DO CASE
       CASE mtask=1
         mbaud = 50
       CASE mtask=2
         mbaud = 75
       CASE mtask=3
         mbaud = 110
       CASE mtask=4
         mbaud = 134
       CASE mtask=5
         mbaud = 150
       CASE mtask=6
         mbaud = 300
       CASE mtask=7
         mbaud = 600
       CASE mtask=8
         mbaud = 1200
       CASE mtask=9
         mbaud = 1800
       CASE mtask=10
         mbaud = 2000
       CASE mtask=11
         mbaud = 2400
       CASE mtask=12
         mbaud = 3600
       CASE mtask=13
         mbaud = 4800
       CASE mtask=14
         mbaud = 9600
       CASE mtask=15
         mbaud = 19200
     ENDCASE

     REPLACE BAUDRATE WITH mbaud

     SET COLOR TO &NORM
     RESTORE SCREEN FROM mhelpscrn
     RELEASE mhelpscrn

     RETURN
     ******************

  CASE INPUT_VAR="MULTINUM"

    @ 10,21 CLEAR TO 20,59
    @ 09,20 TO 21,60 DOUBLE
    @ 10,21 SAY "        Multiple Phone Numbers.        "
    @ 12,21 SAY "Logical T)rue or F)alse.               "
    @ 14,21 SAY "Used to provide access to User defined "
    @ 15,21 SAY "phone numbers for subscription phone   "
    @ 16,21 SAY "services such as MCI, etc.             "
    @ 18,21 SAY 'Thank you for using  "GuyComm".        '
    SET COLOR TO &STATCOL
    @ 20,21 SAY "Press any key to continue..."

  CASE INPUT_VAR="MTASK"

    @ 10,21 CLEAR TO 20,59
    @ 09,20 TO 21,60 DOUBLE
    @ 10,21 SAY "Please select the desired action/item. "
    @ 12,21 SAY "This may be accomplished two (2) ways. "
    @ 14,21 SAY "  1.  Pressing the appropriate letter. "
    @ 15,21 SAY "  2.  Using the cursor arrow keys to   "
    @ 16,21 SAY "      highlight your choice.           "
    @ 18,21 SAY 'Thank you for using  "GuyComm".        '
    SET COLOR TO &STATCOL
    @ 20,21 SAY "Press any key to continue..."

  OTHERWISE
    
    @ 11,21 CLEAR TO 19,59
    @ 10,20 TO 20,60 DOUBLE
    @ 11,21 SAY "Sorry, online help is not available in "
    @ 12,21 SAY "this area.                             "
    @ 14,21 SAY "Please refer to your manual for further"
    @ 15,21 SAY "assistance.                            "
    @ 17,21 SAY 'Thank you for using  "GuyComm".        '
    SET COLOR TO &STATCOL
    @ 19,21 SAY "Press any key to continue..."

ENDCASE

SET COLOR TO &NORM
HELPWAIT=0
DO WHILE HELPWAIT=0
  HELPWAIT=INKEY()
ENDDO

RESTORE SCREEN FROM mhelpscrn
RELEASE mhelpscrn,helpwait

RETURN
********************

