/*-------------------------------- COMMLib.PRG -------------------------------*
* Copyright 1992, Samer Najia, all rights reserved
*
* Purpose: Library of functions for dialing up via modem.  See the sample
*          routine below for an example of how to use them
*
* Written By: Samer Najia, based on suggestions by Kent Kingery and Steve
*             Kolterman.  Placed in the public domain.
*
* Note:
*   Feel free to download this library and use it in your applications.  You'll
*   receive support for this library commensurate with what you paid for it --
*   that is, no support is provided.  I'll take any comments or suggestions
*   sent to my CIS ID.
*
* Compiler Note:
*   Compile with /DTEST to enable the test program on linking
*
* Samer Najia
* CIS ID: 72267,1615
*----------------------------------------------------------------------------*/
#ifdef TEST
    #define DIAL_DELAY   8    // dialing delay

    CLEAR
    nPort := ALERT("Pick COMM Port",{"COM1","COM2","COM3","COM4"})

    IF nPort == 0
        RETURN
    ENDIF

    cPort  := "COM" + ALLTRIM(STR(nPort))
    nHandle := 0      // port handle

    IF !ModemInit(cPort,@nHandle)
        ALERT("Error initializing Modem",{"Exit"})  // get out
        RETURN
    ENDIF

    CLEAR
    cNumber := SPACE(15)
    @ 10,10 SAY "Number to dial?" GET cNumber
    READ

    IF LASTKEY() == 27
        CLEAR
        RETURN
    ENDIF

    ALERT("Ready to dial",{"Ok"})

    IF !Dial(nHandle,ALLTRIM(cNumber),.T.,.T.,2)
        ALERT("Couldn't dial",{"Exit"})   // get out
        CLEAR
        RETURN
    ENDIF

    @ 11,10 SAY "Wait while modem dials the number...."

    nSeconds := SECONDS()

    DO WHILE SECONDS() - nSeconds <= DIAL_DELAY
    ENDDO

    ALERT("Pick up the phone and talk to your party",{"Ok"})

    // NOTE:  If the phone is not picked up by a modem on the other side, the modem
    //        hangup string won't hang up the line.  You do that when you hang up
    //        phone.

    IF !ModemClose(nHandle)
        ALERT("Error closing modem/port",{"Exit"})  // get out
    ENDIF

    CLEAR
    RETURN
#endif
/*---------------------------------------------------------------------------*/

FUNCTION ModemInit(cPort,nHandle)
/*------------------------------- ModeInit() ---------------------------------*
* Purpose: Initialise the port/modem before dialing out
*
* Parameters:
*   1) cPort      c     COM port (COM1/COM2/COM3/COM4)
*   2) @nHandle   c     COM Port handle (if initialisation successfull)
*
* Written By: Samer Najia
*----------------------------------------------------------------------------*/
LOCAL lRet_Val := .T.
nHandle := FOPEN(cPort,2)
IF nHandle == 0
    lRet_Val := .F.
END
RETURN (lRet_Val)
/*---------------------------------------------------------------------------*/

FUNCTION Dial(nHandle,cNumber,lVoice,lTone,nDelay)
/*-------------------------------- Dial() ------------------------------------*
* Purpose: To pass characters to a Hayes compatible modem that lift the phone
*          off the hook, and dial a number
*
* Parameters:
*   1) nHandle     n      COM Port handle (as generated in ModemInit()
*   2) cNumber     c      Number to dial
*   3) lVoice      l      Dial for a voice call.  The string passed to the
*                         port carries a ; or CHR(59).  This does not allow the
*                         modem to attempt to synchronize signals between it
*                         and the other side of the hookup, hence simulating a
*                         normal, non modem dial.
*   4) lTone       l      For most phones/modem, this is set to .T. for Tone
*                         dialing.  If tone dialing is not available, set this
*                         parameter to .F., and pulse dialing will be used by
*                         the modem.
*   5) nDelay      n      # of seconds delay before passing of number to modem
*                         Minimum recommended is 2 seconds.
*
* Written By: Samer Najia
*----------------------------------------------------------------------------*/
LOCAL nSeconds := SECONDS(),cString,lRet_Val := .T.

IF nDelay > 0
    DO WHILE SECONDS() - nSeconds <= nDelay
    ENDDO
ENDIF

cString := "ATD" + IIF(lTone,"T","") + cNumber + IIF(lVoice,";","") + CHR(13)

IF FWRITE(nHandle,cString) <> LEN(cString)  // error?
    lRet_Val := .F.
ENDIF

RETURN (lRet_Val)
/*---------------------------------------------------------------------------*/

FUNCTION ModemClose(nHandle,cHangUp)
/*------------------------------- ModeClose() --------------------------------*
* Purpose: Close the port/modem
*
* Parameters:
*   1) nHandle     c     COM Port handle
*   2) [cHangUp]   c     Optional Hangup string
*
* Written By: Samer Najia
*----------------------------------------------------------------------------*/
LOCAL lRet_Val := .T.,cString

cString := "~~~+++~~~ATH0" + CHR(13)   // modem hangup string

IF VALTYPE(cHangUp) == "C"
    cString := ALLTRIM(cHangUp) + CHR(13)
ENDIF

IF FWRITE(nHandle,cString) <> LEN(cString)  // error?
    lRet_Val := .F.
END

FCLOSE(nHandle)
RETURN (lRet_Val)
/*---------------------------------------------------------------------------*/