************************** REMOTE.PRG ******************************
*This program demonstrates how to use the powerful remote command
*functions of COMET. This program opens a specified COM port where
*a Hayes compatible modem should be present, initializes the modem,
*prompts for a # to dial. Once connected, it prompts for either a
*file name to send or receive. It then sends the appropriate REMCMD
*command to the host PC and displays progress.

*********** BE SURE TO SET THE COM PORT IN LINE 14 ****************

clear
Cr = CHR(13)				&& Carriage return defined

ComPort = '2'               && COM port #
ComBaud = '2400'
ComParity = 'N'
ComData = '8'
ComStop = '1'
ComFlow = 'R'               && Might need Rts/cts flow control for high baud rates

* If Rts/cts specified for COMET, might also need to include a command
* in the ModemInit string so the modem knows to use Rts/cts.
* You might have to remove the &D2 and &C1 cmds below if your modem does not support
ModemInit = 'AT &F E0 Q0 S0=0 V1 X4 &D2 &C1' + Cr
ModemInit = STRTRAN(ModemInit, ' ', '')     && Strip out spaces

* Open port
OpenCmd = 'OPEN COM' + ComPort + ':' + ComBaud + ',' + ComParity;
  + ',' + ComData + ',' + ComStop + ',' + ComFlow
CALL COMETMP WITH OpenCmd

*Define send/recv protocol timeouts
ProtCmd = 'PROT 2,5,5'
CALL COMETMP WITH ProtCmd

*Init modem
OutInit = 'OUTPUT #' + ComPort + ',' + ModemInit
CALL COMETMP WITH OutInit

* Prompt for # to dial.
CLEAR
PhoneNo = SPACE(15)
@ 10,10 SAY 'Phone # to dial' GET PhoneNo
READ

* If ESC'd from, assume PCs are direct connected with a null modem cable
* and go onto the file prompt section
IF LASTKEY() # 27
	* Dial #
    DialCmd = 'OUTPUT #' + ComPort + ',ATDT' + TRIM(PhoneNo) + Cr
    DispMess('Dialing ' + TRIM(PhoneNo), -1)
    CALL COMETMP WITH DialCmd
	
    DispMess('Waiting For Modem to Connect ...', -1)
	*Wait for MSTAT to report '+DCD' connection
    CALL COMETMP WITH 'FLUSH #' + ComPort
	DO WHILE .T.
        MStatCmd = 'MSTAT #' + ComPort + ',' + SPACE(25)
        NoConnect = 'FIND #' + ComPort + ', NO '       && Search for modem "NO connect" or "BUSY" replies
        Busy = 'FIND #' + ComPort + ', BUSY'
        CALL COMETMP WITH MStatCmd
        CALL COMETMP WITH NoConnect
        CALL COMETMP WITH Busy
		DO CASE
			CASE '+' $ Busy
                DispMess('Sorry, but line is BUSY ...', 3)
                CALL COMETMP WITH 'CLOSE #' + ComPort
                QUIT
			CASE '+' $ NoConnect
                DispMess('Sorry, but NO ANSWER/CONNECT ...', 3)
                CALL COMETMP WITH 'CLOSE #' + ComPort
                QUIT
			CASE '+DCD' $ MStatCmd		&& We got connected
                DispMess('Connection Established', 5)
                EXIT
			OTHER
                DispMess(MStatCmd, -1)
		ENDCASE
	ENDDO	
ENDIF


* A connection is established, lets prompt for files to transfer
DO WHILE LASTKEY() # 27					&& Main loop that prompts for file name to send/receive
	CLEA
	SendOrRcv = ' '
    @ 10,1 SAY 'Send, Receive or Exit (S,R or E) ?' GET SendOrRcv PICTURE '!' VALID SendOrRcv $ 'SRE'
    READ

    IF SendOrRcv $ 'SR'
      FileSpec = SPACE(50)
      @ 12,1 SAY 'Filename (can include path and wildcards)' GET FileSpec PICTURE '@!S25' VALID ! EMPTY(FileSpec)
      READ
    ENDIF

    IF LASTKEY() = 27 .OR. SendOrRcv = 'E'
		EXIT							&& Disconnect
	ENDIF

	* Build our local command and remote commands for this file transfer
	IF SendOrRcv = 'S'					&& YSEND file to remote
        LocalCmd  = 'YSEND #' + ComPort + ',' + TRIM(FileSpec)
        RemoteCmd = 'REMCMD #' + ComPort + ',YRECV #?'
        CALL COMETMP WITH 'FLUSH #' + ComPort
        CALL COMETMP WITH LocalCmd   && Start sender 1st
        CALL COMETMP WITH RemoteCmd
	ELSE								&& YRECV file from remote
        LocalCmd  = 'YRECV #' + ComPort
        RemoteCmd = 'REMCMD #' + ComPort + ',YSEND #?,' + TRIM(FileSpec)
        CALL COMETMP WITH RemoteCmd  && Start sender 1st
        CALL COMETMP WITH LocalCmd
	ENDIF
	
* We've started our send/recv locally and sent recv/send command to remote
* Now just monitor and display the progress
    FChkCmd = 'FCHK #' + ComPort + ',' + SPACE(65)
    DO WHILE INKEY() # 27
        CALL COMETMP WITH FChkCmd
        DispMess(FChkCmd, 1)
		IF ! 'ACTIVE' $ FChkCmd
			EXIT
		ENDIF
	ENDDO

	* Display final result of transfer, and ask if more files t send/recv
    DispMess('File Transfer ' + IIF('COMPLETE' $ FChkCmd, 'SUCCESSFUL.', 'FAILED.') + ' Hit any key ...', 0)
ENDDO


CLEAR
CALL COMETMP WITH 'DTR #' + ComPort + ',0'
DispMess('Disconnecting. CLOSing COM port. Hit any key ...', 0)
CALL COMETMP WITH 'CLOSE #' + ComPort          && Shut down port

* DispMess() - Displays a message and optionally waits for keypress
FUNCTION DispMess
PARAMETERS Mess, SecsToWait
@ 10,0 TO 14,79
@ 12,1 CLEAR TO 12,78
@ 12,1 SAY Mess
IF SecsToWait >= 0
  Key = INKEY(SecsToWait)
ENDIF

RETURN ''

