*ͻ*
*   System Name:   CODE BLOCK DEMONSTRATION SUITE                           *
*   Module Name:   CBSAVE.PRG                                               *
*   Description:   Shows how code blocks can be saved in a database in      *
*                  character format and then be retrieved and evaluated in  *
*                  another program.                                         *
*   Notes......:   Needs to be executed first to save the info in the       *
*                  database.  Then CBRESTOR.PRG should be run.              *
*                  ***  Compile with the /N/W/A switches  ***               *
*   Author.....:   Micheal Todd Charron                                     *
*   Date.......:   Oct. 23, 1990                                            *
*   History....:   Thought up, on a Train to Montreal                       *
*ͼ*

FUNCTION Main()
     LOCAL cCodeBlock

     CLS

     USE ROUTINES
     ZAP

     cCodeBlock:= '{ | p1, p2 | nLength := LEN( p1 ) - p2,' +;
               'SUBSTR( p1, 1, nLength ) }'

     APPEND BLANK
     REPLACE ROUTINES->CodeBlock WITH cCodeBlock

     cCodeBlock := '{ | p1 | IF( p1 != Nil, UPPER( p1 ),' +;
                '"Nothing was passed" ) }'

     APPEND BLANK
     REPLACE ROUTINES->CodeBlock WITH cCodeBlock

RETURN Nil

/******************************************************************************
  FUNCTION MAIN()
*******************************************************************************
        ͸
Line 23    cCodeBlock:= '{ | p1, p2 | nLength := LEN( p1 ) - p2,' +;         
Line 24              'SUBSTR( p1, 1, nLength ) }'                            
                                                                             
Line 26    APPEND BLANK                                                      
Line 27    REPLACE ROUTINES->CodeBlock WITH cCodeBlock                       
                                                                             
Line 29    cCodeBlock:= '{ | p1 | IF( p1 != Nil, UPPER( p1 ),' +;            
Line 30              '"Nothing was passed" ) }'                              
                                                                             
Line 32    APPEND BLANK                                                      
Line 33    REPLACE ROUTINES->CodeBlock WITH cCodeBlock                       
        ;
The character representation of the Code Blocks are stored in the variable
"cCodeBlock", an empty record is added to the end of the database and the
field "CodeBlock" is replaced with the strings.

The results of the two Code Blocks are evaluated in the program CBRESTOR.PRG.
I suggest you read it so you can see how this ends.
******************************************************************************/

