/* ----------------------------------------
	 cmore.prg  variation on NANTUCKET's PE.PRG

	 This is an enhanced version of NANTUCKET's PE.PRG that allows
	 view only mode or edit mode.  Plus it allows you to swap
	 to other files.  As always, the best documentation is
	 the code itself.  Remember, The code documents every
	 feature and EVERY BUG.

	 No claim is made on the brilliancy of my code.  I
	 modified PE.PRG as a simple exercise to become familiar
	 with CLIPPER 5.0's new features and instances.

	 Modified version of: PE.PRG by Pete Anolick
	 please feel free to modify and distribute freely.

	 To compile and link use a modified version of PE.RMK:
	 change occurances of PE to CMORE.

	 NOTE: I have moved all clipper include (*.CH) files to the
				 CLIPPER5\INCLUDE directory. You may have to change
				 the #include statements below to access them all on
				 your system.
	 NOTE: As mentioned in the clipper documentation SETCURSOR
				 or SET(_SET_CURSOR,..) is not guaranteed to do what
				 you expect.  I have had the cursor do different things
				 on different PC's.  You may find that the SC_NORMAL and
				 SC_INSERT parameters don't do what you expect.  In such
				 cases, simply change the code I have used.
	 NOTE: This code uses functions: MLCTOPOS and MPOSTOLC
				 which is not documented anywhere in the CLIPPER
				 manuals or online help (that I have found).
				 Their functions, however, can be gleaned by examining
				 the code and is basically a variant on the MLPOS function
				 that is described in the manual, except it deals with
				 character positions rather than line positions.
	 ---------------------------------------- */

#include "inkey.ch"
#include "memoedit.ch"
#include "setcurs.ch"
#include "directry.ch"

#define FALSE       .F.
#define TRUE        .T.
#define FILE_ERROR TRUE

/* key defs for pe */
#define EK_WRITE	K_ALT_W
#define EK_QUIT		K_ESC

/* structure used to contain information about edit in progress */
#define ES_TOP      1
#define ES_LEFT     2
#define ES_BOTTOM   3
#define ES_RIGHT    4

#define ES_FILE     5
#define ES_TEXT     6

#define ES_WIDTH    7
#define ES_TABSIZE	8
#define ES_SCROLL   9
#define ES_WRAP    10
#define ES_INS     11

#define ES_ROW     12
#define ES_COL     13
#define ES_RELROW  14
#define ES_RELCOL  15

#define ES_CHANGED 16
#define ES_LASTKEY 17

#define ES_PATTERN	18
#define ES_LASTFILE 19
#define ES_LENGTH   19

/* static vars scope to entire module */
static edit
static pe_maxrow, pe_maxcol
static pe_statcol, pe_sizecol
static pe_promptrow, pe_titlerow
static edit_mode := FALSE, view_mode := "Display Mode"
static sizedir := {}
static SCOLOR1, SCOLOR2, SCOLOR3

****
* cmore()
*
func cmore(p1, p2, p3, p4, p5)

local i, nKey, lDone, modeset := FALSE, usecolor := TRUE, tabsz := 2,;
			inputparams[5]

	/* some defaults */
	set(_SET_BELL,FALSE)
	set(_SET_SCOREBOARD,FALSE)
	set(_SET_CANCEL,FALSE)
	cls
	inputparams[1] := p1
	inputparams[2] := p2
	inputparams[3] := p3
	inputparams[4] := p4
	inputparams[5] := p5

	/* scan through input args */
	if(Empty(inputparams[1]))
		qout("syntax: CMORE filename [-25|-43|-50] [-bw] [-t<n>] [-ed]")
		qout("")
		qout(" where: filename         File you wish to view.")
		qout("        -25 | -43 | -50  Number of lines to display, the default is")
		qout("                         the highest screen mode available.")
		qout("        -bw              Black and White mode on color monitor.")
		qout("        -t<n>            Tabsize <n>, default is 2.")
		qout("        -ed              Edit mode (allows modification)")
		qout("")
		return (NIL)
	end

	for i = 2 to len(inputparams)
		if(empty(inputparams[i]))
			loop
		end
		if(inputparams[i] == "-25" .OR. inputparams[i] == "-43" .OR.;
			 inputparams[i] == "-50")
			modeset := TRUE
			if(!setmode(val(substr(inputparams[i],2)),80))
				setmode(25,80)
			end
			loop
		end
		if(lower(inputparams[i]) == "-bw")
			usecolor := FALSE
			loop
		end
		if(left(lower(inputparams[i]),2) == "-t")
			tabsz := val(substr(inputparams[i],3))
			tabsz := if(if(tabsz > 10, 10, tabsz) < 0, 1, tabsz)
			loop
		end
		if(lower(inputparams[i]) == "-ed")
			edit_mode := TRUE
			view_mode := "Update Mode"
			loop
		end
	next

	/* create the edit structure */
	edit := Array(ES_LENGTH)

	edit[ES_FILE] := UPPER(inputparams[1])
	sizedir := directory(edit[ES_FILE])
	if(!file(edit[ES_FILE]))
		tone(100,5)
		qout("File " + edit[ES_FILE] + " doesn't exist, sorry!")
		qout("")
		return (NIL)
	end
	if(sizedir[1][F_SIZE] > 64000)
		tone(100,5)
		qout("File " + edit[ES_FILE] + " is too large, sorry!")
		qout("")
		return (NIL)
	end

	if(iscolor() .AND. usecolor)
		setblink(FALSE)
		SCOLOR1 := "W+/B,*B/W"
		SCOLOR2 := "GR+/B"
		SCOLOR3 := "BG+/B"
	else
		SCOLOR1 := "W/N,N/W"
		SCOLOR2 := "W+/N"
		SCOLOR3 := "W+/N"
	end
	if(!modeset)
		if(!setmode(50,80))
			if(!setmode(43,80))
				setmode(25,80)
			end
		end
	end
	set(_SET_COLOR,SCOLOR3)
	cls

	pe_maxrow := Maxrow()
	pe_maxcol := Maxcol()
	pe_statcol := pe_maxcol - 19
	pe_promptrow := pe_maxrow - 1
	pe_titlerow := 0
	pe_sizecol := pe_maxcol - 18


	edit[ES_TOP] := 3
	edit[ES_LEFT] := 0
	edit[ES_BOTTOM] := pe_maxrow - 3
	edit[ES_RIGHT] := pe_maxcol

	edit[ES_WIDTH] := 132
	edit[ES_TABSIZE] := tabsz
	edit[ES_WRAP] := TRUE
	edit[ES_INS] := FALSE
	ReadInsert(FALSE)

	edit[ES_ROW] := 1
	edit[ES_COL] := 0
	edit[ES_RELROW] := 0
	edit[ES_RELCOL] := 0

	edit[ES_CHANGED] := FALSE
	edit[ES_LASTKEY] := 0

	edit[ES_PATTERN] := ""

	edit[ES_TEXT] := MemoRead(edit[ES_FILE])
	edit[ES_LASTFILE] := edit[ES_FILE]

	@ edit[ES_TOP] - 1,0 TO edit[ES_TOP] - 1, pe_maxcol
	@ edit[ES_BOTTOM] + 1,0 TO edit[ES_BOTTOM] + 1,pe_maxcol

	statsize()
	set(_SET_COLOR,SCOLOR2)
	Msg(" SHTAB               F2             ALT+ S       A      F     R       W",pe_maxrow)
	set(_SET_COLOR,SCOLOR1)
	@ pe_maxrow,7 say "scroll lock"
	@ pe_maxrow,24 say "Prev File"
	@ pe_maxrow,42 say "earch"
	@ pe_maxrow,50 say "gain"
	@ pe_maxrow,57 say "ile"
	@ pe_maxrow,63 say "ename"
	@ pe_maxrow,71 say "rite"
	lDone := FALSE

	while (!lDone)
		edit[ES_SCROLL] := if(edit_mode,TRUE,FALSE)
		DoEditing()
		nKey := edit[ES_LASTKEY]
		do case
			case (nKey == K_F2)
				swapfile()
			case (nKey == EK_WRITE)
				EditWrite()
			case (nKey == K_ALT_F)
				NewFile()
			case (nKey == K_ALT_S)
				Search()
			case (nKey == K_ALT_A)
				SearchAgain()
			case (nkey == K_ALT_R)
				NewName()
			case (nKey == EK_QUIT)
				lDone := PExit()
			otherwise
		end
	end

	setmode(25,80)
	setblink(TRUE)
	@ maxrow(), pe_maxcol SAY ""

return (NIL)

****
*	DoEditing()
*
func DoEditing()

	Setcursor(SC_NORMAL)
	edit[ES_WRAP] := TRUE
	edit[ES_TEXT] :=  MemoEdit( edit[ES_TEXT], edit[ES_TOP], edit[ES_LEFT],;
											edit[ES_BOTTOM], edit[ES_RIGHT], edit_mode, "ufunc",;
											edit[ES_WIDTH], edit[ES_TABSIZE], edit[ES_ROW],;
											edit[ES_COL], edit[ES_RELROW], edit[ES_RELCOL] )

return (NIL)

****
* EditWrite()
*
func EditWrite()

	if(edit[ES_CHANGED] )
		Msg( "Writing " + edit[ES_FILE],pe_promptrow)
		if ( MemoWrit(edit[ES_FILE], edit[ES_TEXT]) )
			Msg("Write OK", pe_promptrow)
			edit[ES_CHANGED] := FALSE
		else
			Msg("Write error", pe_promptrow)
			return (FALSE)
		end
	else
		Msg("File has not been modified -- not written.", pe_promptrow)
	end

return (TRUE)

****
* Help()
*
func Help()

local origscrn, c, origcurs, orow, ocol

	orow = row()
	ocol = col()
	origcurs := setcursor(SC_NONE)
	origscrn := savescreen(0,0,pe_maxrow,pe_maxcol)
	set(_SET_COLOR,SCOLOR3)
	cls
	@ 0,33 say "HELP for CMORE"
	set(_SET_COLOR,SCOLOR2)
	@ 2,2 say "KEY"
	@ 2,20 say "ACTION"
	set(_SET_COLOR,SCOLOR1)
	@ 4,2 say "<ARROWS>          Move Cursor in direction of arrow pressed"
	@ 5,2 say "<CTRL Left Arrow> Move left 1 word"
	@ 6,2 say "<CTRL Rt Arrow>   Move right 1 word"
	@ 7,2 say "<HOME>            Move to beginning of current line"
	@ 8,2 say "<END>             Move to end of current line"
	@ 9,2 say "<CTRL HOME>       Move to top of screen"
	@ 10,2 say "<CTRL END>        Move to bottom of screen"
	@ 11,2 say "<PGUP>            Scroll up 1 screen"
	@ 12,2 say "<PGDN>            Scroll down 1 screen"
	@ 13,2 say "<CTRL PGUP>       Move to beginning of file"
	@ 14,2 say "<CTRL PGDN>       Move to end of file"
	@ 15,2 say "<CTRL Y>          Delete current line (Update Mode only)"
	@ 16,2 say "<CTRL T>          Delete word right   (Update Mode only)"
	@ 17,2 say "<CTRL B>          Reform paragraph    (Update Mode only)"
	@ 18,2 say "<INS>             Toggle insert mode  (Update Mode only)"
	@ 19,2 say "<ALT> keys        Described at bottom of edit window"
	@ 20,2 say "<F2>              switch between 2 files"
	@ 21,2 say "<SHIFT TAB>       Toggle scoll lock mode"
	@ 22,2 SAY "<ESC>             Exit CMORE"
	set(_SET_COLOR,SCOLOR3)
	@ 24,20 say "Press <ESC> to return to edit window..."
	set(_SET_COLOR,SCOLOR1)
	tone(300,5)
	do while((c := Upper(Chr(InKey(0)))) != Chr(K_ESC))
	end
	restscreen(0,0,pe_maxrow,pe_maxcol,origscrn)
	setpos(orow, ocol)
	setcursor(origcurs)
return (NIL)

****
*	Msg()
*
func Msg(text,location)

	if(location != pe_promptrow)
		set(_SET_COLOR,SCOLOR2)
	end
	@ location,0 say space(pe_statcol)
	@ location,0 SAY text
	set(_SET_COLOR,SCOLOR1)

return (NIL)

****
* NewFile()
*
func NewFile()

local name, lret

	if(edit[ES_CHANGED])
		if(!(lret := PExit()))
			return (FILE_ERROR)
		end
	end
	name := Prompt("NEWFILE: Enter new file name:", PadR(edit[ES_FILE], 64))
	if(lastkey() == K_ESC)
		msg(SPACE(pe_maxcol),pe_promptrow)
		return (FILE_ERROR)
	end
	name := Lower(Ltrim(Rtrim(name)))
	if ( !Empty(name) .AND. name != edit[ES_FILE] .AND. FILE(name))
		edit[ES_ROW] := 1
		edit[ES_COL] := 0
		edit[ES_RELROW] := 0
		edit[ES_RELCOL] := 0
		edit[ES_LASTFILE] := edit[ES_FILE]
		edit[ES_FILE] := name
		edit[ES_CHANGED] := FALSE
		edit[ES_TEXT] := MemoRead(edit[ES_FILE])
		edit[ES_INS] := FALSE
		ReadInsert(FALSE)
		sizedir := directory(edit[ES_FILE])
		if(sizedir[1][F_SIZE] > 64000)
			@ edit[ES_TOP],0 say "File " + sizedir[1][F_NAME] + " is too large, sorry!"
			setmode(25,80)
			setblink(TRUE)
			@ maxrow(), pe_maxcol SAY ""
			quit
		end
		statsize()
		msg(SPACE(pe_maxcol),pe_promptrow)
		return (NIL)
	else
		tone(100,3)
		msg("NEWFILE: " + name + " Invalid",pe_promptrow)
		return (FILE_ERROR)
	end

****
* NewName()
*
func NewName()

local name

	name := Prompt("RENAME: Enter new file name:", PadR(edit[ES_FILE], 64))
	if(lastkey() == K_ESC)
		msg(SPACE(pe_maxcol),pe_promptrow)
		return (FILE_ERROR)
	end
	name := Lower(Ltrim(Rtrim(name)))
	if ( !Empty(name) .AND. (name != edit[ES_FILE]) .AND. (!FILE(name)))
		if(frename(edit[ES_FILE],name) == -1)
			msg("Rename error: " + str(ferror(),3),pe_promptrow)
			return(FILE_ERROR)
		end
		edit[ES_FILE] := name
		Msg(Space(pe_maxcol),pe_promptrow)
		statsize()
	else
		tone(100,3)
		msg("RENAME: Can't rename file!",pe_promptrow)
	end

return (NIL)

****
* PExit()
*
func PExit()
local c, lRet

	lRet = TRUE
	if ( edit[ES_CHANGED] )
		Msg("EXIT: File was changed, Abandon " + edit[ES_FILE] + " [ynw]?",pe_promptrow)
		do while(!((c := Upper(Chr(InKey(0)))) $ ("YNW" + Chr(K_ESC))))
		end
		if ( c == "W" )
			lRet := EditWrite()
		else
			if ( c != "Y" )
				lRet := FALSE
			end
			Msg(space(pe_maxcol),pe_promptrow)
		end
	end

return (lRet)

****
* Prompt()
*
func Prompt(cSay, cGet)
memvar getlist

	Msg(Space(pe_maxcol),pe_promptrow)
	@ pe_promptrow,0 SAY cSay GET cGet Picture;
			"@KS"+Ltrim(Str(pe_maxcol-(Len(cSay)+1)))
	READ

return (cGet)

****
* Search()
*
func Search()

local pattern

	pattern := Prompt("SEARCH: Look for:", PadR(edit[ES_PATTERN], 64))
	if(lastkey() == K_ESC)
		Msg(SPACE(pe_maxrow),pe_promptrow)
		return (NIL)
	end
	pattern := lower(Ltrim(Rtrim(pattern)))
	if ( !Empty(pattern) )
		edit[ES_PATTERN] := pattern
		xSearch(0)
	else
		msg(SPACE(pe_maxcol),pe_promptrow)
	end

return (NIL)

****
* SearchAgain()
*
func SearchAgain()

return (xSearch(1))

****
*	StatMsg()
*
func StatMsg()

local cLine, cCol

	cLine := PadR(LTrim(Str(edit[ES_ROW])),5)
	cCol := PadR(LTrim(Str(edit[ES_COL] + 1)),3)
	@ pe_promptrow, pe_statcol SAY "Row: " + cLine + " Col: " + cCol

return (NIL)

****
* StatSize()
*
func StatSize(text)

	set(_SET_COLOR,SCOLOR1)
	@ pe_titlerow, 0 clear to pe_titlerow + 1, pe_maxcol
	@ pe_titlerow, 0 say "File: " + sizedir[1][F_NAME] +;
				SPACE(pe_maxcol - (24 + len(sizedir[1][F_NAME]))) +;
				if(edit[ES_INS],"INS","   ") + "   " + view_mode
	set(_SET_COLOR,SCOLOR2)
	@ pe_titlerow + 1, 0 say  "Size: " +;
			transform(sizedir[1][F_SIZE],"99,999") +;
			"  Date: " + DTOC(sizedir[1][F_DATE]) + "  Time: " +;
			sizedir[1][F_TIME] + "  Attr: " + sizedir[1][F_ATTR]
	set(_SET_COLOR,SCOLOR1)
	@ pe_titlerow+ 1, pe_maxcol - 7 say "F1-Help"

return (NIL)

****
* SwapFile()
*
func SwapFile()

local name, lret

	if(edit[ES_CHANGED])
		if(!(lret := PExit()))
			return (FILE_ERROR)
		end
	end
	if(edit[ES_LASTFILE] != edit[ES_FILE] .AND. FILE(edit[ES_FILE]))
		edit[ES_ROW] := 1
		edit[ES_COL] := 0
		edit[ES_RELROW] := 0
		edit[ES_RELCOL] := 0
		name := edit[ES_FILE]
		edit[ES_FILE] := edit[ES_LASTFILE]
		edit[ES_LASTFILE] := name
		edit[ES_CHANGED] := FALSE
		edit[ES_TEXT] := MemoRead(edit[ES_FILE])
		edit[ES_INS] := FALSE
		ReadInsert(FALSE)
		sizedir := directory(edit[ES_FILE])
		if(sizedir[1][F_SIZE] > 64000)
			@ edit[ES_TOP],0 say "File " + sizedir[1][F_NAME] + " is too large, sorry!"
			setmode(25,80)
			setblink(TRUE)
			@ maxrow(), pe_maxcol SAY ""
			quit
		end
		statsize()
		msg(SPACE(pe_maxcol),pe_promptrow)
		return (NIL)
	else
		tone(100,3)
		msg("SWAPFILE: can't switch to previous file",pe_promptrow)
		return (FILE_ERROR)
	end

****
* ufunc()
*
func ufunc(nMode, nLine, nCol)

local nKey

	edit[ES_LASTKEY] := nKey := LastKey()
	edit[ES_ROW] := nLine
	edit[ES_COL] := nCol
	edit[ES_RELROW] := Row() - edit[ES_TOP]
	edit[ES_RELCOL] := Col() - edit[ES_LEFT]
	if (nMode == ME_INIT)
		if (edit[ES_WRAP])
			/* turn off word wrap */
			edit[ES_WRAP] := FALSE
			return (ME_TOGGLEWRAP)  /* NOTE */
		end
		if(edit[ES_SCROLL] == FALSE)
			/* turn on scrolling */
			edit[ES_SCROLL] := TRUE
			return(ME_TOGGLESCROLL)
		end
	elseif (nMode == ME_IDLE)
		StatMsg()
	else
		/* keystroke exception */
		if (nMode == ME_UNKEYX)
			edit[ES_CHANGED] := TRUE
		end
		do case
			case (nKey == K_F1)     /* help */
				help()
			case (nKey == K_F2)    /* display last file */
				return(K_CTRL_W)
			case (nKey == K_ALT_F) /* display new file */
				return(K_CTRL_W)
			case (nKey == K_ALT_R)
				return(K_CTRL_W)
			case (nKey == K_CTRL_V)
				if(edit_mode)
					edit[ES_INS] := !ReadInsert()
					Setcursor((if(edit[ES_INS], SC_INSERT, SC_NORMAL)))
					statsize()
					return (nKey)
				end
			case (nKey == K_SH_TAB) /* scroll lock toggle */
				edit[ES_SCROLL] := !edit[ES_SCROLL]
				return(ME_TOGGLESCROLL)
			case (nKey == K_ALT_S)
				/* search */
				return (K_CTRL_W)
			case (nKey == K_ALT_A)
				/* search again */
				return (K_CTRL_W)
			case (nKey == EK_QUIT)
				return (K_CTRL_W)
			case (nKey == EK_WRITE)
				if(edit_mode)
					return (K_CTRL_W)
				end
			otherwise
		end
	end

return (0)

****
* xSearch()
*
func xSearch(x)

local nRow, pos, offset, newcol, a

	if ( !Empty(edit[ES_PATTERN]) )
		nRow := edit[ES_ROW]
		pos := x + MLCToPos(edit[ES_TEXT], edit[ES_WIDTH], edit[ES_ROW],;
												edit[ES_COL], edit[ES_TABSIZE], edit[ES_WRAP])
		offset := pos + At(edit[ES_PATTERN], Substr(lower(edit[ES_TEXT]), pos)) - 1
		if ( offset >= pos )
			a := MPosToLC(edit[ES_TEXT], edit[ES_WIDTH], offset,;
										edit[ES_TABSIZE], edit[ES_WRAP])
			edit[ES_ROW] := a[1]
			newcol := a[2]
			edit[ES_RELCOL] := edit[ES_RELCOL] + newcol - edit[ES_COL]
			edit[ES_COL] := newcol
			if (edit[ES_ROW]-nRow<1+edit[ES_BOTTOM]-edit[ES_TOP]-edit[ES_RELROW])
				edit[ES_RELROW] := edit[ES_RELROW] + edit[ES_ROW] - nRow
			end
			tone(300,1)
			Msg("SEARCH: Search Pattern found.",pe_promptrow)
		else
			tone(100,3)
			Msg("SEARCH: Search Pattern NOT found.",pe_promptrow)
		end
	else
		msg(SPACE(pe_maxcol),pe_promptrow)
	end

return (NIL)
