PAGE 62, 132
;*****************************************************************************
;* FILENAME : IPCAFUNC         Version 1.0                   02/10/89        *
;*                                                                           *
;* PURPOSE  : Provide Inter-Program Communication Area (IPCA) access         *
;*            from a Clipper program.  This is used in conjunction           *
;*            with the CLPSHELL program to provide controlled program        *
;*            switching completely under program control.                    *
;*                                                                           *
;* USAGE    : PUT_IPCA(varc)    -- Places 16 characters into IPCA            *
;*            varc = GET_IPCA() -- Return 16 characters from IPCA            *
;*                                                                           *
;* NOTES    : No parameter checking is done!                                 *
;*            No string length checking is done!                             *
;*                                                                           *
;* Author   : Paul G. Kurr                                                   *
;*                                                                           *
;*  Send all inquiries to:         or if you prefer,                         *
;*                                 you may reach me via:                     *
;*     Language LightHouse                                                   *
;*     Paul G. Kurr                   Language LightHouse BBS                *
;*     4150 Megan Road                                                       *
;*     Duluth, GA 30136                  404 - 263 - 1151                    *
;*                                                                           *
;* Copyright: (c) Copyright 1989, Paul G. Kurr all rights reserved.          *
;*                                                                           *
;* Warranty : No warranties or guarantees are given, either expressly or     *
;*            implied.                                                       *
;*                                                                           *
;* Legal    : In no event will the author be liable for any lost profits,    *
;*            lost savings, or any incidental damages or other consequential *
;*            damages (real or otherwise), even if the author has been       *
;*            advised of the possibility of such damages, or for any claim   *
;*            by you (the user) based on a third party claim.                *
;*                                                                           *
;*            These program(s) and/or routine(s) are released under the      *
;*            shareware concept "as is" for use by any and all persons       *
;*            and/or corporations.  Copying and/or distribution of these     *
;*            program(s) and/or routine(s) is permitted only under the       *
;*            following conditions:                                          *
;*                   1) it is done so in the original unmodified form,       *
;*                   2) that all credits remain fully in-tact.               *
;*            Changes to the original source code of said program(s) and/or  *
;*            routine(s) is permitted for the sole purpose of private use.   *
;*            The user also agrees not to distribute any modified form of    *
;*            these programs and/or routines without the express written     *
;*            consent of the author.                                         *
;*                                                                           *
;*            Use of these program(s) and/or routines confirms your          *
;*            unconditional acceptance of the above conditions.              *
;*                                                                           *
;* Other    : If you use these program(s) and/or routine(s), and find them   *
;*            of value, your "contribution" would be appreciated and inspire *
;*            further development of other useful software products.         *
;*                                                                           *
;*          * Clipper is a registered trademark of Nantucket Corp. *         *
;*****************************************************************************
page
PUBLIC               PUT_IPCA
PUBLIC               GET_IPCA

EXTRN                __PARC:FAR
EXTRN                __RET:FAR
EXTRN                __RETCLEN:FAR

DGROUP               GROUP DATASG
DATASG               SEGMENT 'DATA'

FILLER               DB        01, 02, 03, 04

IPCA_OFFSET          DW        0F0h
IPCA_segment         DW        040h

DATASG               ENDS

CODESEG              SEGMENT 'CODE'
                     ASSUME  CS:CODESEG,DS:DGROUP

PUT_IPCA             PROC      FAR

;* INITIALIZATION PROCEDURE

                     PUSH      BP
                     MOV       BP,SP

                     PUSH      DS
                     PUSH      es
                     PUSH      si
                     PUSH      di

;* GET THE parameter

                     MOV       AX,01
                     PUSH      AX
                     CALL      __PARC
                     ADD       SP, 2

                     PUSH      ES                  ;SEGMENT 0040h
                     PUSH      IPCA_SEGMENT
                     POP       ES
                     MOV       DI, IPCA_OFFSET     ;OFFSET 00F0h

                     PUSH      DS
                     MOV       DS, DX
                     MOV       SI, AX

                     MOV       CX, 10h             ;16 BYTES to MOVE

                     REP       MOVSB               ;MOVE IT!

                     POP       ES
                     POP       DS

                     CALL      __RET


;* TERMINATION PROCEDURE

                     POP       DI
                     POP       SI
                     POP       ES
                     POP       DS
                     POP       bp
                     
                     RET


PUT_IPCA             ENDP

GET_IPCA             PROC      FAR

;* INITIALIZATION PROCEDURE

                     PUSH      BP
                     MOV       BP,SP

                     PUSH      DS
                     PUSH      ES
                     PUSH      SI
                     PUSH      DI

                     MOV       AX, 0010H           ;RETURN 16 CHARACTERS
                     PUSH      AX
                     MOV       AX, IPCA_SEGMENT    ;SEGMENT
                     PUSH      AX
                     MOV       AX, IPCA_OFFSET     ;OFFSET
                     PUSH      AX
                     CALL      __RETCLEN
                     ADD       SP, 06

;* TERMINATION PROCEDURE

                     POP       DI
                     POP       SI
                     POP       ES
                     POP       DS
                     POP       bp
                     
                     RET

GET_IPCA             ENDP

CODESEG              ENDS
                     END
