SET SCOREBOARD OFF
CLEAR
* initialize border characters
double = 201
sgldbl = 213
dblsgl = 214
single = 218

* see if this is a color system
IF ISCOLOR()
   ltr1clr = "B/H/"
   ltr2clr = "G/H/"
   ltr3clr = "C/H/"
   ltr4clr = "R/H/"
   ltr5clr = "M/H/"
   ltr6clr = "O/H/"
   ltr7clr = "W/H/"
   fastclr = "R/H/"
   wnc1clr = "A/O/H/"
   wnc2clr = "W/M/H/"
   wnc3clr = "R/C/H/"
   wnc4clr = "O/G/H/"
   wnc5clr = "B/W/H/"
   wnc6clr = "A/R/H/"
   wnc7clr = "B/W/H"
   wnb1clr = "B/W/H/"
   wnb2clr = "A/R/H/"
   wnp1clr = "C/O/H/"
   wnp2clr = "W/A/"
   wnp3clr = "W/R/H/"
ELSE
   ltr1clr = "W/H/"
   ltr2clr = "W/H/"
   ltr3clr = "W/H/"
   ltr4clr = "W/H/"
   ltr5clr = "W/H/"
   ltr6clr = "W/H/"
   ltr7clr = "W/H/"
   fastclr = "W/H/"
   wnc1clr = "W/A//"
   wnc2clr = "W/A//"
   wnc3clr = "W/A//"
   wnc4clr = "W/A//"
   wnc5clr = "W/A//"
   wnc6clr = "A/W//"
   wnc7clr = "A/W/H/"
   wnb1clr = "A/W//"
   wnb2clr = "A/W//"
   wnp1clr = "W/A/"
   wnp2clr = "W/A/"
   wnp3clr = "W/A/"
ENDIF
SET CURSOR OFF
STORE 0 to wn1, wn2, wn3, wn4, wn5, wn6, wn7
@ 24,0 SAY ' '
TEXT

                  Windows For Clipper / Summer '87 Version

       Welcome, this is a demo of the Windows For  Clipper Library for the 
    Summer '87  version of the Clipper compiler. This demo will give you a
    breif introduction to the power of  the library and what it can do for
    you. The source code for this demo is included so you can see how easy
    it  is to use the window  functions.  The library contains  all of the 
    basic functions needed to create and manipulate windows in the Clipper
    programming language. There  are other video functions  included also.
    The  NEWCOLOR()  and  BIGSTR() functions. The NEWCOLOR() function will
    change  the the color  of any  target  area of the current screen. You
    can change a single character, a segment of any line, or a whole block 
    area of the screen. The BIGSTR() function will write large characters.
    Each character is 8 columns wide  and 8 rows high. This function  is a
    good  way to  create impressionable,  high visibility  opening screens. 
    You will see examples of this in a  moment. 


       For professional  looking applications  order your  copy today. For 
    ordering information,  please see the  REGISTER.DOC file included with
    this demo.
                         Press A key when you're ready 

ENDTEXT
INKEY(0)
CLEAR
STORE 0 to wn1, wn2, wn3, wn4, wn5, wn6, wn7

* init first window and use defaults
wn1 = _SINIT_WN(1,16,8,8)

* draw the window on screen
_SDRW_WN(wn1)

* put a big letter in it
_BIGSTR("W",1,16,CHR(219), ltr1clr, 1)

* move the window into postion
MV_WN(wn1,0,0)

* init the second window
wn2 = _SINIT_WN(1,16,8,8)

* draw the window on screen
_SDRW_WN(wn2)

* put a big letter on the screen
_BIGSTR("e",1,16,CHR(219), ltr2clr, 1)

* move the window into postion
MV_WN(wn2,8,0)

* init the third window
wn3 = _SINIT_WN(1,16,8,8)

* draw the window on screen
_SDRW_WN(wn3)

* put a big letter on the screen
_BIGSTR("l",1,16,CHR(219), ltr3clr, 1)

* move the window into postion
MV_WN(wn3,16,0)

* init the fourth window
wn4 = _SINIT_WN(1,16,8,8)

* draw the window on screen
_SDRW_WN(wn4)

* put a big letter on the screen
_BIGSTR("c",1,16,CHR(219), ltr4clr, 1)

* move the window into postion
MV_WN(wn4,24,0)

* init the fifth window
wn5 = _SINIT_WN(1,16,8,8)

* draw the window on screen
_SDRW_WN(wn5)

* put a big letter on the screen
_BIGSTR("o",1,16,CHR(219), ltr5clr, 1)

* move the window into postion
MV_WN(wn5,32,0)

* init the sixth window
wn6 = _SINIT_WN(1,16,8,8)

* draw the window on screen
_SDRW_WN(wn6)

* put a big letter on the screen
_BIGSTR("m",1,16,CHR(219), ltr6clr, 1)

* move the window into postion
MV_WN(wn6,40,0)

* init the seventh window
wn7 = _SINIT_WN(1,16,8,8)

* draw the window on screen
_SDRW_WN(wn7)

* put a big letter on the screen
_BIGSTR("e",1,16,CHR(219), ltr7clr, 1)

* move the window into postion
MV_WN(wn7,48,0)

@ 19,06 SAY "Impressive ? Well, if you think so that's great! If you're not convinced"
@ 20,04 SAY "yet, just stick around. Maybe what you will see in the rest of the demo"
@ 21,04 SAY "will impress you. I hope so!"
@ 23,26 SAY "Press Any Key To Continue"
* delay half second.
INKEY(.5)
* write a big string!
_BIGSTR("FAST!",20,10,CHR(177), fastclr, 1)

key = 0
* make the last lines color fluctuate
DO WHILE key = 0
   IIF(ISCOLOR(), _NEWCOLOR(26,23,51,23, "A/R/"), _NEWCOLOR(26,23,51,23, "W/A/"))
   FOR n = 1 TO 150
   NEXT
   IIF(ISCOLOR(), _NEWCOLOR(26,23,51,23, "A/B/"), _NEWCOLOR(26,23,51,23, "A/W/"))
   key = INKEY(.1)
ENDDO
* remove the windows from memory
_SREM_WN(wn1)
_SREM_WN(wn2)
_SREM_WN(wn3)
_SREM_WN(wn4)
_SREM_WN(wn5)
_SREM_WN(wn6)
_SREM_WN(wn7)
* reset variable values to 0
Store 0 to wn1, wn2, wn3, wn4, wn5
* initialize needed windows
wn1 = _SINIT_WN(0,0,28,9)
wn2 = _SINIT_WN(50,0,28,9)
wn3 = _SINIT_WN(50,14,28,9)
wn4 = _SINIT_WN(0,14,28,9)
wn5 = _SINIT_WN(25,7,28,9)
* set borders, colors etc.
_SST_WNBC(wn1, double)
_SST_WNBC(wn2, double)
_SST_WNBC(wn3, double)
_SST_WNBC(wn4, double)
_SST_WNBC(wn5, double)
_SST_WNCL(wn1, wnc1clr, "C")
_SST_WNCL(wn2, wnc2clr, "C")
_SST_WNCL(wn3, wnc3clr, "C")
_SST_WNCL(wn4, wnc4clr, "C")
_SST_WNCL(wn5, wnc5clr, "C")
_SST_WNCL(wn1, wnb1clr, "B")
_SST_WNCL(wn2, wnb1clr, "B")
_SST_WNCL(wn3, wnb1clr, "B")
_SST_WNCL(wn4, wnb1clr, "B")
_SST_WNCL(wn5, wnb1clr, "B")

* make the windows do a dance
FOR n = 1 TO 3
   _SDRW_WN(wn1)
   _SWTE_TXT(wn1, " ")
   _SWTE_TXT(wn1, " ")
   _SWTE_TXT(wn1, " ")
   _SWTE_TXT(wn1, "   They're easy to use  ")
   _SWTE_TXT(wn1, " ")
   _SWTE_TXT(wn1, "     Not confusing.")
   INKEY(.1)
   _SDRW_WN(wn2)
   _SWTE_TXT(wn2, " ")
   _SWTE_TXT(wn2, " ")
   _SWTE_TXT(wn2, " ")
   _SWTE_TXT(wn2, "   They're Very fast    ")
   _SWTE_TXT(wn2, " ")
   _SWTE_TXT(wn2, "      Not Clunkers.")
   INKEY(.1)
   _SDRW_WN(wn3)
   _SWTE_TXT(wn3, " ")
   _SWTE_TXT(wn3, " ")
   _SWTE_TXT(wn3, " ")
   _SWTE_TXT(wn3, "   They need very little")
   _SWTE_TXT(wn3, " ")
   _SWTE_TXT(wn3, "   ram to operate.")
   INKEY(.1)
   _SDRW_WN(wn4)
   _SWTE_TXT(wn4, " ")
   _SWTE_TXT(wn4, " ")
   _SWTE_TXT(wn4, " ")
   _SWTE_TXT(wn4, "   Designed specifically")
   _SWTE_TXT(wn4, "          for the" )
   _SWTE_TXT(wn4, "     Clipper Compiler")
   INKEY(.1)
   _SDRW_WN(wn5)
   _SWTE_TXT(wn5, "    WINDOWS FOR CLIPPER")
   _SWTE_TXT(wn5, "        Version 2.0")
   _SWTE_TXT(wn5, "       By Jim Holley")
   _SWTE_TXT(wn5, "   1346 Woodington Cir.")
   _SWTE_TXT(wn5, "  Lawrenceville Ga, 30244")
   _SWTE_TXT(wn5, " ")
   _SWTE_TXT(wn5, " Clipper is a trademark of")
   _SWTE_TXT(wn5, "    Nantucket Corp.")
   IF n = 3
      EXIT                             && not terminating loop prematurely
                                       && just bypassing the next step
   ENDIF
   INKEY(.1)
   _SWNERASE(wn5)
   INKEY(.1)
   _SWNERASE(wn4)
   INKEY(.1)
   _SWNERASE(wn3)
   INKEY(.1)
   _SWNERASE(wn2)
   INKEY(.1)
   _SWNERASE(wn1)
   INKEY(.1)

NEXT
INKEY(5)
* remove the windows from memory
_SREM_WN(wn5)
_SREM_WN(wn4)
_SREM_WN(wn3)
_SREM_WN(wn2)
_SREM_WN(wn1)
CLEAR
*************************************
* Write standard text on the screen *
*************************************
@ 02,20 SAY "Demonstration of Windowed Database" 
@ 06,21 SAY "Its as easy as this" 
@ 08,21 SAY "USE <database name>" 
@ 09,21 SAY 'cur_record = _wn_dbf(wn,"Field" [,"Field" ,"Field"....])'
@ 10,02 SAY "A place to put                                      " 
@ 11,02 SAY "the record #                                       optional, up" 
@ 12,02 SAY "Returned.                                             to 10 fields" 
@ 13,36 SAY "                            allowed." 
@ 14,14 SAY "Call the                                      The field names" 
@ 15,14 SAY "function.             To write." 
@ 16,42 SAY "     The window" 
@ 17,42 SAY " to write in." 

* initialize needed variables
STORE 0 TO wn1, wn2, wn3

* initialize a window
wn2 = _SINIT_WN(0, 18, 78, 5)

* set borders, colors etc.
_SST_WNCL(wn2, wnc6clr, "C")
_SST_WNCL(wn2, wnb2clr, "B")
_SST_WNBC(wn2, sgldbl)

* put the window on the screen
_SDRW_WN(wn2)

* writes some text in the window
_SWTE_TXT(wn2, "      The Windows For Clipper library provides special functions that use")
_SWTE_TXT(wn2, "   database fields as arguments. These functions allow you to present the")
_SWTE_TXT(wn2, "   information contained in the database in any window regardless of size.")
_SWTE_TXT(wn2, "   Watch the next window for an example.")
_SWTE_TXT(wn2, "                         Press Any Key To Continue")
INKEY(0)

* initialize another window
wn1 = _sinit_wn(5, 3, 70, 10)       && init window to desired coordinates

* set borders, colors etc.
_SST_WNCL(wn1, wnc7clr, "C")        && set contents color
_SST_WNCL(wn1, wnb2clr, "B")        && set border color
_SST_WNBC(wn1, dblsgl)              && set border character
_SST_PTSL(wn1, 1)                   && select old stype pointer type
_SST_PTCL(wn1, wnp1clr)             && select pointer color
_SDRW_WN(wn1)                       && draw the window on the screen
USE customer                        && open the database
KEYBOARD CHR(27)                    && stuff keyboard with an escape to 
                                    && terminate the _WN_DBF() function

* call the _WN_DBF() function
ret_rec =  _wn_dbf(wn1, "custno", "comp_name", "comp_addr1", "comp_addr2", "comp_city", "comp_state", "comp_zip", "comp_phone")

* reset back to top of file
GO TOP

_SCLS_WN(wn2)                       && clear the text window

* write more text
_SWTE_TXT(wn2, "     Notice the records in the window. These are from the demo database ")
_SWTE_TXT(wn2, "   CUSTOMER.DBF. The pointer on the left side of the window can be moved ")
_SWTE_TXT(wn2, "   through the database in several ways. The directional keys on the ")
_SWTE_TXT(wn2, "   numeric key pad are used to navigate through the database. ")
_SWTE_TXT(wn2, "                          Press Any Key To Continue")

INKEY(0)
_SCLS_WN(wn2)                       && clear the text window

* etc.
_SWTE_TXT(wn2, "     The keys that can be used are as follows: The up & down arrow keys")
_SWTE_TXT(wn2, "   move you through the database a record at a time. The HOME & END keys")
_SWTE_TXT(wn2, "   will place you on the record that is at the top or bottom of the ")
_SWTE_TXT(wn2, "   window respectively. ")
_SWTE_TXT(wn2, "                         Press Any Key To Continue")
INKEY(0)

_SCLS_WN(wn2)                       && clear the text window
_SWTE_TXT(wn2, "     The CTRL-HOME & CTRL-END keys move you to the top or bottom of the ")
_SWTE_TXT(wn2, "   the database respectively. The PgDn & PgUp keys will move you forward")
_SWTE_TXT(wn2, "   or backward through the database a page at a time. The page size is ")
_SWTE_TXT(wn2, "   the same as the window size. A 10 row window will have a 10 record page.") 
_SWTE_TXT(wn2, "                         Press Any Key To Continue")
INKEY(0)

_SCLS_WN(wn2)                       && clear the text window
_SWTE_TXT(wn2, "     The left & right arrow key will scroll the database information left")
_SWTE_TXT(wn2, "   or right one field at a time. The window pointer will remain in the ")
_SWTE_TXT(wn2, "   same place, only the text will be moved.")
_SWTE_TXT(wn2, "                         Press Any Key To Continue")
INKEY(0)

_SCLS_WN(wn2)                       && clear the text window
_SWTE_TXT(wn2, "     The RETURN key, when pressed will terminate the _WN_DBF() function and")
_SWTE_TXT(wn2, "   return the record number that the window pointer is currently sitting ")
_SWTE_TXT(wn2, "   on. The ESC key, when pressed will terminate the _WN_DBF() function and")
_SWTE_TXT(wn2, "   return 0. Indicating no record was selected.")
_SWTE_TXT(wn2, "                         Press Any Key To Continue")
INKEY(0)

_SCLS_WN(wn2)                       && clear the text window
_SWTE_TXT(wn2, "     Now, take it for a test drive, trying out the different navigational keys.")
_SWTE_TXT(wn2, "   The above window will clear and the database records will be written again.")
_SWTE_TXT(wn2, "   At that point, you can press any key you want. Don't forget to press the ")
_SWTE_TXT(wn2, "   ESC or RETURN key when you're finished.")
_SWTE_TXT(wn2, "                         Press Any Key To START")
INKEY(0)

_SCLS_WN(wn1)
* call the _WN_DBF() function
ret_rec =  _wn_dbf(wn1, "custno", "comp_name", "comp_addr1", "comp_addr2", "comp_city", "comp_state", "comp_zip", "comp_phone")

_SCLS_WN(wn2)
_SWTE_TXT(wn2, "     The record you were on when you terminated was " + STR(ret_rec,2) + ". The window pointer")
_SWTE_TXT(wn2, "   used for this part of the demonstration is the first of two available.")
_SWTE_TXT(wn2, "   Let's do it again changing the pointer color and using the second window")
_SWTE_TXT(wn2, "   pointer type. ")
_SWTE_TXT(wn2, "                         Press Any Key To START")
INKEY(0)

* reset to top of file
GO TOP

_SST_PTCL(wn1, wnp3clr)     && set pointer color
_SST_PTSL(wn1, 2)           && select new style pointer type 
_SCLS_WN(wn1)

* call the _WN_DBF() function
ret_rec =  _wn_dbf(wn1, "custno", "comp_name", "comp_addr1", "comp_addr2", "comp_city", "comp_state", "comp_zip", "comp_phone")

_SCLS_WN(wn2)
_SWTE_TXT(wn2, "     The record you were on when you terminated was " + STR(ret_rec,2) + ". This and ")
_SWTE_TXT(wn2, "   and much more is available to you in the Windows For Clipper library.")
_SWTE_TXT(wn2, " ")
_SWTE_TXT(wn2, "                         Press Any Key To Continue")
INKEY(0)

* remove windows from memory
_SREM_WN(wn1)
_SREM_WN(wn2)

* clear the screen
CLEAR

* init another window
wn1 = _SINIT_WN(0, 0, 50,10)

* set borders, colors etc.
_SST_WNBC(wn1, sgldbl)
_SST_WNCL(wn1, wnc1clr, "C")
_SST_WNCL(wn1, wnc7clr, "B")

* put it on the screen
_SDRW_WN(wn1)

* etc.
_SWTE_TXT(wn1, "   You have complete control of the")
_SWTE_TXT(wn1, " Windows you create. You can move")
_SWTE_TXT(wn1, " them....")
INKEY(5)

* move the window on the screen
_SMOVE_WN(wn1, 12, 8)
_SWTE_TXT(wn1, " You can erase, clear or remove them.")
_SWTE_TXT(wn1, " You can write text in them using ")
_SWTE_TXT(wn1, " the functions provided in the library,")
_SWTE_TXT(wn1, " or you can use the Clipper @ SAY command.")
_SWTE_TXT(wn1, " The routines are functional as well as ")
_SWTE_TXT(wn1, " flexible. ")
INKEY(15)

* clear the window and write more text
_SCLS_WN(wn1)
_SWTE_TXT(wn1, "  If you use the functions in the library")
_SWTE_TXT(wn1, " to write text, you never have to worry")
_SWTE_TXT(wn1, " about long lines. The window output functions")
_SWTE_TXT(wn1, " will insure your windows integrity is never")
_SWTE_TXT(wn1, " destroyed. For instants:")
_SWTE_TXT(wn1, " ")
_SWTE_TXT(wn1, " This is a long line. This is a long line. This is a long line.")
_SWTE_TXT(wn1, " This applies to all borders of the window. The")
_SWTE_TXT(wn1, " top, bottom and sides.")
INKEY(15)
* erase the window
_SWNERASE(wn1)

* turn on the cursor
SET CURSOR ON
*******************************
* Demonstrate windowing using *
* Clippers  memo utilities.   *
*******************************
* set clipper colors if necessary
IF ISCOLOR()
   SET COLOR TO +W/B
ENDIF
CLEAR

*************************************
* write standard text to the screen *
* in a different way.               *
*************************************
TEXT

         This portion of the demo program will present techniques
       that can be used with Windows For Clipper, and a memo 
       function provided with the compiler. The same techniques
       can also be applied to the dbedit function, although it
       may be difficult to determine where the dbedit function will
       place the information. 

         In the following demonstration a window will be created, and 
       help text that explains the cursor controls will be written to
       the window. Next the MEMOEDIT function will be called. The 
       screen coordinates required by the MEMOEDIT function will be 
       inside the window. At that point the MEMOEDIT function will 
       take control until you terminate it. Once terminated, the 
       window will be removed and this text should re-appear. 
        
       
                       Press Any Key To Continue
ENDTEXT
************************
* wait for a key press *
************************

INKEY(0)

*****************************
* Create a window to cover  *
* the entire screen.        *
*****************************
wn2 = 0
wn2 = _SINIT_WN(0,0,78,23)

*****************************************
* If we made it this far, no need to be *
* sure if the window will be created.   *
* So, set the border character.         *
*****************************************
_SST_WNBC(wn2, double)

* set colors
_SST_WNCL(wn2, wnc5clr, "C")
_SST_WNCL(wn2, wnb1clr, "B")
*************************************
* now draw the window on the screen *
*************************************
_SDRW_WN(wn2)

********************************
* Write the help information   *
* to the window using Clipper. *
********************************
@ 01,32 SAY "Cursor Control"
@ 02,05 SAY ""+chr(24)+" or ^E  = Move up a line            HOME  = Beginning of current line"
@ 03,05 SAY ""+chr(25)+" or ^X  = Move down a line          END   = End of current line"
@ 04,05 SAY ""+chr(27)+" or ^S  = Move left a char.         ^HOME = Beginning of text"
@ 05,05 SAY ""+chr(26)+" or ^D  = Move right a char.        ^END  = End of text"
@ 06,05 SAY "^"+chr(27)+" or ^A = Move left a word          PgUp  = Jump to previous page"
@ 07,05 SAY "^"+chr(26)+" or ^F = Move right a word         PgDn  = Jump to next page"
@ 08,05 SAY "^PgUp    = Jump to top of screen     ^PgDn = Jump to bottom of screen"
@ 09,00 SAY "͹"
@ 10,29 SAY "Delete & Exit Control"
@ 11,12 SAY "^Y = Delete current line             ^B = Reformat text"
@ 12,12 SAY "^T = Delete word right               ESC = Exit no Save"
@ 13,30 SAY "^W = Exit with Save"
@ 14,00 SAY "͹"
* ""
 
***********************************************
* Okay, time to access the memoedit function. *
* The previous database is still in use.      *
* Position the record pointer to record 10.   *
* This is where the demo text is located in   *
* the memo file. One thing, if you decided to *
* to use this feature in this way, you need   *
* to be sure of is that the MEMOEDIT row,     *
* column coordinates do not exceed the        *
* boundaries of the window.                   *
***********************************************
GOTO(10)
MEMOEDIT(memo1, 15,1,23,78,.t.)

*******************************
* on return from the memoedit *
* function remove the window. *
*******************************
_SREM_WN(wn2)

SET CURSOR OFF
CLEAR
_SDRW_WN(wn1)
_SWTE_TXT(wn1, "  This concludes the Windows For Clipper Demo.")
_SWTE_TXT(wn1, " For more information, please refer to the Windows")
_SWTE_TXT(wn1, " For Clipper documentation and the REGISTER.DOC ")
_SWTE_TXT(wn1, " file included with this demo.")
_SWTE_TXT(wn1, " ")
_SWTE_TXT(wn1, "             Press Any Key To Continue")
INKEY(0)
SET CURSOR ON

* remove windows from memory
_SREM_WN(wn1)
CLEAR
RETURN

FUNCTION mv_wn
*************************************************
* This function moves the windows that contain  *
* the large letters for the demo.               *
*************************************************

parameter window, stop, delay
wnrow = 16
**************************************************
* this loop moves window right across the screen *
**************************************************
FOR wncol = 8 TO 64 STEP 8
   timer = 0
   **********************************************
   * move the window to new column, row coords. *
   **********************************************
   _smove_wn(window, wncol, wnrow)
   DO WHILE timer <= delay
      timer = timer + 1
   ENDDO
NEXT
*****************************************************
*  this loop moves window down right side of screen *
*****************************************************
wncol = 64
FOR wnrow = 8 TO 0 STEP -8
   timer = 0
   **********************************************
   * move the window to new column, row coords. *
   **********************************************
   _smove_wn(window, wncol, wnrow)
   DO WHILE timer <= delay
      timer = timer + 1
   ENDDO
NEXT
*************************************************
* this loop moves window left across the screen *
*************************************************
wnrow = 0
FOR wncol = 56 TO stop STEP -8
   timer = 0
   _smove_wn(window, wncol, wnrow)
   **********************************************
   * move the window to new column, row coords. *
   **********************************************
   DO WHILE timer <= delay
      timer = timer + 1
   ENDDO
NEXT
