/* Filename: TRIG_F.C
*  Program.: TRIGONOMETRIC FUNCTIONS
*
*      COSF() = Cosine function 
*      SINF() = Sine function
*      TANF() = Tangent function
*     ACOSF() = Arccosine function
*     ASINF() = Arcsine function
*     ATANF() = Arctangent function
*    ATANF2() = Arctangent of x/y
*
*/

#include "extend.h"
#include "stdio.h"
#include "math.h"

#define NULL         ""


/******************************************************************************
* COSF()
* Syntax: COSF(X)
*/

cosf()
{
   double x;
   x=_parnd(1);
   _retnd(cos(x));

}

/******************************************************************************
* SINF()
* Syntax: SINF(X)
*/

sinf()
{
   double x;
   x=_parnd(1);
   _retnd(sin(x));

}

/******************************************************************************
* TANF()
* Syntax: TANF(X)
*/

tanf()
{
   double x;
   x=_parnd(1);
   _retnd(tan(x));

}

/******************************************************************************
* ACOSF()
* Syntax: ACOSF(X)
*/

acosf()
{
   double x;
   x=_parnd(1);
   _retnd(acos(x));

}

/******************************************************************************
* ASINF()
* Syntax: ASINF(X)
*/

asinf()
{
   double x;
   x=_parnd(1);
   _retnd(asin(x));

}

/******************************************************************************
* ATANF()
* Syntax: ATANF(X)
*/

atanf()
{
   double x;
   x=_parnd(1);
   _retnd(atan(x));

}

/******************************************************************************
* ATANF2()
* Syntax: ATANF2(X)
*/

atanf2()
{
   double x,y;
   x=_parnd(1);
   y=_parnd(2);
   _retnd(atan2(x,y));

}

/******************************************************************************
*   eof: trig_f.c
*/

