PARAMETERS result, ok, x, y, sbuff
PRIVATE op_old
*
* save screen and display calculator
*
* if necessary, adjust coordinates so that calculator does not
* exceed the screen
*
x = IF(x > 48,48,x)
y = IF(y > 11,11,y)
DO disp_calc                                 && display calculator
*
* initialize variables
*
op = ""                                      && operator
op_old = ""                                  && LASTKEY operator
mov = .t.                                    && flag: move calculator
result = 0                                   && result
noerr = .t.                                  && error flag
*
* main loop - do it until entry is "x" or "e" (esc)
*
DO WHILE ! (op $ "XE" )
   *
   * read first operand and first operator
   *
   num = "0"
   DO getnum WITH num,op,x,y,op # "="
   *
   * handle result key, end, or clear entry
   *
   IF op $ "=XEC"
      IF ((op = "X" ) .AND. (op_old # "=" )) .OR. (op = "=" )
         result = val(num)
      ENDIF ((op = "X" ) .AND. (op_old # "=" )) .OR. (op = "=" )
      op_old = op
      @ y+2,x+2 SAY STR(result,21,4)
      @ y+4,x+26 SAY " "
      LOOP
   ENDIF op $ "=XEC"
   *
   * store first operand into result

   *
   result = val(num)
   *
   * read more operands and operators
   *
   DO WHILE .t.
      op_old = op
      DO getnum WITH num,op,x,y,.f.
      *
      * handle clear entry or end
      *
      IF op $ "XEC"
         EXIT
      ENDIF op $ "XEC"
      *
      * calculate...
      *
      result = calculate(result,num,op_old)
      *
      * overflow or divide by zero error ?
      *
      noerr = IF(result = 9999999999999999999999,.f.,.t.)
      *
      * display result
      *
      @ y+2,x+2 SAY STR(result,21,4)
      @ y+4,x+26 SAY " "
      *
      * handle result key
      *
      IF op = "="
         op_old = op
         EXIT
      ENDIF op = "="
   ENDDO WHILE .t.
ENDDO WHILE ! (op $ "xe" )
*
* set flag if result is ok
*
ok = IF(((op = "X" ) .AND. noerr),.t.,.f.)
*
*restore screen using a char-variable or the default buffer for
*save/restore screen
*
IF LEN(sbuff) # 4000
   RESTORE screen
ELSE
   call _scrrest WITH sbuff
ENDIF LEN(sbuff) # 4000
RETURN
*
* function to calculate the results
*
FUNCTION calculate
PARAMETERS result,num,operator
DO CASE
   CASE operator = "+"
      RETURN(result + val(num))
   CASE operator = "-"
      RETURN(result - val(num))
   CASE operator = "*"
      RETURN(result * val(num))
   CASE operator = "/"
      IF val(num) = 0
         ?? CHR(7)
         RETURN(9999999999999999999999)
         noerr = .f.
      ELSE
         RETURN(result / val(num))
         noerr = .t.
      ENDIF val(num) = 0
ENDCASE
*
* read a number into "num" and operand into "op"
*
* location for display is determined by x and y
*
* first clear the display if cl = .t.
*
PROCEDURE getnum
PARAMETERS num,op,x,y,cl
num = "0"
inp_dec = .f.
mant_len = 1
dec_len = 0
*
* clear display if needed
*
IF cl
   @ y+2,x+2 SAY STR(val(num),16,0) + "       "
   @ y+4,x+26 SAY " "
ENDIF cl
*
*main loop for character entry
*
DO WHILE .t.
   ch = getkey()
   DO CASE
      CASE ch $ "+-*/=XCE" && operands AND special keys
         op = ch
         @ y+2,x+27 SAY ch
         @ y+4,x+26 SAY " "
         EXIT
      CASE ch = "B" && backspace (CLEAR entry)
         num = "0"
         mant_len = 1
         dec_len = 0
         inp_dec = .f.
         @ y+2,x+2 SAY STR(val(num),16,0) + "        "
         @ y+4,x+26 SAY " "
      CASE ch = "V" && change sign
         num = IF(((inp_dec) .AND. (dec_len=0)), ;
         LTRIM(STR(-val(num),16,0)) + "." , ;
         LTRIM(STR(-val(num),16,dec_len)))
      CASE ch = "." && DECIMALS point
         IF inp_dec && already there ?
            ?? CHR(7)
         ELSE && no, DO it
            num = num + "."
            inp_dec = .t.                    && DECIMALS flag
         ENDIF inp_dec                       && already there ?
      OTHERWISE                              && enter a number KEY
         IF ! inp_dec                        && we are left of dec. point
            IF num = "0"                     && just started ?
               num = ch                      && this is our first digit
            ELSE
               IF mant_len = 10              && overflow ?
                  ?? CHR(7)                  && complain loud & CLEAR
               ELSE
                  num = num + ch             && no, i LIKE this digit
                  mant_len = mant_len + 1    && digit counter
               ENDIF mant_len = 10           && overflow ?
            ENDIF num = "0"                  && just started ?
         ELSE && we INPUT DECIMALS now
            IF dec_len = 4                   && overflow ?
               ?? CHR(7) && complain again
            ELSE && no, we LIKE this digit
               num = num + ch
               dec_len = dec_len + 1         && DECIMALS counter
            ENDIF dec_len = 4                && overflow ?
         ENDIF ! inp_dec                     && we are left of dec. point
   ENDCASE
   *
   * display the number
   *
   IF inp_dec && DECIMALS point ?
      IF dec_len = 0 && no DECIMALS
         @ y+2,x+2 SAY STR(val(num),16) + ".    "
      ELSE && there are DECIMALS
         @ y+2,x+2 SAY STR(val(num),17+ ;
         dec_len,dec_len) + ;
         SPACE(4-dec_len)
      ENDIF dec_len = 0                      && no DECIMALS
   ELSE && no DECIMALS point
      @ y+2,x+2 SAY STR(val(num),16) + "     "
   ENDIF inp_dec                             && DECIMALS point ?
   @ y+4,x+26 SAY " "
ENDDO WHILE .t.
RETURN
*
* read keyboard entry
*
FUNCTION getkey
DO WHILE .t.
   *
   * check the arrow keys if move is still active
   *
   DO WHILE .t.
      c = INKEY(0)
      IF mov .AND. ((c=5) .OR. (c=24) .OR. (c=19) ;
         .OR. (c=4) .OR. (c=26) .OR. ;
         (c=2) .OR. (c=1) .OR. (c=6))
         DO mov_calc WITH c
      ELSE
         EXIT
      ENDIF mov .AND. ((c=5) .OR. (c=24) .OR. (c=19) ;
   ENDDO WHILE .t.
   ch = UPPER(CHR(c))
   DO CASE
      CASE ch $ "0123456789+-*/=VXC."        && numbers OR special keys
         DO mov_off                          && no more moving around
         RETURN(ch)
      CASE c = 8 && back SPACE
         DO mov_off
         RETURN( "B" )
      CASE ch = ","                          && comma -->dot (TO make the
         DO mov_off                          && europeans happy
         RETURN( "." )
      CASE c = 13 && RETURN --> =
         DO mov_off
         RETURN( "=" )
      CASE c = 27                            && esc
         DO mov_off
         RETURN( "E" )
         OTHERWISE                           && we dont like other keys,
         ?? CHR(7)                           && so let everybody know
   ENDCASE
ENDDO WHILE .t.
*
* no more moving around - clear the arrow symbols
*
PROCEDURE mov_off
IF mov
   @ y+6,x+26 SAY "    "
   @ y+8,x+26 SAY "    "
   @ y+4,x+26 SAY " "
   mov = .f.
ENDIF mov
RETURN
*
* display calculator
*
PROCEDURE disp_calc
*
* save screen into char variable if it has exactly 4000 chars
* or use the default buffer for save/restore screen
*
IF LEN(sbuff) # 4000
   save screen
ELSE
   call _scrsave WITH sbuff
ENDIF LEN(sbuff) # 4000
*
* display calculator
* this can also be done with graphics characters
@ y+ 0,x SAY "--------------------------------"
@ y+ 1,x SAY "|-----------------------------||"
@ y+ 2,x SAY "|                0      |     ||"
@ y+ 3,x SAY "|-----------------------------||"
@ y+ 4,x SAY "| ESC |  X  | BSp |  C  |     ||"
@ y+ 5,x SAY "|-----------------------------||"
@ y+ 6,x SAY "|  7  |  8  |  9  |  +  | " + CHR(30) + " " + CHR(31) + " ||"
@ y+ 7,x SAY "|-----------------------------||"
@ y+ 8,x SAY "|  4  |  5  |  6  |  -  | " + CHR(17) + " " + CHR(16) + " ||"
@ y+ 9,x SAY "|-----------------------------||"
@ y+10,x SAY "|  1  |  2  |  3  |  *  |V=+/-||"
@ y+11,x SAY "|-----------------------------||"
@ y+12,x SAY "|  0  |  .  |     |  /  |=|Ret||"
@ y+13,x SAY "--------------------------------"
@ y+4,x+26 SAY " "
RETURN
*
* move the calculator
*
PROCEDURE mov_calc
PARAMETERS c
*
* restore screen from char variable or default buffer
*
IF LEN(sbuff) # 4000
   RESTORE screen
ELSE
   call _scrrest WITH sbuff
ENDIF LEN(sbuff) # 4000
DO CASE
   CASE (c = 5) .AND. (y > 0)                && up arrow
      y = y - 1
   CASE (c = 24) .AND. (y < 11)              && dwn arrow
      y = y + 1
   CASE (c = 19) .AND. (x > 0)               && left arrow
      x = x - 1
   CASE (c = 4) .AND. (x < 48)               && right arrow
      x = x + 1
   CASE (c = 26)                             && ctl-left arrow
      x = 0
   CASE (c = 2)                              && ctl-right arrow
      x = 48
   CASE (c = 1)                              && home
      y = 0
   CASE (c = 6)                              && end
      y = 11
ENDCASE
DO disp_calc                                 && re-display the calculator
RETURN

