***************************************
Func DoBox
***************************************
PARA nUpper,nLeft,nLower,nRight,cTitle_Area,cTitle,expFrame,lZoom,lShadow,;
 cColor,cTitle_Clr,nSpeed,cSubTitle,cSubTitle_Clr,cTitle_Just
*   Ŀ
* ͵ DoBox                     ͻ
*   ͻ
*  Written    Unknown date (1990)                                           
*  Author     Robert Kratcoski                                              
*  Purpose    Draw various type of boxes                                    
*  Parameters nUpper      = Upper horizontal row                            
*             nLeft       = Left vertical column                            
*             nLower      = Lower horizontal row                            
*             nRight      = Right vertical row                              
*             cTitle_Area = N  No title, B  Box top title, T  Top line      
*                           title, and  W  Width bar (on top).              
*             cTitle      = Title of box to appear in title area if a title 
*                           is passed.                                      
*             expFrame    = Frame style number 1 - 26, or 9 character box   
*                          string.  If expFrame is character type but not 9 
*                          characters long, it will be padded with spaces.  
*             lZoom       = .T. For zoom out, .F. for no zoom               
*             lShadow     = .T. For shadow, .F. for no shadow               
*             cColor      = Color string for the box                        
*                          (current color if not specified)                 
*             cTitle_Clr  = Color string of the title area.  If not passed, 
*                           default is the inverse of the standard color.   
*             nSpeed      = Is an optional numeric value that controls the  
*                           speed the boxed is zoomed from the center.  The 
*                           larger the number, the slower the zoom.  This is
*                           useful when programming for computers with      
*                           different clock speeds. (15 - 50 is normal)     
*             cSubTitle   = Title that will appear on the bottom line of    
*                           the window.                                     
*             cSubTitle_Clr  = Color string for the sub title area.  If not 
*                          passed, the default is the inverse of the        
*                          standard color.                                  
*             cTitle_Just = Justification of the title.  L  Left, C  Center 
*                           and R  Right.  Default = "C"  Note:  Subtitles  
*                           (if any) will be justified as well.             
*  Returns    Savescreen() area before drawing the box.  The saved screen   
*             area will be one additional column on the right, and one      
*             aditional row on the bottom.  Remember to restore the screen  
*             with the addtional area on the bottom.                        
*  Calls      INVERSE_CLR(), MKESDW()                                       
*                                                                           
* ͼ
PRIV cOldClr, aBorders, cTitleLine, cSubLine, nLength, cReturn, cBoxString

cTitle_Area = IF(PCOUNT() < 5 .OR. TYPE("cTitle_Area") = [U],"N",cTitle_Area)
cTitle_Area = UPPER( IF(! UPPER(cTitle_Area) $ "NBTW","N",cTitle_Area) )
cTitle      = IF(PCOUNT() < 6 .OR. TYPE("cTitle") = [U] .OR. .NOT. cTitle_Area $ "BTW",[],cTitle)
expFrame    = IF(PCOUNT() < 7 .OR. TYPE("expFrame") = [U],1,expFrame)
lZoom       = IF(PCOUNT() < 8 .OR. TYPE("lZoom")<>[L],.F.,lZoom)
lShadow     = IF(PCOUNT() < 9 .OR. TYPE("lShadow")<>[L],.F.,lShadow)
cColor      = IF(TYPE("cColor")="U".OR. TYPE("cColor") <> "C" .OR. EMPTY(cColor),SETCOLOR(),cColor)
cTitle_Clr  = IF(TYPE("cTitle_Clr")="U".OR. TYPE("cTitle_Clr") <> "C" .OR. EMPTY(cTitle_Clr),INVERSE_CLR(cColor),cTitle_Clr)
nSpeed      = IF(TYPE("nSpeed")<>"N",15,nSpeed)
cSubTitle   = IF(TYPE("cSubTitle")<>"C",NIL,cSubTitle)
// cSubClr     = IF(TYPE("cSubTitle_Clr")="U".OR. TYPE("cSubTitle_Clr") <> "C" .OR. EMPTY(cSubTitle_Clr),INVERSE_CLR(cColor),cSubTitle_Clr)
cTitle_Just = IF(TYPE("cTitle_Just")="U".OR. TYPE("cTitle_Just") <> "C" .OR. EMPTY(cTitle_Just),"C",cTitle_Just)
cTitle_Just = IF(! cTitle_Just $ "LCR","C",cTitle_Just)
IF TYPE("expFrame") = "N"
   //            T R B L
   aBorders = {"Ŀ ", ; //  1  Single line box.
               "ͻȺ ", ; //  2  Double line box.
               "͸Գ ", ; //  3  Double line NORTH/SOUTH.  Single line EAST/WEST.
               "ķӺ ", ; //  4  Single line NORTH/SOUTH.  Double line EAST/WEST.
               " ", ; //  5  Full bold NORTH, Half bold EAST/WEST.
               " ", ; //  6  Half bold box, all sides.
               " ", ; //  7  Heavy texture box.
               " ", ; //  8  Medium texture box.
               " ", ; //  9  Light texture box.
               "͸ ", ; // 10  Single line box, double NORTH.
               "ķ ", ; // 11  Single line box, double EAST.
               "ĿԳ ", ; // 12  Single line box, double SOUTH.
               "ĿӺ ", ; // 13  Single line box, double WEST.
               "ķȺ ", ; // 14  Double line box, single NORTH.
               "͸Ⱥ ", ; // 15  Double line box, single EAST.
               "ͻӺ ", ; // 16  Double line box, single SOUTH.
               "ͻԳ ", ; // 17  Double line box, single WEST.
               "ͻ ", ; // 18  Double NORTH-EAST / Single SOUTH-WEST.
               "ķԳ ", ; // 19  Double SOUTH-EAST / Single NORTH-WEST.
               "ĿȺ ", ; // 20  Double SOUTH-WEST / Single NORTH-EAST.
               "͸Ӻ ", ; // 21  Double NORTH-WEST / Single SOUTH-EAST.
               "³ ", ; // 22  Single line attached to single line above. ͻ
               "˺Ⱥ ", ; // 23  Double line attached to double line above.  Good for pulldown menu boxes attached 
               "ѳ ", ; // 24  Single line attached to double line above.  to a single or double line above.     
               "ҺȺ ", ; // 25  Double line attached to single line above. Ľ
               "         "}   // 26  Blank box.
ENDIF

cOldClr    = SETCOLOR()
cReturn    = SAVESCREEN(nUpper,nLeft,nLower+1,nRight+1)
cBoxString = IF( TYPE("expFrame")="N",aBorders[expFrame],PADR(TRANS(expFrame,'XXXXXXXXX'),9) )
SETCOLOR("&cColor")

IF lZoom
    PRIV nCntrRow, nCntrCol, nRowExp, nColExp, nUpperRow, nLeftCol, nLowerRow, nRightCol
    PRIV lUpperDone, lLowerDone, lLeftDone, lRightDone
    nCntrRow = INT(((nLower-nUpper)/2)+nUpper)    // Center row of box.
    nCntrCol = INT(((nRight-nLeft)/2)+nLeft)      // Center column of box.
    nRowExp  = (((nCntrRow+.5)-nUpper)/nSpeed)    // Expand row from center by nRowExp.
    nColExp  = (((nCntrCol+.5)-nLeft)/nSpeed)     // Expand column from center by nColExp.
    STORE nCntrRow TO nUpperRow, nLowerRow
    STORE nCntrCol TO nLeftCol, nRightCol
    STORE .F. TO lUpperDone, lLowerDone, lLeftDone, lRightDone
    DO WHILE .NOT. (lUpperDone .AND. lLowerDone .AND. lLeftDone .AND. lRightDone)
       IF (nUpperRow-nRowExp) > nUpper
         nUpperRow = nUpperRow - nRowExp
       ELSE
         nUpperRow = nUpper
         lUpperDone = .T.
      ENDIF
      IF (nLeftCol-nColExp) > nLeft
         nLeftCol  = nLeftCol - nColExp
      ELSE
         nLeftCol = nLeft
         lLeftDone = .T.
      ENDIF
      IF (nLowerRow+nRowExp) < nLower
         nLowerRow = nLowerRow + nRowExp
      ELSE
         nLowerRow = nLower
         lLowerDone = .T.
      ENDIF
      IF (nRightCol+nColExp) < nRight
         nRightCol = nRightCol + nColExp
      ELSE
         nRightCol = nRight
         lRightDone = .T.
      ENDIF
      @ nUpperRow,nLeftCol CLEAR TO nLowerRow,nRightCol
      IF ( TYPE("expFrame") = "N" .AND. expFrame <> 26 ) .OR.;
       ( TYPE("expFrame") = "C" .AND. .NOT. EMPTY(cBoxString) )
         @ nUpperRow,nLeftCol TO nLowerRow,nRightCol
      ENDIF
   ENDDO
ENDIF

@ nUpper,nLeft,nLower,nRight BOX "&cBoxString"

DO CASE
CASE cTitle_Area = "B"      // Box type title.
   cTitleLine = SUBS(cBoxString,2,1) //SUBS("߰ ",AT(SUBS(cBoxString,2,1),"߰ "),1 )
   DO CASE
   CASE cTitleLine = ""
      @ nUpper+2,nLeft  SAY IF( SUBS(cBoxString,8,1)=="","","" )
      @ nUpper+2,nRight SAY IF( SUBS(cBoxString,4,1)=="","","" )
   CASE cTitleLine = ""
      @ nUpper+2,nLeft  SAY IF( SUBS(cBoxString,8,1)=="","","" )
      @ nUpper+2,nRight SAY IF( SUBS(cBoxString,4,1)=="","","" )
   CASE cTitleLine = ""
      cTitleLine = ""  // Just looks better.
   OTHERWISE
      @ nUpper+2,nLeft  SAY cTitleLine;  @ nUpper+2,nRight SAY cTitleLine
   ENDCASE
   nLength = IF( !(SUBS(cBoxString,1,1)$"۰") .OR. SUBS(cBoxString,2,1)="",;
    ((nRight-1)-(nLeft+2)),((nRight+1)-(nLeft+2)) )   // Length of title bar.
   @ INT(nUpper)+2,INT(nLeft)+1 SAY REPL( cTitleLine,(nRight-(nLeft+1)) )
   IF .NOT. EMPTY(cTitle)
      PRIV cPAD
      cPAD = IF( cTitle_Just=="C","PADC",IF(cTitle_Just=="R","PADL","PADR") )
      @ nUpper+1,nLeft+IF( SUBS(cBoxString,1,1)$"۰" .AND. SUBS(cBoxString,2,1)<>"",1,2) ;
      SAY IF( LEN(ALLTRIM(cTitle)) > nLength,;
      &cPAD.( SUBS(cTitle,1,nLength),nLength),;
      &cPAD.(cTitle,nLength) )        COLOR("&cTitle_Clr")
   ENDIF
CASE cTitle_Area = "T"              // Top Line title.
   nLength = LEN(cTitle)            // Length of title.
   IF nLength >= (nRight-1)-(nLeft+2)
      IF SUBS(cBoxString,2,1) $ ""
         @ nUpper,nLeft+1  SAY IF( SUBS(cBoxString,2,1)=="","","" )
         @ nUpper,nRight-1 SAY IF( SUBS(cBoxString,2,1)=="","","" )
      ENDIF
      @ nUpper,nLeft+2  SAY SUBS( cTitle,1,(nRight-1)-(nLeft+2) )  COLOR("&cTitle_Clr")
   ELSEIF nLength > 0
      IF SUBS(cBoxString,2,1) $ ""
         IF cTitle_Just == "C"
            @ nUpper,nLeft+((nRight+1-nLeft)/2)-(nLength/2)-1 SAY IF( SUBS(cBoxString,2,1)=="","","" )
            @ nUpper,nLeft+((nRight+1-nLeft)/2)-(nLength/2)+nLength SAY IF( SUBS(cBoxString,2,1)=="","","" )
         ELSEIF cTitle_Just == "L"
            @ nUpper,nLeft+1 SAY IF( SUBS(cBoxString,2,1)=="","","" )
            @ nUpper,nLeft+1+nLength+1 SAY IF( SUBS(cBoxString,2,1)=="","","" )
         ELSEIF cTitle_Just == "R"
            @ nUpper,nRight-1-nLength-1 SAY IF( SUBS(cBoxString,2,1)=="","","" )
            @ nUpper,nRight-1           SAY IF( SUBS(cBoxString,2,1)=="","","" )
         ENDIF
      ENDIF
      IF cTitle_Just == "C"
         @ nUpper,nLeft+((nRight+1-nLeft)/2)-(nLength/2) SAY PADC(cTitle,nLength) COLOR("&cTitle_Clr")
      ELSEIF cTitle_Just == "L"
         @ nUpper,nLeft+2 SAY PADR(cTitle,nLength) COLOR("&cTitle_Clr")
      ELSEIF cTitle_Just == "R"
         @ nUpper,nRight-1-nLength SAY PADL(cTitle,nLength) COLOR("&cTitle_Clr")
      ENDIF
   ENDIF
CASE cTitle_Area = "W"      // Width Bar title.
   nLength = LEN(cTitle)
   IF nLength >= (nRight-1)-(nLeft+2)
      @ nUpper,nLeft SAY PADC( SUBS(cTitle,1,(nRight-1)-nLeft),(nRight+1-nLeft) ) COLOR("&cTitle_Clr")
   ELSE
      IF cTitle_Just == "C"
         @ nUpper,nLeft SAY PADC(cTitle,(nRight+1)-nLeft) COLOR("&cTitle_Clr")
      ELSEIF cTitle_Just == "L"
         @ nUpper,nLeft SAY PADR(cTitle,(nRight+1)-nLeft) COLOR("&cTitle_Clr")
      ELSEIF cTitle_Just == "R"
         @ nUpper,nLeft SAY PADL(cTitle,(nRight+1)-nLeft) COLOR("&cTitle_Clr")
      ENDIF
   ENDIF
ENDCASE

IF cSubTitle <> NIL
   nLength = LEN(cSubTitle)
   IF cTitle_Area <> "W"
      cSubLine = SUBS(cBoxString,6,1)
      IF nLength >= (nRight-1)-(nLeft+2)
         IF cSubLine $ ""
            @ nLower,nLeft+1  SAY IF( cSubLine=="","","" )
            @ nLower,nRight-1 SAY IF( cSubLine=="","","" )
         ENDIF
         @ nLower,nLeft+2 SAY SUBS( cSubTitle,1,(nRight-1)-(nLeft+2) )  COLOR("&cSubTitle_Clr")
      ELSE
         IF cSubLine $ ""
            IF cTitle_Just == "C"
               @ nLower,nLeft+((nRight+1-nLeft)/2)-(nLength/2)-1       SAY IF( cSubLine=="","","" )
               @ nLower,nLeft+((nRight+1-nLeft)/2)-(nLength/2)+nLength SAY IF( cSubLine=="","","" )
            ELSEIF cTitle_Just == "L"
               @ nLower,nLeft+1 SAY IF( cSubLine=="","","" )
               @ nLower,nLeft+1+nLength+1 SAY IF( cSubLine=="","","" )
            ELSEIF cTitle_Just == "R"
               @ nLower,nRight-1-nLength-1 SAY IF( cSubLine=="","","" )
               @ nLower,nRight-1           SAY IF( cSubLine=="","","" )
            ENDIF
         ENDIF
         IF cTitle_Just == "C"
            @ nLower,nLeft+((nRight+1-nLeft)/2)-(nLength/2) SAY PADC(cSubTitle,nLength) COLOR("&cSubTitle_Clr")
         ELSEIF cTitle_Just == "L"
            @ nLower,nLeft+2 SAY cSubTitle COLOR("&cSubTitle_Clr")
         ELSEIF cTitle_Just == "R"
            @ nLower,nRight-nLength-1 SAY cSubTitle COLOR("&cSubTitle_Clr")
         ENDIF
      ENDIF
   ELSE
      IF nLength >= (nRight-1)-(nLeft+2)
         @ nLower,nLeft SAY PADC( SUBS(cSubTitle,1,(nRight-1)-nLeft),(nRight+1-nLeft) ) COLOR("&cSubTitle_Clr")
      ELSE
         IF cTitle_Just == "C"
            @ nLower,nLeft SAY PADC(cSubTitle,(nRight+1)-nLeft) COLOR("&cSubTitle_Clr")
         ELSEIF cTitle_Just == "L"
            @ nLower,nLeft SAY PADR(cSubTitle,(nRight+1)-nLeft) COLOR("&cSubTitle_Clr")
         ELSEIF cTitle_Just == "R"
            @ nLower,nLeft SAY PADL(cSubTitle,(nRight+1)-nLeft) COLOR("&cSubTitle_Clr")
         ENDIF
      ENDIF
   ENDIF
ENDIF

IF lShadow
   MKESDW(nUpper,nLeft,nLower,nRight)
ENDIF

SETCOLOR(cOldClr)
RETURN (cReturn)

*   Ŀ
* ͵ Update History ͻ
*   ͻ
*   d 07/92  n Robert Kratcoski c Added Top Line and Width Bar type titles.  
*                                 Also added speed control to the exlplode   
*                                 effect.  Made box return the savescreen    
*                                 coordinates of the area it is painted.     
*   d 08/92  n Robert Kratcoski c Added a Bold type frame style.             
*   d 12/92  n Robert Kratcoski c Changed frame to include 26 different      
*                                 styles of predefined box frames.  Also,    
*                                 allowed the FRAME parameter accept a nine  
*                                 character box string.                      
*                               c Changed all variables names to adhere to   
*                                 the standard naming conventions.           
*                               c Added the cSUBTITLE and cSUBTITLE_CLR      
*                                 parameters.                                
*   d 01/93  n Robert Kratcoski c Added justification to the titles and      
*                                 subtitles.                                 
* ͼ

***************************************
FUNC MKESDW( nTop, nLeft, nBottom, nRight )
***************************************
*   Ŀ
* ͵ MKESDW                    ͻ
*   ͻ
*  Written    Unknown Date                                                  
*  Author     Nantuckett (Clipper 5.01)                                     
*  Purpose    Place shadow underneath and to the right of a box             
*  Parameters nTop, nLeft, nBottom, nRight = Coordinates of the             
*             box area.                                                     
*  Returns    Nothing                                                       
*  Comments   Give same coordinates of the drawn box.  Shadow is drawn one  
*             row underneath and one column on the right                    
* ͼ
PRIV nShadTop, nShadLeft, nShadBottom, nShadRight

nShadBottom = MIN(nBOTTOM + 1, MAXROW())
nShadTop   = nShadBottom
nShadLeft  = nLeft + 1
nShadRight = MIN(nRight + 1, MAXCOL())

RESTSCREEN( nShadTop, nShadLeft, nShadBottom, nShadRight,;
   TRANSFORM( SAVESCREEN(nShadTop, nShadLeft, nShadBottom, nShadRight),;
   REPLICATE("X", nShadRight - nShadLeft + 1 ) ) )

nShadTop    = nTOP + 1
nShadRight  = MIN(nRight + 1, MAXCOL())
nShadLeft   = nShadRight
nShadBottom = nBOTTOM

RESTSCREEN( nShadTop, nShadLeft, nShadBottom, nShadRight,;
   TRANSFORM( SAVESCREEN(nShadTop,  nShadLeft , nShadBottom, nShadRight),;
   REPLICATE("X", nShadBottom - nShadTop + 1 ) ) )

RETURN NIL
