/*Ŀ
 ݳ Program Name: SCREENS.PRG       Copyright: Gallagher Computing Corp. 
 ݳ     Language: Clipper 5.2          Author: Kevin S Gallagher         
 
            */

#include "include1.h"

procedure MainScrn()
    dispbox(0,0,maxrow()-2,maxcol(),B_DOUBLE+" ",BACKCOLOR)
    Center(3,"ClipBoot version 1.00",HICOLOR)
    Center(4,"Created by Kevin S. Gallagher",DISPCOLOR)
    @5,27 say "Current Config: "                        color HICOLOR

    if !empty( getenv("QBOOTCON") )
        @5,col() say getenv("QBOOTCON")                 color ENCHCOLOR
    else
        @5,col() say "Not available"                    color ENCHCOLOR
    endif

    @maxrow()-1,0 say ;
    " Ins-Create   Del-Delete  F3-Environ Editor   "+;
    "F10-BOOT   Esc-Abort   Enter-Edit "                color "gr+/n"

    @maxrow(),0 say replicate(" ",80)                   color BACKCOLOR
return

/*
* Function..: GetYN() --> logical
* Purpose...: Use to get either a [Y]es or [N]o response for a question
* Returns...: .T. = User pressed Y
*           : .F. = User pressed N
* Comment...: Response is not echoed to the console
*/
function GetYN
    local oldcur := setcursor(3)
    while ! upper( chr( inkey(0) ) ) $ "YN" ; enddo
    setcursor( oldcur )
return ( upper(chr(lastkey())) == "Y" )

/*
* Procedure.: AbortOp() --> nil  
* Purpose...: Use to terminate the program when an error occurs
*           : Set errorlevel to 3 for check errorlevel from DOS
*           : This is similar to MS-C ABORT() function
* Returns...: NIL
*/
procedure AbortOp( cMsg )
    cMsg := if( valtype( cMsg ) == "C", cMsg,"")
    errorlevel(3)
    setcolor(DOSCOLOR)
    cls
    QOut("Abnormal program termination... "+cMsg)
    quit
return

/*
* Procedure.: ExitToDos() --> nil
* Purpose...: Use to terminate w/o errors
* Returns...: NIL
*/
procedure ExitToDos()
    setcolor(DOSCOLOR)
    cls
    @0,0 say "ClipBoot by: Kevin S. Gallagher" color DOSCOLOR
    quit
return


/*
* Function..: ALongest() --> Numeric
* Purpose...: Find the longest string in a string array
* Returns...: the length of the longest array element 
*           : or -1 if the passed var was not an array
*/
function ALongest( aArr_ )
    local nSize := -1
    if valtype( aArr_ ) == "A"
        nSize := len( aArr_[1] )
        aeval( aArr_, { | a | nSize := if(len(a) > nSize, len(a), nSize ) } )
    endif
return nSize

/*
* Function..: AScanner() --> numeric
* Purpose...: case insensitive ascan()
* Returns...: returns a numeric between 0-255
*/
function AScanner( aArr_, xValue )
    local xRetVal := ascan( aArr_, { | a | if( ISCHAR( a ), ;
                     upper( subs( a ,1,1) ) = upper( xValue ), .F. ) }, 1 )
return xRetVal

/*
* Function..: WaitKeys() --> numeric
* Purpose...: makes inkey() into a wait state
* Returns...: returns a numeric inkey value
*/
function WaitKeys( nSecs )
    local nKey, bBlock
    nKey := inkey( nSecs )
    if ( bBlock := setkey(nKey) ) !=NIL
        eval( bBlock, procname(2), procline(2) )
    endif
return ( nKey )


