* EXPIRE.PRG, placed in the Public Domain by Ian Thurston
*This program demonstrates EXPIRY(), a UDF for SUMMER '87
*It checks the tail of its EXE for a date stamp
*If found, it returns the stamp
*If not found, it adds a stamp 2 weeks from the date of the run
*Inspired by Steve Strahley's Advanced Clipper Programming with C

CLEAR
SETCOLOR("N/W,W+/N,W")
SCROLL(10,10,17,70,0)
@ 12,20 SAY "Checking expiry date for EXPIRE.EXE"
firstdate = expiry("EXPIRE.EXE")
@ 13,20 SAY "Software expires on "+dtoc(firstdate+13)
IF DATE() < firstdate
    @ 14, 20 SAY "Hmmm ... maybe a time warp ???"
ELSE
    @ 14,20 SAY "Days remaining:"
    @ 14, col()+2 SAY firstdate - date() + 13
ENDIF
@ 16,20 say "Press any key to exit"
INKEY(0)

* "Cut on the dotted line ... everything below is reusable code"
*........................................................................*
********
FUNCTION expiry
********
PARAMETERS filespec
PRIVATE handle, rval
IF PCOUNT() < 1                         && Check for required parameter
    ? CHR(7) + "Usage is: EXPIRY( <expC>). You omitted <expC>."
    QUIT
ENDIF

IF !FILE(filespec)                      && Check for file existence
    ? CHR(7) + "File not found !!!"
    QUIT
ENDIF
rval = getexpiry(filespec)
if EMPTY(rval)
    handle=FOPEN(filespec,1)                && Attempt to open for writing
    FSEEK(handle, 0,2)                      && postition to EOF()
    FWRITE(handle, "IMTS" + DESCEND(dtoc(date())))
    IF FERROR() > 0
        ? CHR(7)
    ENDIF
    FCLOSE(handle)
    rval = getexpiry( filespec)
ENDIF
RELEASE handle
RETURN rval

********
FUNCTION getexpiry
********
PARAMETERS filespec
PRIVATE handle, rval
IF PCOUNT() < 1                         && minor bulletproofing
    ?? chr(7)
    RETURN "Getexpiry Error ! You must specify a file"
ENDIF
handle=FOPEN(filespec,0)                && try to open the file
IF handle < 0                           &&
    rval="No limit"
ELSE
    FSEEK(handle, -12 ,2)     && to EOF()
    rval = SPACE(12)
    FREAD(handle, @rval, 12)
    IF FERROR() = 0
        IF LEFT(rval,4) != "IMTS"
            rval =("  /  /  ")
        ELSE
            rval =DESCEND(right(rval,8))
        ENDIF
    ELSE
        ?
        ? "Program file is damaged. Please retry with a new copy."
        ? "Ending program run now."
        CLEAR ALL
        QUIT
    ENDIF
    FCLOSE(handle)
ENDIF
RETURN ctod(rval)

