 /*
   CLDIR.PRG
   
   Author     : Phil Barnett
   
   Written    : 09/04/92
   
   Function   : This is an example of using Clipper as a nearly complete 
                substitute for the DOS dir command. I doubt anyone would 
                want to use this instead of DOS, but it does show how to 
                use clipper to format and present directory information.
   
   Purpose    : Learning example.
   
   Parameters : [FILESPEC]  [/P]
   
                [FILESPEC] is the file or file mask you wish to 
                have a directory of
                
                [/P] is a flag that will cause only 24 lines to show
                at a time and wait for a keypress to continue.
   
   Returns    : NIL
   
   Example    : CLDIR( "*.*", "/P" )
  
   Compile    : CLIPPER CLDIR /N
  
   Link       : RTLINK FI CLDIR
  
   Syntax     : CLDIR filespec [/P]
  
   Released to Public Domain by Author.
  
 */

#xcommand DEFAULT <foo> TO <bar> => ;
          IF <foo> == NIL ; <foo> := <bar> ; ENDIF

FUNCTION cldir( parm1, parm2 )

LOCAL f_list:={}, num_hits, X, dotat, this_name, this_date, this_time, volable
LOCAL f_path := SPACE(60)
LOCAL f_drive := SPACE(1)
LOCAL f_spec := SPACE(12)
LOCAL getlist := {}

DEFAULT PARM2 to ""

parm2 := UPPER(parm2)

IF parm1 = nil
   CLEAR
   
   @ 10,5 SAY "Enter the Drive" GET f_drive PICTURE "!"
   @ 12,5 SAY " Enter the Path" GET f_path  PICTURE "@!"
   @ 14,5 SAY "      File Spec" GET f_spec  PICTURE "@!"
   
   READ
   
   CLEAR
   
   IF LASTKEY() = 27
      RETURN nil
   ENDIF
   
   f_path := ALLTRIM(f_path)
   
   IF LEFT(f_path,1) <> "\"
      f_path := "\"+f_path
   ENDIF
   
   IF RIGHT(f_path,1) <> "\"
      f_path += "\"
   ENDIF
   
   IF EMPTY(f_spec)
      f_spec := "*.*"
   ENDIF
   
   volable := Directory(f_drive+":\","V")
   
   f_list := Directory(f_drive+":"+f_path+f_spec,"D")
   
ELSE
   
   parm1 := UPPER(parm1)
   
   IF LEFT(parm1,1) = "\"
      f_drive := curdrive()
      parm1 := f_drive + parm1
   else
      f_drive := LEFT(parm1,1)
   ENDIF
   
   
   volable := Directory(f_drive+":\","V")
   
   f_list := Directory(parm1,"D")
   IF LEN(f_list) == 1 .AND. "D"$f_list[1,5]
      f_list := Directory(parm1+"\*.*","D")
   ENDIF
   
   colat := AT(":",parm1)
   IF !EMPTY(colat)
      parm1 := SUBSTR(parm1,colat+1)
   ENDIF
   
   slat := Rat("\",parm1)
   IF !EMPTY(slat)
      f_path := LEFT(parm1,slat)
   ELSE
      f_path := parm1+"\"
   ENDIF
   
ENDIF


num_hits := LEN(f_list)

? " Volume in drive "+f_drive+" is "+volable[1,1]
? " Directory of "+f_drive+":"+LEFT(f_path,LEN(f_path)-1)
?

SET DATE TO usa

FOR X := 1 TO num_hits
   this_name := f_list[x,1]
   dotat := AT(".",this_name)
   IF dotat > 1 .AND. !".."$THIS_NAME
      this_name := STUFF(this_name,dotat,1,SPACE(13-LEN(this_name)))
   ENDIF
   this_date := DTOC(f_list[x,3])
   IF LEFT(this_date,1) == "0"
      this_date := " "+SUBSTR(this_date,2)
   ENDIF
   this_time := Ampm(LEFT(f_list[x,4],5))
   IF LEFT(this_time,1) == "0"
      this_time := " "+SUBSTR(this_time,2)
   ENDIF
   this_time := LEFT(this_time,5)+SUBSTR(this_time,7,1)
   IF "D" $ f_list[x,5]
      bytecount := " <DIR>   "
   ELSE
      bytecount := STR(f_list[x,2],9)
   ENDIF
   ? PAD(this_name,12)+bytecount +" "+this_date +" "+this_time
   IF "/P" $ parm2
      IF (X+4)%23 = 0
         mrow := ROW()
         mcol := COL()
         pre_wait := Savescreen(24,0,24,79)
         WAIT
         Restscreen(24,0,24,79,pre_wait)
         @ mrow,mcol SAY ""
      ENDIF
   ENDIF
NEXT
? STR(num_hits,9)+" File(s)"+STR(Diskspace(ASC(f_drive)-64),10) + " bytes free"
?

RETURN nil
*: EOF: CLDIR.PRG
