/*
    MenuBar.prg

    Copyright (c) 1991 Chris Muller
*/


#include "class(y).ch"
#include "gen.ch"
#include "win.ch"


create class MenuBar from BaseMenu
        instvar itemCol

    export:
        method  draw
        method  addItem
        method  newMenuPos
endclass

constructor (Items), (Items)
return

procedure method additem(text, oAction)

    ::super:addItem(text, oAction)

    if ::itemCol == NIL
        ::itemCol := { 0 }
    end
    aAdd(::itemCol, ::itemCol[len(::itemCol)] + len(text) + 4)
return

procedure method draw
    local i, column := 0

    winCurrent(0)
    @ 0, 0

    for i := 1 to len(::Items)
        @ 0, column prompt ::items[i]:text
        column += len(::items[i]:text) + 4
    next i

return

function method newMenuPos
return ::itemCol[::curPos]

