/*
    BaseMenu.prg

    Copyright (c) 1991 Chris Muller
*/

#include "class(y).ch"
#include "gen.ch"

create class baseMenu

    protected:
        instvar items
        instvar curPos
        instvar parent

    export:
        method  addItem
        method  draw        null      // subclasses must implement these.
        method  setKeys     null
        method  clearKeys   null
        method  newMenuPos
        method  exec
endclass

constructor (Items)
    local i
    ::items  := {}
    ::curpos := 1

    if Items != NIL
        for i := 1 to len(Items)
            ::addItem(Items[i,1], Items[i,2])
        next
    end
return

procedure method addItem(text, oAction)
    aAdd(::items, menuItem():new(text, oAction))
    oAction:parent := self
return

procedure method exec()
    local curpos, finished := .f.

    while !finished
        ::draw()

        curpos := ::curpos
        ::setKeys()
        menu to curpos
        ::clearKeys()
        ::curpos := curpos

        finished := (::curpos == 0)

        if !finished
            ::items[::curpos]:exec()
        end
    end
return

function newMenuPos
return ::curPos
