/*
    htbox.prg

    21/03/1991 21:36 avs - updated

    Companion program to HERITEST.PRG.
*/

#include "class(y).ch"


create class Box from Rectangle
    instvar boxChars
    instvar frameColor
    instvar paneColor

protected:
    instvar boxType

export:
    classvar nBoxes

    method    draw
    method    test

endclass


constructor (nTop, nLeft, nBottom, nRight, cFrame, cFrameColor, cPaneColor), ;
    (nTop, nLeft, nBottom, nRight)

    ::boxChars     := cFrame
    ::frameColor := cFrameColor
    ::paneColor  := cPaneColor

    ::draw()
return


procedure method draw
    setcolor(::frameColor)
    @ ::top, ::left, ::bottom, ::right box ::boxChars
    setcolor(::paneColor)
    @ ::top + 1, ::left + 1 clear to ::bottom - 1, ::right - 1
return


procedure method test
    ? 'box:test'
return


// eof htbox.prg
