/*
    cyfile.prg

    Copyright (c) 1991 Anton van Straaten

    13/02/1991 20:56 avs - creation

    A simple encapsulation of the Clipper low-level file i/o functions.
    Limited, but serves as an example of how easily a well-designed
    procedural system can be encapsulated in an object-oriented shell.

    Note that the name 'File' cannot be used for this class because of
    the Clipper function FILE().
*/

#include "class(y).ch"


create class DosFile

export:
    instvar handle  noassign
    instvar name    noassign

    method open
    method close
    method create
    method read, readstr
    method write

    class method error
    class method erase
    class method exists

endclass


constructor (cFileName)
    ::name := cFileName
return

function method open(nMode)
return (::handle := fopen(::name, nMode))

function method close
return fclose(::handle)

function method create(nAttribute)
return ::handle := fcreate(::name, nAttribute)

function method read(buf, nBytes)
return fread(::handle, @buf, nBytes)

function method readstr(nBytes)
return freadstr(::handle, nBytes)

function method write(buf, nBytes)
return fwrite(::handle, buf, nBytes)

function method error
return ferror()

function method erase(cFile)
return ferase(cFile)

function method exists(cFile)
return file(cFile)


// eof cyfile.prg
