// CLASSic Demo Class
// By John D. Van Etten
// Written in CLASSic

// Item Class
#include "Classic.ch"

// Written in Class(y) style
Create Class oMenuItem

  Method Init Constructor

  Export:
    Var MenuBlock    Type Block        // b, Run this codeblock if item is picked
    Var Text         Type Char         // c, A string with the menu option
    Var Color        Type Char         // c, The color of the choice
    Var HotPos       Type Numeric      // n, The char position of the hot key
    Var Message      Type Char         // c, The message
    Var MsgColor     Type Char         // c, The message color
    Var MsgRow       Type Numeric      // n, The row of the message
    Var MsgCol       Type Numeric      // n, The col of the message
    Var MsgLine      Type Numeric      // n, Same as Clipper's SET MESSAGE
    Var ClsMsgLine   Type Logical      // l, Clear the whole message line?
    Var MsgCenter    Type Logical      // l, Same as Clipper's SET MESSAGE CENTER
    Var HasFocus     Type Logical      // l, Is this item highlighted
    Var AutoRestore  Type Logical      // l, Close the box when item is picked?
    Var Enabled      Type Logical      // l, Is item enabled?
    Var Cargo                          //    Whatever you want!
    Var Row          READONLY          // n, The row of the menu option
    Var Col          READONLY          // n, The col of the menu option

    Method ItemDisplay Message Display // Draws the item
    Method SetFocus                    // Sets the focus to this item
    Method KillFocus                   // De-highlights the item
    Method Configure                   // Re-evaluate Color String

  // Should be local, but I need access to them from oMENU.PRG
    Var oMenu        Type Object       // o, What menu owns the item
    Var SetRow       Type Numeric      // n, The set row of the item
    Var SetCol       Type Numeric      // n, The set col of the item

  Hidden:
    Var aRestMsg                       // Saved screen under the Message

    Var cOnColor                       // The hilighted color
    Var cOffColor                      // The un-hilighted color
    Var cOnKeyColor                    // The hot-key color
    Var cOffKeyColor                   // The hot-key color
    Var cDisColor                      // The Disabled option color
    Method GetKeyColor                 // Get the hot-key color
    Method GetColor                    // Breaks up the color string

End Class

Method Init( oMenu, nRow, nCol, cChoice, nHotPos, cMsg, bMenuBlock, ;
                    cColor, cMsgColor )
  ::oMenu       := oMenu
  ::SetRow      := nRow
  ::SetCol      := nCol
  ::Text        := cChoice
  ::HotPos      := nHotPos
  ::Message     := cMsg
  ::MenuBlock   := bMenuBlock
  ::Color       := cColor
  ::MsgColor    := cMsgColor
  ::HasFocus    := .f.
  ::AutoRestore := .f.
  ::Enabled     := .t.

Return( Self )

Method SetFocus()
  Local nCount
  Local aItems := ::oMenu:Items
  Local xItem
  Local nCursor := SetCursor( 0 )

  If ::Enabled
    DispBegin()

    For nCount := 1 to len( aItems )
      If valtype( xItem := aItems[ nCount ] ) == "O" .and. !xItem == Self
        if xItem:HasFocus
          xItem:KillFocus()
          exit
        endif
      Endif
    Next

    ::HasFocus := .t.
    ::Display()

    DispEnd()
  Endif
  SetCursor( nCursor )
Return( Self )

Method ItemDisplay( nRow := ::Row, ;
                    nCol := ::Col )
  Local cKey
  Local nCursor     := SetCursor( 0 )
  Local nHotPos     := ::HotPos
  Local nMsgRow     := ::MsgRow
  Local nMsgCol     := ::MsgCol
  Local cMessage    := ::Message
  Local cMsgColor   := ::MsgColor
  Local aRest       := ::aRestMsg
  Local lClsMsgLine := ::ClsMsgLine
  Local lMsgCenter  := ::MsgCenter
  Local nMsgLine    := ::MsgLine
  Local cColor      := iif( ::Enabled, ;
                            iif( ::HasFocus, ::cOnColor, ::cOffColor ),;
                            ::cDisColor )

  ::Row := nRow
  ::Col := nCol

  DispBegin()
  If ::oMenu:InBox
    @nRow, nCol Say " " + Padr( ::Text, ::oMenu:Width - 1 ) ;
                Color cColor
  else
    @nRow, nCol Say ::Text ;
                Color cColor
  Endif

  if full( ::HotPos )
    cKey := Substr( ::Text, ::HotPos, 1 )
  else
    cKey := Left( lTrim( ::Text ), 1 )
    nHotPos := At( cKey, ::Text )
  endif

  If Full( cKey )
    @ nRow, nCol + nHotPos Say cKey ;
                           Color iif( ::HasFocus, ::cOnKeyColor, ::cOffKeyColor )
  else
    cKey := ""
  Endif

  if full( aRest )
    RestScreen( aRest[ 1 ], aRest[ 2 ], aRest[ 3 ], aRest[ 4 ], aRest[ 5 ] )
    ::aRestMsg := NIL
  endif

  If cMessage != NIL .and. ::HasFocus
    Default nMsgLine to ::oMenu:MsgLine
    Default nMsgLine to SET( _SET_MESSAGE )
    Default lClsMsgLine to ::oMenu:ClsMsgLine
    Default lClsMsgLine to .f.
    Default lMsgCenter to ::oMenu:MsgCenter
    Default lMsgCenter to SET( _SET_MCENTER )
    Default nMsgRow to nMsgLine

    If lMsgCenter
      Default nMsgCol to int( maxcol() / 2 - len( cMessage ) / 2 )
    else
      Default nMsgCol to 0
    Endif
    Default cMsgColor to ::cOnColor

    If lClsMsgLine
      ::aRestMsg := { nMsgRow, 0, nMsgRow, MaxCol() + 1, ;
                      SaveScreen( nMsgRow, 0, nMsgRow, MaxCol() + 1 ) }
      @nMsgRow, 0 Say Space( MaxCol() + 1 ) Color cMsgColor
    else
      ::aRestMsg := { nMsgRow, nMsgCol, nMsgRow, nMsgCol + Len( cMessage ), ;
                      SaveScreen( nMsgRow, nMsgCol, nMsgRow, nMsgCol + Len( cMessage ) ) }
    Endif
    @nMsgRow, nMsgCol Say cMessage Color cMsgColor
  Endif

  DispEnd()
  SetCursor( nCursor )
Return( cKey )

Method KillFocus()
  ::HasFocus := .f.
  ::Display()
Return( Self )

Method GetKeyColor( lOn )
  Local cColor := ::Color
  Local cBack := IIF( ::Enabled, IIF( lOn, ::cOnColor, ::cOffColor ), ;
                      ::cDisColor )

  Default cColor to ::oMenu:Color

  cColor := ::GetColor( cColor, 4 )
  cColor := Left( cColor, at( "/", cColor )) + ;
            Substr( cBack, at( "/", cBack ) + 1 )
Return( cColor )

Method GetColor( cColor := ::oMenu:Color, nNum, lLoop )
  Local tNum := nNum
  Local nFind
  Local cColorPiece

  Do While tNum-- > 0
    nFind := At( ",", cColor )
    If nFind == 0
      Default lLoop to .t.
      If ( tNum > 0 .or. empty( cColor )) .and. lLoop
        cColor := ::GetColor( ::oMenu:Color, nNum, .f. )
        if empty( cColor )
          cColor := ::GetColor( ::oMenu:Color, nNum, .f. )
        endif
      endif
      tNum := 0
      cColorPiece := cColor
    elseIf tNum == 0
      cColorPiece := Left( cColor, nFind - 1 )
    else
      cColor := Substr( cColor, nFind + 1 )
    endif
  Enddo
Return( cColorPiece )

Method Configure()
  Local cColor := ::Color
  Default cColor to ::oMenu:Color

  ::cOffColor    := ::GetColor( cColor, 1 )
  ::cOnColor     := ::GetColor( cColor, 2 )
  ::cDisColor    := ::GetColor( cColor, 5 )
  ::cOnKeyColor  := ::GetKeyColor( .t. )
  ::cOffKeyColor := ::GetKeyColor( .f. )
Return( Self )
