*ISDIR(): A Clipper language function
*By Don Swanson
*
*Copyright (c) 1989 D. C. Swanson
*
*Some Clipper users have inquired about a method of checking to see if a 
*directory path exists. During the execution of a program a user may enter
*a non-existent path and generate a DOS error 3 (path not found). This, of
*course, is a critical error from which it is rather difficult to recover.
*Don L. Powells provided an assembly language function to check the path
*with an accompanying Clipper demonstration program.
*
*I have been using a CLIPPER function to do the same thing and thought there
*may be some interest by the other members of the Nantucket forum. This is my
*first attempt at doing anything but reading and downloading so bear with me 
*if it's not done right. I would be interested in any feedback.
*
*The theory behind the program is a trick I have been useing in my batch
*files for a long time. DOS will ALWAYS return TRUE on any test for the
*'NUL' device. Therefore, to test for drives, directories, etc. you need
*only append the string '\NUL' to any drive/directory string. Because 'NUL'
*always exists you are actually just testing for the Drive or Directory
*portion of the string.  Happy Clippering, isn't it a GREAT language?
*
*This routine can also be used to test to see if a drive exists and to
*test whether a floppy drive door is open or closed.  To do this, all 
*you have to do is to try to test if the root directory of that drive 
*exists.
*
*Example usages:
*
*  ISDIR("C:\")               && is drive C available?
*  ISDIR("A:\")               && is there a formatted floppy in A:?
*  ISDIR("C:\DATA")           && is there a directory called C:\DATA?
*
**************************************************************************
* Program Name: CisDir.prg *
* Author: Don Swanson      *
* Created: 10/13/89
*************************** ALL RIGHTS RESERVED **************************
* This program tests and demonstrates the ISDIR() Clipper language UDF.
* It uses a Clipper Function 'ISDIR()' by Don Swanson, 10/13/89.
*
Clear
Apath=space(64)
do while lastkey() != 27
   @ 0,0 CLEAR TO 22,79
   @ 1,0 SAY ""	&& POSITION THE CURSOR
   ? "                 Testing the isdir() Clipper function"
   ?
   ? "Press <ESC> to quit."
   @ 6,0 say "Enter a path:" 
   @ ROW(),COL()+1  get Apath picture "@k"
   read
   If LastKey() = 27
      LOOP
   EndIf
   Apath = trim(Apath)
   if isdir(Apath)
      @ 23,0
      @ 23,1 say Apath+" Directory exists!"
   else
      @ 23,0
      @ 23,1 say Apath+" Directory does not exist!"
   endif
   @ 24,0
   @ 24,1 say "Press any key to continue."
   inkey(0)
   Apath = Apath + space(64-len(Apath))
enddo
@ 24,00
return
******************************************************************
*Filename:	CisDir.PRG
*Purpose:	To check for a valid Drive or Directory path.
*Usage:		IsDir(expc)
*Returns:	Logical true if Drive/Path is valid, False if not.
*Notes:	This function expects a string containing a Drive letter
*	followed by a colon or a Directory path or both as shown
*	below. A trailing back-slash is optional.
*	[d:][\][dirname]
*
*Copyright (c) 1989 D. C. Swanson.
*
*Restrictions:	You may freely use this function in your programs
*		providing you leave this header attached so that
*		I am credited in your source code. Thank you.
******************************************************************
FUNCTION  IsDir		&& Copyright (c) 1989 D. C. Swanson.
PARAMETER Path
*
* Syntax: Rslt=ISDIR("C:\dos")
*
Private S, RetVal
S = IIF(Type("Path")="C",Upper(Trim(Path)),"")
RetVal = Len(S) > 0
IF RetVal			&& Caller Passed a string
   If Right(S,1) != "\"		&& Guarantee an existent file.
      S = S+"\NUL"		&& File 'nul' always exists in DOS
   ELSE				&& therefore we end up testing for
      S = S+"NUL"		&& the Drive or the Directory!
   EndIf
   RetVal = FILE(S)		&& Ask DOS if it's valid
EndIf
Return RetVal
* END Function IsDir
