*****
* CHECKPCX.PRG
* Demonstration of reading PCX file header information from Clipper 5.0
*
* 1/16/91
* By Peter M. Freese
* Pinnacle Publishing, Inc.
*
* NOTE:  compile with /n
*

proc checkpcx(cFname)
local nHandle := 0, cHeader := space(128), xmin, ymin, xmax, ymax

	if AT('.',cFname) = 0
		cFname := cFname + '.PCX'
	endif
	nHandle := FOPEN(cFname)

	if FERROR() != 0
		? 'Error opening file "',cFname,'", error: ',FERROR()
	else
		if FREAD(nHandle,@cHeader,128) <> 128
			? 'Error reading file header.'
		else
			xmin := BIN2I(SUBSTR(cHeader,5,2))
			ymin := BIN2I(SUBSTR(cHeader,7,2))
			xmax := BIN2I(SUBSTR(cHeader,9,2))
			ymax := BIN2I(SUBSTR(cHeader,11,2))
			? 'Image file: ',cFname
			? TRANSFORM(xmin,'(999,')
			?? TRANSFORM(ymin,'999)-')
			?? TRANSFORM(xmax,'(999,')
			?? TRANSFORM(ymax,'999)')
			? TRANSFORM(xmax-xmin+1,'999x')
			?? TRANSFORM(ymax-ymin+1,'999')
			?
		endif
		FClose(nHandle)
	endif
return





