* CAPNDEMO.PRG

* CAPTAIN
* SOFTWARE LICENCE CONTROL SYSTEM

* DEMONSTRATION PROGRAM

clear

private menuitems[7]

menuitems[1] = 'Check if a System is Authorized'
menuitems[2] = 'Request Authorization of a System'
menuitems[3] = 'Show Contents of an Event Counter'
menuitems[4] = 'Reduce Event Counter by 1'
menuitems[5] = 'Request Authorization of More Events'
menuitems[6] = 'Write to an Event Counter'
menuitems[7] = 'Exit to DOS'

msystem = space(10)
mevent  = space(8)
mcnt    = 0
cdrive = ' '
mr = 12
mc = 41

keyson()

@ 1,0 to 24,79
set color to n/w
@ 2,1 say '            CAPTAIN  -  SOFTWARE LICENCE CONTROL   (Demonstration)            ' 
set color to
@ 3,1 to 13,38 double
@ 13,18 say chr(24)
@ 13,21 say chr(25)
@ 3,40 to 13,78 double

@ 14,1 to 23,78 double
@ 23,34  say 'PgUp'
@ 23,42  say 'PgDn'
mprg = memoread('capndemo.prg')                  && get this prg in
public prgrow
prgrow = 1
showprg2(prgrow)

mch = 1
do while .t.
   keysoff()
   mch = achoice(4,2,10,37,menuitems,,,mch)
   if mch = 0 .or. mch = 7
      exit
   endif
   keyson()

   if mch = 1
      mch1()
   elseif mch = 2
      mch2()
   elseif mch = 3
      mch3()
   elseif mch = 4
      mch4()
   elseif mch = 5
      mch5()
   elseif mch = 6
      mch6()
   endif
enddo   
@ 24,0 say chr(192)
quit

function mch1
   * check system
   scrollup(2)
   showprg(1)
   @ mr,mc say 'Enter System name : ' get msystem picture '@K XXXXXXXXXX'
   read                                                       
   if empty(msystem)
      return(.t.)
   endif

   showprg(1)
   cret = capnchek(msystem)            && see if already authorized
   if left(cret,1) = '9'               && can not access serialno.dbf
      showprg(-1)
      scrollup(1)
      @ mr,mc say 'Error accessing SERIALNO.DBF'
      scrollup(1)
      @ mr,mc say 'System NOT AUTHORIZED!'
   elseif left(cret,1) = '2'           && invalid date
      showprg(-1)
      scrollup(1)
      @ mr,mc say 'Invalid System Date'
      scrollup(1)
      @ mr,mc say 'System NOT AUTHORIZED!'
   elseif left(cret,1) = '4'           && back dating!
      showprg(-1)
      scrollup(1)
      @ mr,mc say 'Invalid System Date - Earlier than last use!'
      scrollup(1)
      @ mr,mc say 'System NOT AUTHORIZED!'
   elseif left(cret,1) = '0'           && all OK
      showprg(-1)
      cdrive = substr(cret,2,2)
      scrollup(1)
      @ mr,mc say 'System AUTHORIZED on drive '+cdrive
   elseif left(cret,1) = '3'           && authorization has expired
      showprg(-1)
      cdrive = substr(cret,2,2)
      scrollup(1)
      @ mr,mc say 'Software Authorization has expired!'
      scrollup(1)
      @ mr,mc say 'System NOT AUTHORIZED!'
   elseif left(cret,1) = '1'           && no registration found
      showprg(-1)
      scrollup(1)
      @ mr,mc say 'No Authorization found!'
      scrollup(1)
      @ mr,mc say 'System NOT AUTHORIZED!'
   endif
return(.t.)

function mch2
   scrollup(2)
   showprg(1)
   @ mr,mc say 'Enter Disk Drive  : ' get cdrive ;
                picture '@K!A X' valid(!(cdrive $ 'AB'))
   read                                                       
   if empty(cdrive)
      return(.t.)
   endif
   cdrive = substr(cdrive,1,1) + ':'
   scrollup(1)
   showprg(1)
   @ mr,mc say 'Enter System name : ' get msystem picture '@K XXXXXXXXXX'
   read                                                       
   if empty(msystem)
      return(.t.)
   endif

   cret = capnmake(msystem,cdrive)
   if cret = '6'
      showprg(-1)
      scrollup(1)
      @ mr,mc say 'Can not create CAPTAIN files on ' + cdrive + '!'
      return(.t.)
   elseif cret = '5'
      showprg(-1)
      scrollup(1)
      @ mr,mc say 'Invalid disk drive letter!'
      return(.t.)
   elseif left(cret,1) = '9'        && can not access serialno.dbf
      showprg(-1)
      scrollup(1)
      @ mr,mc say 'Error accessing SERIALNO.DBF'
      return(.t.)
   endif

   cseed = capnget(msystem)            && get seed number
   cauth = 0

   scrollup(1)
   showprg(1)
   @ mr,mc say 'Serial number is  : '
   @ mr,mc+20 say val(cseed) picture '999 999 999 999'
   scrollup(1)
   @ mr,mc say 'Enter Authorization Number : ' 
   scrollup(1)
   @ mr,mc+20 get cauth picture '999 999 999 999'
   read
   if lastkey() = 27
      return(.t.)
   endif
   cauth = str(cauth,12)
   showprg(1)
   cret = capntest(msystem,cdrive, cseed, cauth)
   if cret = '0'
      showprg(-1)
      scrollup(1)
      @ mr,mc say 'Authorization Complete!'
      return(.t.)
   elseif left(cret,1) = '9'           && can not access serialno.dbf
      showprg(-1)
      scrollup(1)
      @ mr,mc say 'Error accessing SERIALNO.DBF'
      return(.t.)
   endif
   scrollup(1)
   showprg(1)
   @ mr,mc say 'Invalid authorization!'
return(.t.)

function mch3
   scrollup(2)
   showprg(1)
   @ mr,mc say 'Enter System name : ' get msystem picture '@K XXXXXXXXXX'
   read                                                       
   if empty(msystem)
      return(.t.)
   endif
   scrollup(1)
   showprg(1)
   @ mr,mc say 'Enter Event name  : ' get mevent picture '@K XXXXXXXX'
   read                                                       
   if empty(mevent)
      return(.t.)
   endif

   showprg(1)
   y = capncntr(msystem,mevent)               && read contents of counter
   if y = -1
      showprg(-1)
      scrollup(1)
      @ mr,mc say 'System '+msystem+' not authorized!'
   elseif y = -2
      showprg(-1)
      scrollup(1)
      @ mr,mc say 'Network Error!'
   elseif y = -3
      showprg(-1)
      scrollup(1)
      @ mr,mc say 'Event Counter '+mevent+' corrupted!'
   else
      showprg(-1)
      scrollup(1)
      @ mr,mc say 'Available events = ' + str(y,6)
   endif
return(.t.)

function mch4
   scrollup(2)
   showprg(1)
   @ mr,mc say 'Enter System name : ' get msystem picture '@K XXXXXXXXXX'
   read                                                       
   if empty(msystem)
      return(.t.)
   endif
   scrollup(1)
   showprg(1)
   @ mr,mc say 'Enter Event name  : ' get mevent picture '@K XXXXXXXX'
   read                                                       
   if empty(mevent)
      return(.t.)
   endif

   showprg(1)
   y = capncntr(msystem,mevent)               && read contents of counter
   if y = -1
      showprg(-1)
      scrollup(1)
      @ mr,mc say 'System '+msystem+' not authorized!'
      return(.t.)
   elseif y = -2
      showprg(-1)
      scrollup(1)
      @ mr,mc say 'Network Error!'
      return(.t.)
   elseif y = -3
      showprg(-1)
      scrollup(1)
      @ mr,mc say 'Event Counter '+mevent+' corrupted!'
      return(.t.)
   else
      showprg(-1)
      scrollup(1)
      @ mr,mc say 'Available events = ' + str(y,6)
   endif

   y = y - 1

   showprg(1)
   z = capncntw(msystem,mevent,y)                && write counter
   if z = -1
      showprg(-1)
      scrollup(1)
      @ mr,mc say 'System '+msys+' not authorized!'
   elseif z = -2
      showprg(-1)
      scrollup(1)
      @ mr,mc say 'Network Error!'
   elseif z = -3
      showprg(-1)
      scrollup(1)
      @ mr,mc say 'Error writing to Event '+mevent+'!'
   else
      showprg(-1)
      scrollup(1)
      @ mr,mc say 'Now Available    = ' + str(y,6)
   endif
return(.t.)

function mch5
   scrollup(2)
   showprg(1)
   @ mr,mc say 'Enter System name : ' get msystem picture '@K XXXXXXXXXX'
   read                                                       
   if empty(msystem)
      return(.t.)
   endif
   scrollup(1)
   showprg(1)
   @ mr,mc say 'Enter Event name  : ' get mevent picture '@K XXXXXXXX'
   read                                                       
   if empty(mevent)
      return(.t.)
   endif
   cseed = capnget(mevent)            && get seed number
   cauth = 0

   scrollup(1)
   showprg(1)
   @ mr,mc say 'Serial number is  : '
   @ mr,mc+20 say val(cseed) picture '999 999 999 999'
   scrollup(1)
   @ mr,mc say 'Enter Authorization Number : ' 
   scrollup(1)
   @ mr,mc+20 get cauth picture '999 999 999 999'
   read
   if lastkey() = 27
      return(.t.)
   endif
   cauth = str(cauth,12)

   showprg(1)
   newevents = capncntm(mevent, cseed, cauth)

   y = capncntr(msystem,mevent)               && read contents of counter
   if y = -1
      showprg(-1)
      scrollup(1)
      @ mr,mc say 'System '+msystem+' not authorized!'
      return(.t.)
   elseif y = -2
      showprg(-1)
      scrollup(1)
      @ mr,mc say 'Network Error!'
      return(.t.)
   elseif y = -3
      showprg(-1)
      scrollup(1)
      @ mr,mc say 'Event Counter '+mevent+' corrupted!'
      return(.t.)
   else
      showprg(-1)
      scrollup(1)
      @ mr,mc say 'Available events = ' + str(y,6)
   endif

   y = y + newevents

   showprg(1)
   z = capncntw(msystem,mevent,y)                && write counter
   if z = -1
      showprg(-1)
      scrollup(1)
      @ mr,mc say 'System '+msys+' not authorized!'
   elseif z = -2
      showprg(-1)
      scrollup(1)
      @ mr,mc say 'Network Error!'
   elseif z = -3
      showprg(-1)
      scrollup(1)
      @ mr,mc say 'Error writing to Event '+mevent+'!'
   else
      showprg(-1)
      scrollup(1)
      @ mr,mc say 'Now Available    = ' + str(y,6)
   endif
return(.t.)       

function mch6
   scrollup(2)
   showprg(1)
   @ mr,mc say 'Enter System name : ' get msystem picture '@K XXXXXXXXXX'
   read                                                       
   if empty(msystem)
      return(.t.)
   endif
   scrollup(1)
   showprg(1)
   @ mr,mc say 'Enter Event name  : ' get mevent picture '@K XXXXXXXX'
   read                                                       
   if empty(mevent)
      return(.t.)
   endif
   scrollup(1)
   showprg(1)
   @ mr,mc say 'Enter Event Count : ' get mcnt picture '999999'
   read                                                       
   y = mcnt

   showprg(1)
   z = capncntw(msystem,mevent,y)                && write counter
   if z = -1
      showprg(-1)
      scrollup(1)
      @ mr,mc say 'System '+msys+' not authorized!'
   elseif z = -2
      showprg(-1)
      scrollup(1)
      @ mr,mc say 'Network Error!'
   elseif z = -3
      showprg(-1)
      scrollup(1)
      @ mr,mc say 'Error writing to Event '+mevent+'!'
   else
      showprg(-1)
      scrollup(1)
      @ mr,mc say 'Now Available    = ' + str(y,6)
   endif
return(.t.)

function scrollup
   parameters slines
   for mx = 1 to slines
      scroll(4,41,12,77,1)
      @ 12,41 clear to 12,77
   next
return(.t.)

function showprg
   parameters moffset
   prgrow = procline(1) + moffset
   keyboard chr(27)
   memoedit(mprg,15,2,22,77,.f.,,120,,prgrow)
return(.t.)

function showprg2
   parameters moffset
   prgrow = moffset
   keyboard chr(27)
   memoedit(mprg,15,2,22,77,.f.,,120,,prgrow)
return(.t.)

function prgup
   prgrow = prgrow - 1
   if prgrow < 1
      prgrow = 1
   endif            
   showprg2(prgrow)
return(.t.)

function prgdown
   prgrow = prgrow + 1
   showprg2(prgrow)
return(.t.)

function prgpgup
   prgrow = prgrow - 7
   if prgrow < 1
      prgrow = 1
   endif            
   showprg2(prgrow)
return(.t.)

function prgpgdn
   prgrow = prgrow + 7
   showprg2(prgrow)
return(.t.)

function keyson
   set key  5  to prgup                             && up arrow
   set key 24  to prgdown                           && down arrow
   set key 18  to prgpgup                           && page up
   set key  3  to prgpgdn                           && page down
return(.t.)

function keysoff
   set key  5  to 
   set key 24  to 
   set key 18  to prgpgup                           && page up
   set key  3  to prgpgdn                           && page down
return(.t.)

