********************************************************************************
*  CALC.PRG - This program is a floating point electronic calculator written   *
*             in the Dbase III + programming language. The program author      *
*             has placed this program in the Public Domain.     Dan Kenny 5/88 *
********************************************************************************
****************************
* Set environmentals       *
****************************
set talk off
set decimals to 2
set fixed on           
set intensity off
set escape off
set bell off
****************************
* Define and Set variables *
****************************
operand1 = 0
operand2 = 0
result   = 0
decount = 2
loperator = 61
key = 0
col  = 54
equalsmode = .T.
firstpass = .T.
memexist = .F.
oper2str = ""
memstr = ""
picstring = "9999999999.99"
****************************
* Build Screen Display     *
****************************
clear
do calc.fmt       
@  3, 54 say operand1  picture picstring      
@  4, 54 say operand2  picture picstring      
@  6, 54 say result  picture picstring      
****************************
* Main program control     *
****************************
do while key <> 27                                          && Escape exits
   @ 8, col say ""
   key = 0
   do while key = 0
      key = inkey()
   enddo
   do case
****************************
* Input = ESC              *
****************************
      case key=27                                           && Loop on Escape
           loop
****************************
* Input = (*)(+)(/)(+)(=)  *
****************************
      case key=42 .or. key=43 .or. key=45;                                
                  .or. key=47 .or. key=61 .or. key=13       && Operators  
                                                            && (/,+,-,*,=,ENTER)
           if key = 13 
              key = 61                                      && ENTER=Equal Sign
           endif
           if key = 45                                      && Minus Sign:
              if len(oper2str) = 0 .and. loperator <> 61    && Assign '-' to  
                 oper2str = "-"                             && input (neg val)
                 @  8, col say "-"
                 col = col + 1                          
                 loop
              endif  
              if oper2str = "-"                             && Toggle if already
                 oper2str = ""                              && one there and
                 @  8, col-1 say " "                        && change stacked
                 col = col - 1                              && operator to '-'
                 loperator = key
                 @ 6, 68 say chr(loperator)
                 loop 
              endif
           endif

           if key = 61                                      && Equals Sign:
              @  6, 68 say " "                                             
              if equalsmode .and. len(trim(oper2str))=0     && Equals was last
                 loperator = key                            && key-no input
                 loop
              else
                 equalsmode = .T.                           && Otherwise,
              endif                                         && turn equalsmode
           endif                                            && on-process input

           if equalsmode                                    && Equalsmode:
              if len(trim(oper2str)) = 0                    && Blank out current
                 loperator = key                            && operator if no
                 @ 6, 68 say chr(iif(key=61," ",loperator)) && input; keep 
                 loop                                       && equalsmode on
              else
                 if key <> 61                               && Otherwise,
                    equalsmode = .F.                        && toggle off and   
                    firstpass = iif(loperator=61,.T.,.F.)   && process as a     
                 endif                                      && firstpass if
              endif                                         && if last "mode"
           endif                                            && was equalsmode
           
           if firstpass                                     && Firstpass:
              firstpass = .F.                               && firstpass merely
              result = val(oper2str)                        && assigns input
              loperator = key                               && to result, and
              operand1 = 0                                  && stacks the
              operand2 = 0                                  && operator for 
              @  3, 54 say operand1  picture picstring+"  " && processing the
              @  4, 54 say result  picture picstring        && next input line
              @  6, 54 say result  picture picstring      
              @  6, 68 say chr(key)
              col = 54
              @ 8, col say space(13) 
              operand1 = result
              oper2str = ""
              loop
           endif

           if len(trim(oper2str))=0                         && If no input, 
              loperator = key                               && then change the
              @ 6, 68 say chr(loperator)                    && stacked operator
              loop                                          && loop to top
           endif                                                           

           operand2 = val(oper2str)                         && Process operator:
           do case
              case loperator = 42                           && (*) Multiply
                   result = operand1 * operand2
              case loperator = 43                           && (+) Add   
                   result = operand1 + operand2
              case loperator = 45                           && (-) Subtract
                   result = operand1 - operand2
              case loperator = 47                           && (/) Divide
                   result = operand1 / operand2
           endcase
           @  3, 54 say operand1  picture picstring         && Update display
           @  4, 54 say operand2  picture picstring      
           @  6, 54 say result  picture picstring      
           @  3, 68 say chr(loperator)
           @  6, 68 say iif(key=61," ",chr(key))            && Don't display (=)
           loperator = key
           col = 54
           @ 8, col say space(13)                           && Set up for next 
           operand1 = result                                && operation  
           oper2str = ""
           loop
****************************
* Input = (.) or (1 thru 9)*
****************************
      case key = 46 .or. (key >= 48 .and. key <= 57)        && Period (.) and 
                                                            && numbers (1-9):
           if len(oper2str) = 13                            && Upper limit of
              ?? chr(7)                                     && input = 13 chrs
           else
              oper2str = oper2str + chr(key)                && Otherwise, add
              @ 8, col say chr(key)                         && digit as char
              col = col + 1                                 && to input string
           endif
           loop
****************************
* Input = Backspace        *
****************************
      case key = 8 .or. key = 127                           && Backspace:

           if len(oper2str) = 0                             && Beep if there
              ?? chr(7)                                     && ain't anything
           else
              oper2str = left(oper2str,len(oper2str)-1)     && Otherwise, 
              col = col - 1                                 && shorten input 
              @ 8, col say " "                              && string
           endif
           loop
****************************
* Input = F1 : Clear       *
****************************
      case key = 28                                         && Clear:
           operand1 = 0                                     && Init values and
           operand2 = 0                                     && the input string
           result   = 0      
           oper2str = ""
           @  3, 54 say operand1  picture picstring+"  "    && Update display
           @  4, 54 say operand2  picture picstring      
           @  6, 54 say result    picture picstring+"  "
           firstpass = .T.                                  && Init more stuff
           loperator = 61 
           col = 54
           @ 8, col say space(13) 
           loop
****************************
* Input = F2 : Clear Entry *
****************************
      case key = -1                                         && Clear Entry:
           oper2str = ""                                    && Init input string
           col = 54                                         
           @ 8, col say space(13) 
           loop
****************************
* Input = F3 : Clear Mem   *
****************************
      case key = -2                                         && Clear Mem:
           if memexist                                      && Init mem string
              memstr = ""                                   && and clear mem
              @  3, 30 clear to 6,50                        && display
              memexist = .F.
           endif
           loop
*****************************
* Input = F4 : Mem to Entry *
*****************************                               
      case key = -3                                         && Mem to Entry: 
           oper2str = memstr                                && Replace input
           col = 54                                         && string with mem
           @ 8, col say space(13)                           && string and 
           @ 8, col say oper2str                            && display
           col = col + len(oper2str)
           loop
********************************
* Input = F5 or F6: Assign Mem *
********************************
      case key = -4 .or. key = -5                           && Assign Mem:
           if .not. memexist                                && If mem isn't
              @  3, 30 say "  Memory Contents    "          && on, display
              @  4, 30 say " Ŀ   "
              @  5, 30 say "                   "
              @  6, 30 say "    "
              memexist = .T.
           else                                             && Otherwise,
              @  5, 33 say space(13)                        && clear existing
           endif              
           if key = -4                                      && F5=copy input
              memstr = oper2str
           else                                             && F6=copy result
              memstr = trim(transform(result,"@zb "+picstring))
           endif
           @  5, 33 say memstr                              && Display
           loop
****************************
* Input = F7 : Decimals    *
****************************                                && Decimals:
      case key = -6
           @ 23, 2 say "Enter # of decimals: " get decount picture "9" range 0,9
           read
           @ 23, 2 say space(30)                            && Get new number
           if mod(readkey(),256) <> 12
              if decount <> 0 
                 picstring = replicate("9",12-decount)+"."+replicate("9",decount)
              else
                 picstring = "9999999999999"
              endif
              set decimals to decount                       && Update display
              @  3, 54 say operand1  picture picstring      
              @  4, 54 say operand2  picture picstring      
              @  6, 54 say result  picture picstring      
           endif
           loop
*****************************
* Input = None of the Above *
*****************************                                
      otherwise                                             && If the keypress
           ?? chr(7)                                        && was bad, beep
   endcase
enddo
clear
