#include "c5eb.ch"
*- ShowRecs() ---------------------------------------------------------------
*
* Record Display demo
*

FUNC ShowRecs
PARA ebdfile,table,index,editflag

PRIVATE Formatted,FldCount,trow,brow,i,Key,FldNames,IsBin

IF eb_setdatabase(ebdfile) .AND. eb_use(table) .AND. eb_setIDX(index)
    @ 0,0 say "database:"+ebdfile
    @ 0,20 say "table:"+table+"("+index+")"
ELSE
    RETURN(FALSE)
ENDIF

*IsBin := IF(TYPE("IsBin")=="L", IsBin, FALSE)
IsBin := TRUE

* If we somehow got here with an empty table, get out quick
IF EB_TblEmpty()
    PromptLine("Table is Empty!  Press any key to continue...")
    Error_msg("Table is Empty!")
    PromptLine("")
    RETURN(FALSE)
ENDIF

* Get number of fields
FLDCount := EB_FLDCount()

* If 0, no fields
IF FLDCount ==0
    RETURN(NULL)
* else, if < 0, an error occurred
ELSEIF FLDCount < 0
    PromptLine("ERROR!  Press any key to continue...")
    Error_msg("Error: EB_FLDCount()",EB_ErrorMsg())
    PromptLine("")
    RETURN(NULL)
ENDIF

* Declare a public array to hold field names and selection flags
* (PUBLIC because we will use it in other non-child functions)
PUBLIC FLDNames[FLDCount]

* Initialize FldNames elements
* (EB_FldNamArray will only fill up to LEN(FldNames[i]) if element
* has been assigned a type
AFILL(FldNames, SPACE(20))

* Refill FldNames (unselected names were nuked in SelectFLD()
EB_FldNamArray(FldNames)

* Don't use more than 18 fields
FldCount := MIN(LEN(FldNames), 18)

* Declare an array to hold record data
PRIVATE RecData[FldCount]

* We want formatted data!
Formatted := TRUE

* Make sure we're at the first record
EB_GoTop()

* Initialize top/bottom of file flags
AtTop := TRUE
AtEnd := FALSE

* Set box top and bottom rows
trow := MAX(1,10 - INT(FldCount / 2))
brow := MIN(22,14 + INT(FldCount / 2))

* Display box
@ trow,5,brow,74 BOX DblFrame

* Display field names
FOR i := 1 TO FldCount
    @ trow+1+i,7 SAY SPACE(20-LEN(FldNames[i])) + FldNames[i] + ":"
NEXT

* Display prompt
IF ! IsBin
    PromptLine("[PgUp] - Prev Record   [PgDn] - Next Record   [Esc] - Exit")
ELSE
    PromptLine("[PgUp] - Prev Rec  [PgDn] - Next Rec  [F10] - "+;
        "Extract Program  [Esc] - Exit")
ENDIF

* Load first record into array (all data returned as formatted strings)
EB_Rec2Array(RecData,Formatted)

* Do forever (or at least until someone says stop)
DO WHILE .T.
CLEAR GETS

    @ trow, 7 SAY IF(AtTop, " First Record ", "")
    @ trow,60 SAY IF(AtEnd, " Last Record ", "")

    oldcolor:=SETCOLOR()
    SETCOLOR("gr+/b,n/g,,,w+/r")

    FOR i := 1 TO FldCount
        @ trow+1+i,30 GET RecData[i] PICT "@S30"
    NEXT

    IF editflag
       READ
       Key := LASTKEY()
    ELSE
       Key := INKEY(0)
    ENDIF

    DO CASE

        CASE Key ==ESC
            SETCOLOR(oldcolor)
            EXIT

        CASE Key ==PGUP
            IF AtTop
                TONE(1000,2)
                LOOP
            ENDIF

            EB_Skip(-1)
            EB_Rec2Array(RecData,Formatted)

            AtEnd := FALSE

            IF EB_BOF()
                AtTop := TRUE
            ENDIF

        CASE Key ==PGDN
            IF AtEnd
                TONE(1000,2)
                LOOP
            ENDIF

            EB_Skip()
            EB_Rec2Array(RecData,Formatted)

            AtTop := FALSE

            IF EB_EOF()
                AtEnd := TRUE
            ENDIF

        CASE Key = F10 .AND. IsBin
            RunBin()

        OTHERWISE
            TONE(1000,2)
            FOR i := 1 TO FldCount
               eb_FldReplace(i,RecData[i])
               eb_RecUpdate()
            NEXT

    ENDCASE

ENDDO

Cls()

RETURN(TRUE)


*- RunBin() ----------------------------------------------------------------
*
* Called from ShowRec() in Binary Field Demo mode
*
* Extracts an executable program from the table, writes it to disk,
* and runs it!

FUNC RunBin

PRIVATE old_prompt,buffer,progname,prog_handle,bytes,temp,old_color

old_prompt := SAVESCREEN(24,0,24,79)

PromptLine("Extracting program from Binary Field...")

* Make a buffer (We'll keep it small so we don't run out of memory.  Note
* that each consecutive call to EB_BinRead() picks up where the last one
* left off.  That way we don't have to have a massive buffer.

buffer := SPACE(100)

* Get program name
progname := EB_FldData("program_name")

* Create file for program
prog_handle := FCREATE(progname)

* Check for error from file creation
IF prog_handle < 0 .OR. FERROR() != 0
    PromptLine("ERROR!  Press any key to continue...")
    Error_msg("Error: FCREATE()","Error #: "+LTRIM(STR(FERROR())))
    RESTSCREEN(24,0,24,79,old_prompt)
ENDIF

DO WHILE TRUE
    bytes := EB_BinRead("code",@buffer)
    IF bytes <= 0
        EXIT
    ELSE
        FWRITE(prog_handle,buffer,bytes)
    ENDIF
ENDDO

* Close the new file
FCLOSE(prog_handle)

PromptLine(progname + " extracted.  Press any key to run...")
INKEY(0)

* Save the screen
temp := SAVESCREEN(0,0,24,79)

* Clear for program
old_color := SETCOLOR("N/W")
CLEAR

* And run it!
RUN (progname)

SETCOLOR("GR+/N")
@ 24,43 SAY " Press any key to return to Demo... "
INKEY(0)

* Restore old color
SETCOLOR(old_color)

* Restore old screen
RESTSCREEN(0,0,24,79,temp)

* Restore prompt line
RESTSCREEN(24,0,24,79,old_prompt)

RETURN(TRUE)
