#include "c5eb.ch"
*- SelectTBL() -------------------------------------------------------------

FUNC SelectTBL

PRIVATE TBLCount,choice

* Get number of tables in current database
TBLCount := EB_TBLCount()

* If 0, no Tables
IF TBLCount ==0
    PromptLine("No Tables!  Press any key to continue...")
    Error_msg("No Tables in Database!")
    PromptLine("")
    RETURN(NULL)
* else, if < 0, an error occurred
ELSEIF TBLCount < 0
    PromptLine("ERROR!  Press any key to continue...")
    Error_msg("Error: EB_TBLCount()",EB_ErrorMsg())
    PromptLine("")
    RETURN(NULL)
ENDIF

* Declare an array to hold table names
PRIVATE TBLList[EB_TBLCount()]

* Fill array with table names
IF EB_TBLArray(TBLList) < 1
    PromptLine("ERROR!  Press any key to continue...")
    Error_msg("Error: EB_Tables()",EB_ErrorMsg())
    PromptLine("")
    RETURN(NULL)
ENDIF

* Display box
@ 0,20,19,39 BOX SglFrame
@ 0,21 SAY " Tables "

* Display help prompt
PromptLine("Press [ENTER] to select, [F1] for Info, [Esc] to Cancel")

* Get user selection using ACHOICE()
Object := "TABLE"
choice := ACHOICE(2,21,18,38,TBLList,"","AChoiceFunc")

* Clear prompt line
PromptLine("")

IF choice ==0
    RETURN("")
ENDIF

RETURN(TBLList[choice])



