#include "c5eb.ch"

FUNC C5_Setup

* Set the default table locking mode to BROWSE so others may access
EB_SetLockMode(BROWSE)

* Select an Area (1-9) to activate the Database in
* EB_Select(0) selects the next available area
AreaNo := EB_Select(0)

*
*   DATABASE LIST
*

* Get a list of EB Databases (.EBD) in current directory.
* and select one to open
Ebd2open := SelectEBD()

* If no database selected, then exit
IF EMPTY(Ebd2Open)
    RETURN(TRUE)
ENDIF

* Show a status msg
PromptLine("Opening "+Ebd2Open)

* Open the Emerald Bay Database (EBD)
IF ! EB_SetDatabase(Ebd2Open)
    PromptLine("ERROR!  Press any key to continue.")
    error_msg("Error: EB_SetDatabase()",EB_ErrorMsg())
    RETURN(TRUE)
ENDIF

#IFDEF InTrans
* Begin Transaction Processing
IF ! EB_TransBegin ()
    PromptLine("ERROR!  Press any key to continue.")
    error_msg("Error: EB_TransBegin",EB_ErrorMsg())

    * Prompt for goahead or quit
    PromptLine("Transaction process unavailable, [ENTER] to proceed, "+;
        "[Esc] to abort")

    * If Esc, log out and exit
    IF INKEY(0) ==27
        EB_Logout()
        RETURN(TRUE)
    ENDIF
ELSE
    * Set transaction flag to TRUE
    InTrans := TRUE
ENDIF
#ENDIF

* If desired, assign an alias for the table to activate
* The alias may contain embedded blanks
TblAlias := "Table One"

*
*   TABLE LIST
*

* Get a list of Available Tables in current Database
* and Select one to activate
Tbl2Use := SelectTBL()

* If no table was selected, then abort transaction, log out and exit
IF EMPTY(Tbl2Use)
    * If transaction is active, abort it
    #IFDEF InTrans
        EB_TransAbort()
    #ENDIF
    EB_Logout()
    RETURN(TRUE)
ENDIF

* Show a status msg
PromptLine("Opening "+Tbl2Use)

* Activate Table
IF ! EB_Use(AreaNo,Tbl2Use,TblAlias)
    PromptLine("ERROR!  Press any key to continue.")
    error_msg("Error: EB_USE()",EB_ErrorMsg())
    * If transaction is active, abort it
    #IFDEF InTrans
        EB_TransAbort()
    #ENDIF
    EB_Logout()
    RETURN(TRUE)
ENDIF

*
*   INDEX LIST
*

* Get a list of Available Indexes for current Table
* and Select one to activate
Idx2Use := SelectIDX()
IF ! EMPTY(Idx2Use)

    * Show a status msg
    PromptLine("Setting Index to "+Idx2Use)

    * Activate Index
    IDXVal := EB_SetIDX(Idx2Use)

    IF EMPTY(IDXVal)
        PromptLine("ERROR!  Press any key to continue.")
        error_msg("Error: EB_SetIDX()",EB_ErrorMsg())
        * If transaction is active, abort it
        #IFDEF InTrans
            EB_TransAbort()
        #ENDIF
        EB_Logout()
        RETURN(TRUE)
    ENDIF
ENDIF

RETURN (TRUE)
