* Program Name: c5eb.prg
* Authors: Jeff Jochum/BJ Walsh
* Copyright (c) 1990 by SuccessWare 90, Inc.
*-----------------------------------------------------------------------------
* Sample program demonstrating some of the features and uses of
* CLIP2EB with Clipper 5.0.
*
* This could be jazzed-up quite a bit using some screen functions from
* FUNCKY or one of the other fine function libraries available.
*
*
* Compile with Clipper 5.0 and link with .rtLink
*
*
* RTINK:  RTLINK FI example1 SEARCH clip2eb, clipper, extend 
*
*
* Thanks for your continued Clipperage!
*
*
*           ___             ___
*          (   >    /)  /) (   >         /
*           __/_/> //  //   __/_______. /_  . . ______
*          / / (__//__//_  / /  (_) (__/ /_(_/_/ / / <_
*         <_/    />  />   <_/
*               </  </
*                 __   ___   _     _____  _
*                /  ) (   > ' )   /      //     /
*               /--<   __/_  / / / __.  // _   /_
*              /___/  / /   (_(_/ (_/|_</_/_)_/ /_
*                    <_/
*        
*
*                   SuccessWare 90, Inc.
*                   42092 Humber Rd.
*                   Temecula, CA  92390
*                   (714) 699-9657
*
*                   BBS - The BabelBoard (714) 694-6891  1200/2400 N-8-1
*
*
*---------------------------- ALL RIGHTS RESERVED ----------------------------

#include "c5eb.ch"

* Save DOS screen, colors, etc.
DOS_Screen := SAVESCREEN(0,0,24,79)
DOS_Row    := ROW()
DOS_Col    := COL()
DOS_Color  := SETCOLOR()

* Set the environment
SET CURSOR     OFF
SET CONFIRM    ON
SET SCOREBOARD OFF

PUBLIC Object,ebD2Open,Tbl2Use,Idx2Use

SETCOLOR(StdColor)
Cls()
disclaimer(0)

* Main loop (Do until user begs for mercy!)
DO WHILE TRUE

    * Blaze outahere if MAIN() returns FALSE (fatal error)
    IF ! MAIN()
        EXIT
    ENDIF

    Cls()

    * Get user's attention
    TONE(2000,1)
    TONE(2500,1)

    * Please sir, I'd like some more...
    PromptLine("One more time? (Y/n)")

    * Eat keystrokes until one of the magic keys are hit
    DO WHILE TRUE
        temp := UPPER(CHR(INKEY(0)))
        IF temp $ "YN" + CHR(ENTER) + CHR(ESC)
            EXIT
        ELSE
            TONE(1000,2)
        ENDIF
    ENDDO
    IF temp =="N" .OR. temp ==CHR(ESC)
        EXIT
    ENDIF
ENDDO

* restore DOS screen and quit
SETCOLOR(DOS_Color)
RESTSCREEN(0,0,24,79,DOS_Screen)
@ DOS_Row,DOS_Col SAY ""
SET CURSOR ON
QUIT

*EOP


*- Main() ------------------------------------------------------------------
*
* Main processing function

FUNC Main

* Transaction active flag
#IFDEF InTrans
    STATIC InTrans := FALSE
#ENDIF

Cls()

* In any type of Network/Server environment, it is always necessary for
* the user to be identified and a password level to be set.
userID := "public"
userPWD:= ""

* Make sure EB Engine is loaded and Log In
nVersion := EB_Login(userID)

IF nVersion > 0
   cVersion := LTRIM(STR(nVersion/100,4,2))
   PromptLine("Emerald Bay Engine - version "+cVersion+"!  Press any key...")
   INKEY(5)
   PromptLine("")
ELSE
   error_msg("ERROR: Emerald Bay Engine not loaded!","Please run "+;
        "EBENGINE.exe first")
   RETURN(FALSE)
ENDIF

EB_SetLockMode(BROWSE)
AreaNo := EB_Select(0)
Ebd2open := "DEMO"
PromptLine("Opening "+Ebd2Open)
* Open the Emerald Bay Database (EBD)
EB_SetDatabase(Ebd2Open)
Tbl2Use := "phonebook"
PromptLine("Opening "+Tbl2Use)
TblAlias := "Table One"
EB_Use(AreaNo,Tbl2Use,TblAlias)
Idx2Use := "rec_no"
* Activate Index
EB_SetIDX(Idx2Use)


* Main Menu Loop
*---------------
do while TRUE
   cls()
   @ 0,0 
   @ 0,50 SAY "(c) 1990 SuccessWare 90, Inc."
   @ 2,15,6,65 BOX DrpFrame
   @ 3,25 SAY "       C L I P 2 E B         "
   @ 4,25 SAY " Quick & Dirty Demo Program  "
   @ 11,5,17,75 BOX DrpFrame
   @ 13,09 prompt "1. Browse Table"
   @ 14,09 prompt "2. Record Edit"
   @ 15,09 prompt "3. Import dbf"
   @ 13,42 prompt "4. Binary Field Demo"
   @ 14,42 prompt "5. Change Index"
   @ 15,42 prompt "6. Select Database"
  
   @ 24,0
   menu to Mainsel

DO CASE
CASE mainsel==1
*
*   FIELD LIST
*

* Select Fields to See
* (SelectFLD will declare public array FLDList)
SelectFLD()

Cls()

*
*   BROWSE DEMO
*

* See if the table is empty before trying to list
IF EB_TblEmpty()
    PromptLine("Empty Table!  Press any key to continue.")
    Error_msg("Table is empty!")
ELSE
    * To be sure that file pointer is at top of the table
    EB_GoTop()

    * List field data to the screen
    EB_Edit(3,1,23,79,FLDList)

    * Clear prompt line
    PromptLine("")
ENDIF


CASE mainsel==2
*
*   RECORD EDIT/DISPLAY DEMO
*
ShowRecs(Ebd2Open,Tbl2Use,Idx2Use,TRUE)


CASE mainsel==3
* NOTE: This selection has been disabled to minimize the number of
* files necessary for upload to CompuServe
*
*   dbf Import DEMO
*
Promptline("   Importing FILE:demo.dbf SIZE:354kb >>> TABLE:demo  SIZE:66kb")
* ImportDBF("demo.dbf")
INKEY(0)


CASE mainsel==4
*
*   BINARY FIELD DEMO
*
BinDemo()

CASE mainsel==5
*
*   Menu-based INDEX SELECTION
*
* Get a list of Available Indexes for current Table
* and Select one to activate
Idx2Use := SelectIDX()
IF ! EMPTY(Idx2Use)

    * Show a status msg
    PromptLine("Setting Index to "+Idx2Use)

    * Activate Index
    IDXVal := EB_SetIDX(Idx2Use)

    IF EMPTY(IDXVal)
        PromptLine("ERROR!  Press any key to continue.")
        error_msg("Error: EB_SetIDX()",EB_ErrorMsg())
        * If transaction is active, abort it
        #IFDEF InTrans
            EB_TransAbort()
        #ENDIF
        EB_Logout()
        RETURN(TRUE)
    ENDIF
ENDIF


CASE mainsel==6
*
*   Menu-based DATABASE SELECTION
*
c5_Setup()

OTHERWISE
*
*   GRACEFUL EXIT
*

* BJ say's "Always commit (or abort), or you risk barfing up your files!"
* (We're going to abort, since we didn't really change anything.  Just want
*  to show that it's here and it works.)

* Make sure a transaction is active first
#IFDEF InTrans
    IF ! EB_TransAbort()
        PromptLine("ERROR!  Press any key to continue.")
        error_msg("Error: EB_TransAbort()",EB_ErrorMsg())
        EB_Logout()
        RETURN(TRUE)
    ENDIF
#ENDIF

* BJ say's "Always logout, or you risk clobbering the engine!"
IF ! EB_Logout()
    PromptLine("ERROR!  Press any key to continue.")
    error_msg("Error: EB_Logout()",EB_ErrorMsg())
    RETURN(TRUE)
ENDIF

RETURN(TRUE)
ENDCASE
ENDDO
RETURN(TRUE)


*- EB_Rec2Array() ----------------------------------------------------------
*
* Fill an array with data from current record

FUNC EB_Rec2Array

PARAMETERS DataArray, Formatted

PRIVATE Count,i

Formatted = IF(TYPE("Formatted")=="L", Formatted, FALSE)
Count     = LEN(DataArray)

FOR i = 1 TO Count
    IF EB_FldType(i) == "BIN"
        DataArray[i] = "(binary field)"
        LOOP
    ENDIF
    IF Formatted
        DataArray[i] = EB_FldFmt(i)
    ELSE
        DataArray[i] = EB_FldData(i)
    ENDIF
NEXT

RETURN(TRUE)




