*:*********************************************************************
*:
*:      Program: BOXES.PRG
*:
*:       System: Boxes - A sample of Clipper box funcs.
*:       Author: Scott Lilly  Chicago, IL
*:
*:Procs & Fncts: SHADOW
*:             : BOX_UP
*:             : BOX_DN
*:
*:
*: This program must be linked with the EXTEND Library.
*: It can be run as a stand-alone program.
*:
*:
*: Documented: 7/11/89       15:08                   SNAP! version 2.02a
*:*********************************************************************

*-----------------------------*
*   Set Clipper environment   *
*-----------------------------*

SET TALK   OFF
SET ECHO   OFF
SET STATUS OFF
SET SCORE  OFF
SET BELL   OFF
SET CURSOR OFF

SET COLOR TO W+/B

CLEAR

*-----------------------------------------------------------------*
*   Fill the screen with come colors to test the shadow routine   *
*-----------------------------------------------------------------*

SET COLOR TO B+/W
@  7, 20 SAY REPL("a",40)
SET COLOR TO W/B
@  8, 20 SAY REPL("b",40)
SET COLOR TO G+/R
@  9, 20 SAY REPL("c",40)
SET COLOR TO GR+/W
@ 10, 20 SAY REPL("d",40)
SET COLOR TO R+/N
@ 11, 20 SAY REPL("e",40)
SET COLOR TO W+/RB
@ 12, 20 SAY REPL("f",40)
SET COLOR TO RB/B
@ 13, 20 SAY REPL("g",40)
SET COLOR TO RB+/B
@ 14, 20 SAY REPL("h",40)
SET COLOR TO B+/BG
@ 15, 20 SAY REPL("i",40)
SET COLOR TO GR+/R
@ 16, 20 SAY REPL("j",40)
SET COLOR TO GR/G
@ 17, 20 SAY REPL("k",40)

*---------------------------------------------------*
*   Call a popup box to fill from 9, 30 to 15, 52   *
*   (see function box_up for technique)             *
*---------------------------------------------------*

box_up(9,30,15,52,"scr_main",12)

*------------------------------------------------------*
*   Do a non-destructive shadow around the popup box   *
*------------------------------------------------------*

shadow(10,53,16,54)
shadow(16,32,16,54)

@ 12, 34 SAY "Press any key"

DO WHILE INKEY() = 0
ENDDO

*------------------------------------------*
*   Put the popup box away                 *
*   (see function box_dn for technique)    *
*------------------------------------------*

box_dn(9,30,15,52,"scr_main",12)

@ 22,  0 SAY ""

SET CURSOR ON

RETURN

*=========================================================================

FUNCTION shadow

PARAMETERS fn_ul_row, fn_ul_col, fn_lr_row, fn_lr_col

*-----------------------------------------------------------------*
* Purpose....: To convert a section of screen to have a black     *
*              background, and have all highlighted foreground    *
*              colors become normal.  This is a non-destructive   *
*              fill used for shadows.                             *
*                                                                 *
* Parameters.: fn_ul_row   - Upper left row of shadow area.       *
*              fn_ul_col   - Upper left column of shadow area.    *
*              fn_lr_row   - Lower right row of shadow area.      *
*              fn_lr_col   - Lower right column of shadow area.   *
*                                                                 *
* Notes......: All screen corners are included in the shadow      *
*              routine.                                           *
*-----------------------------------------------------------------*

fn_screen  = savescreen(fn_ul_row, fn_ul_col, fn_lr_row, fn_lr_col)

fn_len     = LEN(fn_screen)
fn_new_scr = ""

FOR fn_cntr = 2 TO fn_len STEP 2
	fn_new_chr = CHR(MOD((ASC(SUBSTR(fn_screen,fn_cntr,1))),8))
	fn_new_scr = fn_new_scr + SUBSTR(fn_screen,(fn_cntr - 1),1) + fn_new_chr
NEXT

restscreen(fn_ul_row, fn_ul_col, fn_lr_row, fn_lr_col, fn_new_scr)

RETURN .T.

* ===========================================================================

FUNCTION box_up

PARAMETERS end_ul_row, end_ul_col, end_lr_row, end_lr_col, scrn_tmp, sleep

PUBLIC &scrn_tmp.

SAVE SCREEN TO &scrn_tmp.

*-----------------------------------------------------------------*
* Purpose....: To draw a popup box at different sizes in order    *
*              to give the appearance of a growing box.           *
*                                                                 *
* Parameters.: end_ul_row   - Upper left row of popup box.        *
*              end_ul_col   - Upper left column of popup box.     *
*              end_lr_row   - Lower right row of popup box.       *
*              end_lr_col   - Lower right column of popup box.    *
*              start_??_??? - Are for starting box positions.     *
*              temp_??_???  - Are for temporary box positions.    *
*              scrn_tmp     - Name of the variable to save the    *
*                             screen to.                          *
*              sleep        - Used in a loop to create a pause.   *
*                                                                 *
* Notes......: The screen corners are included in the border of   *
*              the popup box.                                     *
*-----------------------------------------------------------------*

start_ul_row = end_lr_row - 1
start_ul_col = end_lr_col - 1
start_lr_row = end_lr_row
start_lr_col = end_lr_col

temp_ul_row  = start_ul_row
temp_ul_col  = start_ul_col
temp_lr_row  = start_lr_row
temp_lr_col  = start_lr_col

diff_row     = start_ul_row - end_ul_row
diff_col     = start_ul_col - end_ul_col

IF diff_row > diff_col
	increment = diff_col
ELSE
	increment = diff_row
ENDIF

inc_row = diff_row / increment
inc_col = diff_col / increment

@ start_ul_row, start_ul_col TO start_lr_row, start_lr_col DOUBLE

step_cnt = 1

DO WHILE step_cnt <= increment
	
	temp_ul_row = INT(temp_ul_row - inc_row + .99)
	temp_ul_col = INT(temp_ul_col - inc_col + .99)
	
	@ temp_ul_row, temp_ul_col TO temp_lr_row, temp_lr_col DOUBLE
	
	@ temp_ul_row + 1, temp_ul_col + 1 CLEAR TO;
	temp_lr_row - 1, temp_lr_col - 1
	
	sleep_cnt = 1
	
	DO WHILE sleep_cnt < sleep
		sleep_cnt = sleep_cnt + 1
	ENDDO
	
	step_cnt = step_cnt + 1
ENDDO

@ end_ul_row, end_ul_col TO end_lr_row, end_lr_col DOUBLE

@ end_ul_row + 1, end_ul_col + 1 CLEAR TO end_lr_row - 1, end_lr_col - 1

RETURN .T.

* ===========================================================================

FUNCTION box_dn

PARAMETERS end_ul_row, end_ul_col, end_lr_row, end_lr_col, scrn_tmp, sleep

*-----------------------------------------------------------------*
* Purpose....: To draw a popup box at different sizes in order    *
*              to give the appearance of a shrinking box.         *
*                                                                 *
* Parameters.: end_ul_row   - Upper left row of popup box.        *
*              end_ul_col   - Upper left column of popup box.     *
*              end_lr_row   - Lower right row of popup box.       *
*              end_lr_col   - Lower right column of popup box.    *
*              start_??_??? - Are for starting box positions.     *
*              temp_??_???  - Are for temporary box positions.    *
*              scrn_tmp     - Name of the variable to save the    *
*                             screen to.                          *
*              sleep        - Used in a loop to create a pause.   *
*                                                                 *
* Notes......: The screen corners are included in the border of   *
*              the popup box.                                     *
*-----------------------------------------------------------------*

start_ul_row = end_lr_row - 1
start_ul_col = end_lr_col - 1
start_lr_row = end_lr_row
start_lr_col = end_lr_col

temp_ul_row  = end_ul_row
temp_ul_col  = end_ul_col
temp_lr_row  = end_lr_row
temp_lr_col  = end_lr_col

diff_row     = start_ul_row - end_ul_row
diff_col     = start_ul_col - end_ul_col

IF diff_row > diff_col
	increment = diff_col
ELSE
	increment = diff_row
ENDIF

inc_row = diff_row / increment
inc_col = diff_col / increment

step_cnt = 1

DO WHILE step_cnt <= increment
	
	RESTORE SCREEN FROM &scrn_tmp.
	
	temp_ul_row = INT(temp_ul_row + inc_row)
	temp_ul_col = INT(temp_ul_col + inc_col)
	
	@ temp_ul_row + 1, temp_ul_col + 1 CLEAR TO;
	temp_lr_row - 1, temp_lr_col - 1
	
	@ temp_ul_row, temp_ul_col TO temp_lr_row, temp_lr_col DOUBLE
	
	sleep_cnt = 1
	
	DO WHILE sleep_cnt < sleep
		sleep_cnt = sleep_cnt + 1
	ENDDO
	
	step_cnt = step_cnt + 1
ENDDO

RESTORE SCREEN FROM &scrn_tmp.

RETURN .T.

* ===========================================================================

*: EOF: BOXES.PRG
