/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"

////////////////
////////////////
//
// Purpose:
//    Prints a list of all functions & procedures
//
// Syntax:
//    C> FUNCPROC [<cWild>]
//
// Formal Arguments: (1)
//    Name        Description
//    ___________ ____________
//    cWild       Wild card specification ["*.prg"]
//
// Description:
//    Creates FUNCPROC.PRN which contains a list of all defined functions and
//    procedures within the specified files, the default file specification
//    being "*.prg".
//
// Category:
//    Utility Program
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION FuncProc()
CLS
? 'FUNCPROC v1.0 Copyright (c)1990 John Wm Beckner'
?
IF file('FUNCPROC.DBF')
   ERASE funcproc.dbf
ENDIF
PARAMETER cSkeleton
IF pcount()=0
   cSkeleton := '*.prg'
ENDIF
IF !fExtension(cSkeleton)
   cSkeleton := fExtNew(cSkeleton, "PRG")
ENDIF
DECLARE fl[adir(cSkeleton)]
adir(cSkeleton, fl)
fCreateDBF('FUNCPROC/FUNC_NAME/C/10/FILE_NAME/C/8')
fNoShare('funcproc')
INDEX on func_name to funcproc
FOR x := 1 to len(fl)
   h := fopen(fl[x])
   ? fl[x]
   WHILE LOOPING
      b := lower(ltrim(freadline(h)))
      IF 'func'==left(b, 4)
         ? '     ',b
         APPEND BLANK
         REPLACE  file_name with left(lower(fl[x]),at('.',fl[x])-1),;
                  func_name with trim(ltrim(substr(b,at(' ',b)+1)))
      ELSEIF 'proc'==left(b,4)
         ? '     ',b
         APPEND BLANK
         REPLACE  file_name with left(lower(fl[x]),at('.',fl[x])-1),;
                  func_name with trim(ltrim(substr(b,at(' ',b)+1)))
      ELSEIF 'clipper'==left(b,7)
         ? '     ',b
         APPEND BLANK
         REPLACE  file_name with left(lower(fl[x]),at('.',fl[x])-1),;
                  func_name with trim(ltrim(substr(b,at('clipper',b)+8,;
                                 at('(',b)-8)))
      ENDIF
      IF fEOF(h)
         EXIT
      ENDIF
   END
   fClose(h)
NEXT
REPLACE all func_name with IF("("$func_name, left(func_name,;
            at("(", func_name)-1),func_name)
GO TOP
SET PRINT to funcproc
SET PRINT on
? 'FUNCTIONS & PROCEDURES',date()
?
WHILE !eof()
   ? func_name,file_name
   SKIP
END
ENDFUNCTION
