/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

#include "beckner.inc"

LOCAL aNumbers := {1, 2, 3, 4, 5}, aChars := {"A", "B", "C", "D", "E"}
LOCAL aMix := {"A", 2, "C", 3, "E"}
LOCAL aNothing := {}, aNothingMore := {NIL, NIL, NIL}, cTemp, nTemp

////////////////
////////////////
//
// Purpose:
//    Sample use of some array functions
//
// Syntax:
//    C> EXAMPLEA
//
// Formal Arguments: (0)
//
// Files:
//    Test.dbf
//
// Description:
//    Sample use of some array functions in Beckner Library.
//
// Category:
//    Sample Program
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

FUNCTION ArrayTest()
   CLS
   ? "Test of Beckner Array Functions"
   ?
   ? "The following arrays are used in these tests:"
   ?
   ? "aNumbers     {1, 2, 3, 4, 5}"
   ? [aChars       {"A", "B", "C", "D", "E"}]
   ? [aMix         {"A", 2, "C", 4, "E"}]
   ? "aNothing     {}"
   ? "aNothingMore {NIL, NIL, NIL}"
   ?
   WAIT
   CLS
   ? "Average of {1,2,3,4,5} and {1,2,3}"
   ? aAverage(aNumbers), aAverage(aNumbers, 1, 3)
   ?
   ? "Count of all elements in {1,2,3,4,5} and {1,2,3}"
   ? aCount(aNumbers), aCount(aNumbers, , 1, 3)
   ?
   ? "Is aNothing empty?",if(aEmpty(aNothing), "Yes", "No")
   ? "Is aMix empty?", if(aEmpty(aMix), "Yes", "No")
   ? "Is aNothingMore empty?", if(aEmpty(aNothingMore), "Yes", "No")
   ?
   WAIT
   CLS
   ? "Creating a test file called TEST.DBF, which has the structure:"
   ? "cNAME       Character   1"
   ? "nBALANCE    Numeric     8  2"
   ? "dDATE       Date"
   fCreateDBF("TEST/cNAME/C/1/nBALANCE/N/8/2/dDATE/D")
   fShare("Test")
   ?
   ? "Adding one record with the following data: "
   fAddRecord()
   ? "Name is   ", (Field->cName := "BECKNER")
   ? "Balance is", (Field->nBalance := 100.00)
   ? "Date is   ", (Field->dDate := date())
   ?
   ? "Using aFromRec() to create an array with the same data, as displayed:"
   aFromRec(aNothing)
   aEval(aNothing, {|xElement, nElNum| Qout(Field(nElNum), xElement)})
   ?
   vCursSave()
   ACCEPT "Enter a new name for the first array element: " to cTemp
   vCursRest()
   ?
   aNothing[1] := cTemp
   ?
   ? "Array element being stored into the second record"
   fAddRecord()
   aToRec(aNothing)
   ? "The maximum element found in aNumbers is", aMax(aNumbers), "at element #"
   ?? aMaxElement(aNumbers)
   ? "The maximum element found in aChars is", aMax(aChars, "C"), "at element #"
   ?? aMaxElement(aChars, "C")
   ? "The minimum element found in aNumbers is", aMin(aNumbers), "at element #"
   ?? aMinElement(aNumbers)
   ? "The minimum element found in aChars is", aMin(aChars, "C"), "at element #"
   ?? aMinElement(aChars, "C")
   WAIT
   CLS
   ? "The length of aNothingMore prior to packing is", len(aNothingMore)
   aPack(aNothingMore)
   ? "The length of aNothingMore after packing is", len(aNothingMore)
   ?
   ? "Answer 'P' if you want to proceed with the aPrint test,"
   vCursSave()
   cTemp := "P"
   ACCEPT "which requires your printer to be online: " to cTemp
   vCursRest()
   ?
   IF cTemp$"Yy"
      ?
      ? "aNumbers is being printed, followed by aChars"
      aPrint(aNumbers,,,,.n.)
      aPrint(aChars)
   ENDIF
   ?
   ? "A file is being created called TEST.TXT, which contents are:"
   aWrite({"This is the first line", "and this is the second.",;
   "Therefore, this is the last!"}, "TEST.TXT")
   ? "Now the file is being read and displayed:"
   aNothing := {}
   aRead(aNothing, "TEST.TXT")
   aEval(aNothing, {|cElement| qout(cElement)})
   WAIT
   CLS
   ? "The sum of the elements in {1,2,3,4,5} and {1,2,3} are"
   ? aSum(aNumbers), aSum(aNumbers, 1, 3)
   ?
   ? "The first number found in aMix is", aMatch(aMix, "N"), "at element #"
   ?? aMatchNum(aMix, "N")
   ? "The first character found in aMix is", aMatch(aMix, "C"), "at element #"
   ?? aMatchNum(aMix, "C")
   ?
   ? "aChars as a single string using aArray2Char():"
   ? (cTemp := aArray2Char(aChars))
   ?
   ? [The longest element in {"A", "ABC", "12"} is], aLongest({"A", "ABC", "12"})
   ?? " characters"
   ?
   ? "The total of all string lengths in aChars is", aTotalLen(aChars)
   ?
   ? "Press any key to use the array pick list for aChars"
   inkey(0)
   CLS
   nTemp := aPickList(aChars)
   ? "You chose element #", nTemp
   ?
   ? "END OF ARRAY FUNCTIONS"
ENDFUNCTION
