/*
    The source code contained within this file is protected under the
    laws of the United States of America and by International Treaty.
    Unless otherwise noted, the source contained herein is:

    Copyright (c)1990-1994 BecknerVision Inc - No Rights Reserved

    Written by John Wm Beckner
    BecknerVision Inc

        ** THIS FILE IS PUBLIC DOMAIN **

        ** Use of this code is at your own risk, absolutely no guarantees
        ** are made to its usefulness  - you must determine for yourself if
        ** this code is of any use to you.  If you do not agree with this, do
        ** not use this code. **
*/

/* Allow ALIAS clause on most commands */

////////////////
////////////////
//
// Purpose:
//    Command with ALIAS clause
//
// Syntax:
//    <command> ALIAS <cAlias>
//
// Description:
//    Adds ALIAS clause to command.  See CA-Clipper reference for information
//    about this command.  <cAlias> is the source work area and eliminates
//    the need to pre-SELECT the work area.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET RELATION                                                   ;
         [<add:ADDITIVE>]                                               ;
         [TO <key1> INTO <(alias1)>                                ]    ;
         ALIAS <a>                                                      ;
                                                                        ;
      => if ( !<.add.> )                                                ;
       ;    <a> -> (dbClearRel())                                       ;
       ; end                                                            ;
                                                                        ;
       ; <a> -> (dbSetRelation( <(alias1)>, <{key1}>, <"key1"> ))

////////////////
////////////////
//
// Purpose:
//    Command with ALIAS clause
//
// Syntax:
//    <command> ALIAS <cAlias>
//
// Description:
//    Adds ALIAS clause to command.  See CA-Clipper reference for information
//    about this command.  <cAlias> is the source work area and eliminates
//    the need to pre-SELECT the work area.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command REINDEX              ALIAS <a> => <a> -> ( dbReindex() )

////////////////
////////////////
//
// Purpose:
//    Command with ALIAS clause
//
// Syntax:
//    <command> ALIAS <cAlias>
//
// Description:
//    Adds ALIAS clause to command.  See CA-Clipper reference for information
//    about this command.  <cAlias> is the source work area and eliminates
//    the need to pre-SELECT the work area.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET ORDER TO <n>     ALIAS <a> => <a> -> ( dbSetOrder( <n> ) )

////////////////
////////////////
//
// Purpose:
//    Command with ALIAS clause
//
// Syntax:
//    <command> ALIAS <cAlias>
//
// Description:
//    Adds ALIAS clause to command.  See CA-Clipper reference for information
//    about this command.  <cAlias> is the source work area and eliminates
//    the need to pre-SELECT the work area.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET ORDER TO         ALIAS <a> => <a> -> ( dbSetOrder(0) )

////////////////
////////////////
//
// Purpose:
//    Command with ALIAS clause
//
// Syntax:
//    <command> ALIAS <cAlias>
//
// Description:
//    Adds ALIAS clause to command.  See CA-Clipper reference for information
//    about this command.  <cAlias> is the source work area and eliminates
//    the need to pre-SELECT the work area.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command APPEND BLANK         ALIAS <a> => <a> -> ( dbAppend() )

////////////////
////////////////
//
// Purpose:
//    Command with ALIAS clause
//
// Syntax:
//    <command> ALIAS <cAlias>
//
// Description:
//    Adds ALIAS clause to command.  See CA-Clipper reference for information
//    about this command.  <cAlias> is the source work area and eliminates
//    the need to pre-SELECT the work area.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command PACK                 ALIAS <a> => <a> -> ( __dbPack() )

////////////////
////////////////
//
// Purpose:
//    Command with ALIAS clause
//
// Syntax:
//    <command> ALIAS <cAlias>
//
// Description:
//    Adds ALIAS clause to command.  See CA-Clipper reference for information
//    about this command.  <cAlias> is the source work area and eliminates
//    the need to pre-SELECT the work area.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command ZAP                  ALIAS <a> => <a> -> ( __dbZap() )

////////////////
////////////////
//
// Purpose:
//    Command with ALIAS clause
//
// Syntax:
//    <command> ALIAS <cAlias>
//
// Description:
//    Adds ALIAS clause to command.  See CA-Clipper reference for information
//    about this command.  <cAlias> is the source work area and eliminates
//    the need to pre-SELECT the work area.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command UNLOCK               ALIAS <a>  => <a> -> ( dbUnlock() )

////////////////
////////////////
//
// Purpose:
//    Command with ALIAS clause
//
// Syntax:
//    <command> ALIAS <cAlias>
//
// Description:
//    Adds ALIAS clause to command.  See CA-Clipper reference for information
//    about this command.  <cAlias> is the source work area and eliminates
//    the need to pre-SELECT the work area.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command UNLOCK ALL           ALIAS <a>  => <a> -> ( dbUnlockAll() )

////////////////
////////////////
//
// Purpose:
//    Command with ALIAS clause
//
// Syntax:
//    <command> ALIAS <cAlias>
//
// Description:
//    Adds ALIAS clause to command.  See CA-Clipper reference for information
//    about this command.  <cAlias> is the source work area and eliminates
//    the need to pre-SELECT the work area.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command COMMIT               ALIAS <a>  => <a> -> ( dbCommitAll() )

////////////////
////////////////
//
// Purpose:
//    Command with ALIAS clause
//
// Syntax:
//    <command> ALIAS <cAlias>
//
// Description:
//    Adds ALIAS clause to command.  See CA-Clipper reference for information
//    about this command.  <cAlias> is the source work area and eliminates
//    the need to pre-SELECT the work area.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command GOTO <n>             ALIAS <a>  => <a> -> ( dbGoto(<n>) )

////////////////
////////////////
//
// Purpose:
//    Command with ALIAS clause
//
// Syntax:
//    <command> ALIAS <cAlias>
//
// Description:
//    Adds ALIAS clause to command.  See CA-Clipper reference for information
//    about this command.  <cAlias> is the source work area and eliminates
//    the need to pre-SELECT the work area.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command GO <n>               ALIAS <a>  => <a> -> ( dbGoto(<n>) )

////////////////
////////////////
//
// Purpose:
//    Command with ALIAS clause
//
// Syntax:
//    <command> ALIAS <cAlias>
//
// Description:
//    Adds ALIAS clause to command.  See CA-Clipper reference for information
//    about this command.  <cAlias> is the source work area and eliminates
//    the need to pre-SELECT the work area.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command GOTO TOP             ALIAS <a>  => <a> -> ( dbGoTop() )

////////////////
////////////////
//
// Purpose:
//    Command with ALIAS clause
//
// Syntax:
//    <command> ALIAS <cAlias>
//
// Description:
//    Adds ALIAS clause to command.  See CA-Clipper reference for information
//    about this command.  <cAlias> is the source work area and eliminates
//    the need to pre-SELECT the work area.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command GO TOP               ALIAS <a>  => <a> -> ( dbGoTop() )

////////////////
////////////////
//
// Purpose:
//    Command with ALIAS clause
//
// Syntax:
//    <command> ALIAS <cAlias>
//
// Description:
//    Adds ALIAS clause to command.  See CA-Clipper reference for information
//    about this command.  <cAlias> is the source work area and eliminates
//    the need to pre-SELECT the work area.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command GOTO BOTTOM          ALIAS <a>  => <a> -> ( dbGoBottom() )

////////////////
////////////////
//
// Purpose:
//    Command with ALIAS clause
//
// Syntax:
//    <command> ALIAS <cAlias>
//
// Description:
//    Adds ALIAS clause to command.  See CA-Clipper reference for information
//    about this command.  <cAlias> is the source work area and eliminates
//    the need to pre-SELECT the work area.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command GO BOTTOM            ALIAS <a>  => <a> -> ( dbGoBottom() )

////////////////
////////////////
//
// Purpose:
//    Command with ALIAS clause
//
// Syntax:
//    <command> ALIAS <cAlias>
//
// Description:
//    Adds ALIAS clause to command.  See CA-Clipper reference for information
//    about this command.  <cAlias> is the source work area and eliminates
//    the need to pre-SELECT the work area.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SEEK <xpr>           ALIAS <a>  => <a> -> ( dbSeek( <xpr> ) )
/* note FIND not included */

////////////////
////////////////
//
// Purpose:
//    Command with ALIAS clause
//
// Syntax:
//    <command> ALIAS <cAlias>
//
// Description:
//    Adds ALIAS clause to command.  See CA-Clipper reference for information
//    about this command.  <cAlias> is the source work area and eliminates
//    the need to pre-SELECT the work area.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command CONTINUE             ALIAS <a>  => <a> -> ( __dbContinue() )

////////////////
////////////////
//
// Purpose:
//    Command with ALIAS clause
//
// Syntax:
//    <command> ALIAS <cAlias>
//
// Description:
//    Adds ALIAS clause to command.  See CA-Clipper reference for information
//    about this command.  <cAlias> is the source work area and eliminates
//    the need to pre-SELECT the work area.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command LOCATE                                                         ;
         [FOR <for>]                                                    ;
         [WHILE <while>]                                                ;
         [NEXT <next>]                                                  ;
         [RECORD <rec>]                                                 ;
         [<rest:REST>]                                                  ;
         [ALL]                                                          ;
         ALIAS <a>                                                      ;
                                                                        ;
      => <a> -> ( __dbLocate( <{for}>, <{while}>, <next>, <rec>, <.rest.> ) )

////////////////
////////////////
//
// Purpose:
//    Command with ALIAS clause
//
// Syntax:
//    <command> ALIAS <cAlias>
//
// Description:
//    Adds ALIAS clause to command.  See CA-Clipper reference for information
//    about this command.  <cAlias> is the source work area and eliminates
//    the need to pre-SELECT the work area.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET FILTER TO        ALIAS <a>  => <a> -> ( dbClearFilter(NIL) )

////////////////
////////////////
//
// Purpose:
//    Command with ALIAS clause
//
// Syntax:
//    <command> ALIAS <cAlias>
//
// Description:
//    Adds ALIAS clause to command.  See CA-Clipper reference for information
//    about this command.  <cAlias> is the source work area and eliminates
//    the need to pre-SELECT the work area.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET FILTER TO <xpr>  ALIAS <a>  => <a> -> ( dbSetFilter( <{xpr}>, <"xpr"> ) )

////////////////
////////////////
//
// Purpose:
//    Command with ALIAS clause
//
// Syntax:
//    <command> ALIAS <cAlias>
//
// Description:
//    Adds ALIAS clause to command.  See CA-Clipper reference for information
//    about this command.  <cAlias> is the source work area and eliminates
//    the need to pre-SELECT the work area.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET FILTER TO <x:&>  ALIAS <a>                                 ;
      => if ( Empty(<(x)>) )                                            ;
       ;    <a> -> ( dbClearFilter()                                    ;
       ; else                                                           ;
       ;    <a> -> ( dbSetFilter( <{x}>, <(x)> )                        ;
       ; end

////////////////
////////////////
//
// Purpose:
//    Command with ALIAS clause
//
// Syntax:
//    <command> ALIAS <cAlias>
//
// Description:
//    Adds ALIAS clause to command.  See CA-Clipper reference for information
//    about this command.  <cAlias> is the source work area and eliminates
//    the need to pre-SELECT the work area.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command DELETE                                                         ;
         [FOR <for>]                                                    ;
         [WHILE <while>]                                                ;
         [NEXT <next>]                                                  ;
         [RECORD <rec>]                                                 ;
         [<rest:REST>]                                                  ;
         [ALL]                                                          ;
         ALIAS <a>                                                      ;
                                                                        ;
      => <a> -> ( DBEval(                                               ;
                 {|| dbDelete() },                                      ;
                 <{for}>, <{while}>, <next>, <rec>, <.rest.>            ;
               ) )

////////////////
////////////////
//
// Purpose:
//    Command with ALIAS clause
//
// Syntax:
//    <command> ALIAS <cAlias>
//
// Description:
//    Adds ALIAS clause to command.  See CA-Clipper reference for information
//    about this command.  <cAlias> is the source work area and eliminates
//    the need to pre-SELECT the work area.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command RECALL                                                         ;
         [FOR <for>]                                                    ;
         [WHILE <while>]                                                ;
         [NEXT <next>]                                                  ;
         [RECORD <rec>]                                                 ;
         [<rest:REST>]                                                  ;
         [ALL]                                                          ;
         ALIAS <a>                                                      ;
      => <a> -> ( DBEval(                                                        ;
                 {|| dbRecall()},                                       ;
                 <{for}>, <{while}>, <next>, <rec>, <.rest.>            ;
               ) )

////////////////
////////////////
//
// Purpose:
//    Command with ALIAS clause
//
// Syntax:
//    <command> ALIAS <cAlias>
//
// Description:
//    Adds ALIAS clause to command.  See CA-Clipper reference for information
//    about this command.  <cAlias> is the source work area and eliminates
//    the need to pre-SELECT the work area.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command DELETE               ALIAS <a>  =>  <a> -> ( dbDelete() )

////////////////
////////////////
//
// Purpose:
//    Command with ALIAS clause
//
// Syntax:
//    <command> ALIAS <cAlias>
//
// Description:
//    Adds ALIAS clause to command.  See CA-Clipper reference for information
//    about this command.  <cAlias> is the source work area and eliminates
//    the need to pre-SELECT the work area.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command RECALL               ALIAS <a>  =>  <a> -> ( dbRecall() )

////////////////
////////////////
//
// Purpose:
//    Command with ALIAS clause
//
// Syntax:
//    <command> ALIAS <cAlias>
//
// Description:
//    Adds ALIAS clause to command.  See CA-Clipper reference for information
//    about this command.  <cAlias> is the source work area and eliminates
//    the need to pre-SELECT the work area.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SORT [TO <(file)>] [ON <fields,...>]                           ;
         [FOR <for>]                                                    ;
         [WHILE <while>]                                                ;
         [NEXT <next>]                                                  ;
         [RECORD <rec>]                                                 ;
         [<rest:REST>]                                                  ;
         [ALL]                                                          ;
         ALIAS <a>                                                      ;
      => <a> -> ( __dbSort(                                                      ;
                   <(file)>, { <(fields)> },                            ;
                   <{for}>, <{while}>, <next>, <rec>, <.rest.>          ;
                 ) )

////////////////
////////////////
//
// Purpose:
//    Command with ALIAS clause
//
// Syntax:
//    <command> ALIAS <cAlias>
//
// Description:
//    Adds ALIAS clause to command.  See CA-Clipper reference for information
//    about this command.  <cAlias> is the source work area and eliminates
//    the need to pre-SELECT the work area.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command TOTAL [TO <(file)>] [ON <key>]                                 ;
         [FIELDS <fields,...>]                                          ;
         [FOR <for>]                                                    ;
         [WHILE <while>]                                                ;
         [NEXT <next>]                                                  ;
         [RECORD <rec>]                                                 ;
         [<rest:REST>]                                                  ;
         [ALL]                                                          ;
         ALIAS <a>                                                      ;
      => <a> -> ( __dbTotal(                                                     ;
                    <(file)>, <{key}>, { <(fields)> },                  ;
                    <{for}>, <{while}>, <next>, <rec>, <.rest.>         ;
                  ) )

////////////////
////////////////
//
// Purpose:
//    Command with ALIAS clause
//
// Syntax:
//    <command> ALIAS <cAlias>
//
// Description:
//    Adds ALIAS clause to command.  See CA-Clipper reference for information
//    about this command.  <cAlias> is the source work area and eliminates
//    the need to pre-SELECT the work area.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command UPDATE [FROM <(alias)>] [ON <key>]                             ;
         [REPLACE <f1> WITH <x1> [, <fn> WITH <xn>]]                    ;
         [<rand:RANDOM>]                                                ;
         ALIAS <a>                                                      ;
      => <a> -> ( __dbUpdate(                                                    ;
                     <(alias)>, <{key}>, <.rand.>,                      ;
                     {|| _FIELD-><f1> := <x1> [, _FIELD-><fn> := <xn>]} ;
                   ) )

////////////////
////////////////
//
// Purpose:
//    Command with ALIAS clause
//
// Syntax:
//    <command> ALIAS <cAlias>
//
// Description:
//    Adds ALIAS clause to command.  See CA-Clipper reference for information
//    about this command.  <cAlias> is the source work area and eliminates
//    the need to pre-SELECT the work area.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command JOIN [WITH <(alias)>] [TO <file>]                              ;
         [FIELDS <fields,...>]                                          ;
         [FOR <for>]                                                    ;
         ALIAS <a>                                                      ;
      => <a> -> ( __dbJoin( <(alias)>, <(file)>, { <(fields)> }, <{for}> ) )

////////////////
////////////////
//
// Purpose:
//    Command with ALIAS clause
//
// Syntax:
//    <command> ALIAS <cAlias>
//
// Description:
//    Adds ALIAS clause to command.  See CA-Clipper reference for information
//    about this command.  <cAlias> is the source work area and eliminates
//    the need to pre-SELECT the work area.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command COUNT [TO <var>]                                               ;
         [FOR <for>]                                                    ;
         [WHILE <while>]                                                ;
         [NEXT <next>]                                                  ;
         [RECORD <rec>]                                                 ;
         [<rest:REST>]                                                  ;
         [ALL]                                                          ;
         ALIAS <a>                                                      ;
      => <var> := 0                                                     ;
       ; <a> -> ( DBEval(                                                        ;
                 {|| <var> := <var> + 1},                               ;
                 <{for}>, <{while}>, <next>, <rec>, <.rest.>            ;
               ) )

////////////////
////////////////
//
// Purpose:
//    Command with ALIAS clause
//
// Syntax:
//    <command> ALIAS <cAlias>
//
// Description:
//    Adds ALIAS clause to command.  See CA-Clipper reference for information
//    about this command.  <cAlias> is the source work area and eliminates
//    the need to pre-SELECT the work area.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SUM [ <x1> [, <xn>]  TO  <v1> [, <vn>] ]                       ;
         [FOR <for>]                                                    ;
         [WHILE <while>]                                                ;
         [NEXT <next>]                                                  ;
         [RECORD <rec>]                                                 ;
         [<rest:REST>]                                                  ;
         [ALL]                                                          ;
         ALIAS <a>                                                      ;
      => <v1> := [ <vn> := ] 0                                          ;
       ; <a> -> ( DBEval(                                                        ;
                 {|| <v1> := <v1> + <x1> [, <vn> := <vn> + <xn> ]},     ;
                 <{for}>, <{while}>, <next>, <rec>, <.rest.>            ;
               ) )

////////////////
////////////////
//
// Purpose:
//    Command with ALIAS clause
//
// Syntax:
//    <command> ALIAS <cAlias>
//
// Description:
//    Adds ALIAS clause to command.  See CA-Clipper reference for information
//    about this command.  <cAlias> is the source work area and eliminates
//    the need to pre-SELECT the work area.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command AVERAGE [ <x1> [, <xn>]  TO  <v1> [, <vn>] ]                   ;
         [FOR <for>]                                                    ;
         [WHILE <while>]                                                ;
         [NEXT <next>]                                                  ;
         [RECORD <rec>]                                                 ;
         [<rest:REST>]                                                  ;
         [ALL]                                                          ;
         ALIAS <a>                                                      ;
      => M->__Avg := <v1> := [ <vn> := ] 0                              ;
                                                                        ;
       ; <a> -> ( DBEval(                                                        ;
                 {|| M->__Avg := M->__Avg + 1,                          ;
                 <v1> := <v1> + <x1> [, <vn> := <vn> + <xn>] },         ;
                 <{for}>, <{while}>, <next>, <rec>, <.rest.>            ;
               )                                                        ;
                                                                        ;
       ; <v1> := <v1> / M->__Avg [; <vn> := <vn> / M->__Avg ]

////////////////
////////////////
//
// Purpose:
//    Command with ALIAS clause
//
// Syntax:
//    <command> ALIAS <cAlias>
//
// Description:
//    Adds ALIAS clause to command.  See CA-Clipper reference for information
//    about this command.  <cAlias> is the source work area and eliminates
//    the need to pre-SELECT the work area.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command LIST [<list,...>]                                              ;
         [<off:OFF>]                                                    ;
         [<toPrint: TO PRINTER>]                                        ;
         [TO FILE <(toFile)>]                                           ;
         [FOR <for>]                                                    ;
         [WHILE <while>]                                                ;
         [NEXT <next>]                                                  ;
         [RECORD <rec>]                                                 ;
         [<rest:REST>]                                                  ;
         [ALL]                                                          ;
         ALIAS <a>                                                      ;
      => <a> -> ( __dbList(                                                      ;
                   <.off.>, { <{list}> }, .t.,                          ;
                   <{for}>, <{while}>, <next>, <rec>, <.rest.>,         ;
                   <.toPrint.>, <(toFile)>                              ;
                 ) )

////////////////
////////////////
//
// Purpose:
//    Command with ALIAS clause
//
// Syntax:
//    <command> ALIAS <cAlias>
//
// Description:
//    Adds ALIAS clause to command.  See CA-Clipper reference for information
//    about this command.  <cAlias> is the source work area and eliminates
//    the need to pre-SELECT the work area.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command DISPLAY [<list,...>]                                           ;
         [<off:OFF>]                                                    ;
         [<toPrint: TO PRINTER>]                                        ;
         [TO FILE <(toFile)>]                                           ;
         [FOR <for>]                                                    ;
         [WHILE <while>]                                                ;
         [NEXT <next>]                                                  ;
         [RECORD <rec>]                                                 ;
         [<rest:REST>]                                                  ;
         [<all:ALL>]                                                    ;
         ALIAS <a>                                                      ;
      => <a> -> ( __DBList(                                                      ;
                   <.off.>, { <{list}> }, <.all.>,                      ;
                   <{for}>, <{while}>, <next>, <rec>, <.rest.>,         ;
                   <.toPrint.>, <(toFile)>                              ;
                 ) )

////////////////
////////////////
//
// Purpose:
//    Command with ALIAS clause
//
// Syntax:
//    <command> ALIAS <cAlias>
//
// Description:
//    Adds ALIAS clause to command.  See CA-Clipper reference for information
//    about this command.  <cAlias> is the source work area and eliminates
//    the need to pre-SELECT the work area.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command REPORT FORM <frm>                                              ;
         [HEADING <heading>]                                            ;
         [<plain: PLAIN>]                                               ;
         [<noeject: NOEJECT>]                                           ;
         [<summary: SUMMARY>]                                           ;
         [<noconsole: NOCONSOLE>]                                       ;
         [<print: TO PRINTER>]                                          ;
         [TO FILE <(toFile)>]                                           ;
         [FOR <for>]                                                    ;
         [WHILE <while>]                                                ;
         [NEXT <next>]                                                  ;
         [RECORD <rec>]                                                 ;
         [<rest:REST>]                                                  ;
         [ALL]                                                          ;
         ALIAS <a>                                                      ;
      => <a> -> ( __ReportForm(                                                  ;
                       <(frm)>, <.print.>, <(toFile)>, <.noconsole.>,   ;
                       <{for}>, <{while}>, <next>, <rec>, <.rest.>,     ;
                       <.plain.>, <heading>,                            ;
                       <.noeject.>, <.summary.>                         ;
                     ) )

////////////////
////////////////
//
// Purpose:
//    Command with ALIAS clause
//
// Syntax:
//    <command> ALIAS <cAlias>
//
// Description:
//    Adds ALIAS clause to command.  See CA-Clipper reference for information
//    about this command.  <cAlias> is the source work area and eliminates
//    the need to pre-SELECT the work area.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command LABEL FORM <lbl>                                               ;
         [<sample: SAMPLE>]                                             ;
         [<noconsole: NOCONSOLE>]                                       ;
         [<print: TO PRINTER>]                                          ;
         [TO FILE <(toFile)>]                                           ;
         [FOR <for>]                                                    ;
         [WHILE <while>]                                                ;
         [NEXT <next>]                                                  ;
         [RECORD <rec>]                                                 ;
         [<rest:REST>]                                                  ;
         [ALL]                                                          ;
         ALIAS <a>                                                      ;
      => <a> -> ( __LabelForm(                                                   ;
                      <(lbl)>, <.print.>, <(toFile)>, <.noconsole.>,    ;
                      <{for}>, <{while}>, <next>, <rec>, <.rest.>,      ;
                      <.sample.>                                        ;
                    ) )

// NOTE:  CLOSE <alias> must precede the others
#command CLOSE <alias>          => <alias>->( dbCloseArea() )

#command CLOSE                  => dbCloseArea()
#command CLOSE DATABASES        => dbCloseAll()
#command CLOSE ALTERNATE        => Set(_SET_ALTFILE, "")
#command CLOSE FORMAT           => __SetFormat(NIL)
#command CLOSE INDEXES          => dbClearIndex()
#command CLOSE INDEXES ALIAS <a> => <a> -> (dbClearIndex())

////////////////
////////////////
//
// Purpose:
//    Command with ALIAS clause
//
// Syntax:
//    <command> ALIAS <cAlias>
//
// Description:
//    Adds ALIAS clause to command.  See CA-Clipper reference for information
//    about this command.  <cAlias> is the source work area and eliminates
//    the need to pre-SELECT the work area.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command CLOSE ALIAS <a>        => <a> -> (dbCloseArea())
#command CLOSE PROCEDURE        =>

#command CLOSE ALL                                                      ;
                                                                        ;
      => CLOSE DATABASES                                                ;
       ; SELECT 1                                                       ;
       ; CLOSE FORMAT

/* SETs with SAVE TO clauses */

#include "set.ch"

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET EXACT <x:ON,OFF,&>                     SAVE TO <y>         ;
      => <y> := Set( _SET_EXACT, <(x)> )

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET EXACT (<x>)                            SAVE TO <y>         ;
      => <y> := Set( _SET_EXACT, <x> )

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET FIXED <x:ON,OFF,&>                     SAVE TO <y>         ;
      => <y> := Set( _SET_FIXED, <(x)> )

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET FIXED (<x>)                            SAVE TO <y>         ;
      => <y> := Set( _SET_FIXED, <x> )

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET DECIMALS TO <x>                        SAVE TO <y>         ;
      => <y> := Set( _SET_DECIMALS, <x> )

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET DECIMALS TO                            SAVE TO <y>         ;
      => <y> := Set( _SET_DECIMALS, 0 )

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET PATH TO <*path*>                       SAVE TO <y>         ;
      => <y> := Set( _SET_PATH, <(path)> )

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET PATH TO                                SAVE TO <y>         ;
      => <y> := Set( _SET_PATH, "" )

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET DEFAULT TO <(path)>                    SAVE TO <y>         ;
      => <y> := Set( _SET_DEFAULT, <(path)> )

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET DEFAULT TO                             SAVE TO <y>         ;
      => <y> := Set( _SET_DEFAULT, "" )

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET CENTURY <x:ON,OFF,&>                   SAVE TO <y>         ;
      => <y> := __SetCentury( <(x)> )

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET CENTURY (<x>)                          SAVE TO <y>         ;
      => <y> := __SetCentury( <x> )

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET EPOCH TO <year>                        SAVE TO <y>         ;
      => <y> := Set( _SET_EPOCH, <year> )

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET DATE FORMAT [TO] <c>                   SAVE TO <y>         ;
      => <y> := Set( _SET_DATEFORMAT, <c> )

#define  _DFSETA(x, z)  <y> := Set(_SET_DATEFORMAT, iif(__SetCentury(), x, z))

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET DATE [TO] AMERICAN                     SAVE TO <y>         ;
      => _DFSETA( "mm/dd/yyyy", "mm/dd/yy" )

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET DATE [TO] ANSI                         SAVE TO <y>         ;
      => _DFSETA( "yyyy.mm.dd", "yy.mm.dd" )

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET DATE [TO] BRITISH                      SAVE TO <y>         ;
      => _DFSETA( "dd/mm/yyyy", "dd/mm/yy" )

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET DATE [TO] FRENCH                       SAVE TO <y>         ;
      => _DFSETA( "dd/mm/yyyy", "dd/mm/yy" )

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET DATE [TO] GERMAN                       SAVE TO <y>         ;
      => _DFSETA( "dd.mm.yyyy", "dd.mm.yy" )

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET DATE [TO] ITALIAN                      SAVE TO <y>         ;
      => _DFSETA( "dd-mm-yyyy", "dd-mm-yy" )

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET DATE [TO] JAPANESE                     SAVE TO <y>         ;
      => _DFSETA( "yyyy/mm/dd", "yy/mm/dd" )

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET DATE [TO] USA                          SAVE TO <y>         ;
      => _DFSETA( "mm-dd-yyyy", "mm-dd-yy" )

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET ALTERNATE <x:ON,OFF,&>                 SAVE TO <y>         ;
      => <y> := Set( _SET_ALTERNATE, <(x)> )

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET ALTERNATE (<x>)                        SAVE TO <y>         ;
      => <y> := Set( _SET_ALTERNATE, <x> )

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET ALTERNATE TO                           SAVE TO <y>         ;
      => <y> := Set( _SET_ALTFILE, "" )

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET ALTERNATE TO <(file)> [<add: ADDITIVE>] SAVE TO <y>        ;
      => <y> := Set( _SET_ALTFILE, <(file)>, <.add.> )

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET CONSOLE <x:ON,OFF,&>                   SAVE TO <y>         ;
      => <y> := Set( _SET_CONSOLE, <(x)> )

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET CONSOLE (<x>)                          SAVE TO <y>         ;
      => <y> := Set( _SET_CONSOLE, <x> )

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET MARGIN TO <x>                          SAVE TO <y>         ;
      => <y> := Set( _SET_MARGIN, <x> )

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET MARGIN TO                              SAVE TO <y>         ;
      => <y> := Set( _SET_MARGIN, 0 )

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET PRINTER <x:ON,OFF,&>                   SAVE TO <y>         ;
      => <y> := Set( _SET_PRINTER, <(x)> )

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET PRINTER (<x>)                          SAVE TO <y>         ;
      => <y> := Set( _SET_PRINTER, <x> )

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET PRINTER TO                             SAVE TO <y>         ;
      => <y> := Set( _SET_PRINTFILE, "" )

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET PRINTER TO <(file)> [<add: ADDITIVE>]  SAVE TO <y>         ;
      => <y> := Set( _SET_PRINTFILE, <(file)>, <.add.> )

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET DEVICE TO SCREEN                       SAVE TO <y>         ;
      => <y> := Set( _SET_DEVICE, "SCREEN" )

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET DEVICE TO PRINTER                      SAVE TO <y>         ;
      => <y> := Set( _SET_DEVICE, "PRINTER" )

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET COLOR TO [<*spec*>]                    SAVE TO <y>         ;
      => <y> := SetColor( #<spec> )

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET COLOR TO ( <c> )                       SAVE TO <y>         ;
      => <y> := SetColor( <c> )

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET COLOUR TO <*spec*>                     SAVE TO <y>         ;
      => SET COLOR TO <spec> SAVE TO <y>

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET CURSOR <x:ON,OFF,&>                    SAVE TO <y>         ;
      => <y> := SetCursor( if(Upper(<(x)>) == "ON", 1, 0) )

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET CURSOR (<x>)                           SAVE TO <y>         ;
      => <y> := SetCursor( if(<x>, 1, 0) )

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET BELL <x:ON,OFF,&>                      SAVE TO <y>         ;
      => <y> := Set( _SET_BELL, <(x)> )

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET BELL (<x>)                             SAVE TO <y>         ;
      => <y> := Set( _SET_BELL, <x> )

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET CONFIRM <x:ON,OFF,&>                   SAVE TO <y>         ;
      => <y> := Set( _SET_CONFIRM, <(x)> )

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET CONFIRM (<x>)                          SAVE TO <y>         ;
      => <y> := Set( _SET_CONFIRM, <x> )

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET ESCAPE <x:ON,OFF,&>                    SAVE TO <y>         ;
      => <y> := Set( _SET_ESCAPE, <(x)> )

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET ESCAPE (<x>)                           SAVE TO <y>         ;
      => <y> := Set( _SET_ESCAPE, <x> )

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET INTENSITY <x:ON,OFF,&>                 SAVE TO <y>         ;
      => <y> := Set( _SET_INTENSITY, <(x)> )

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET INTENSITY (<x>)                        SAVE TO <y>         ;
      => <y> := Set( _SET_INTENSITY, <x> )

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET SCOREBOARD <x:ON,OFF,&>                SAVE TO <y>         ;
      => <y> := Set( _SET_SCOREBOARD, <(x)> )

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET SCOREBOARD (<x>)                       SAVE TO <y>         ;
      => <y> := Set( _SET_SCOREBOARD, <x> )

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET DELIMITERS <x:ON,OFF,&>                SAVE TO <y>         ;
      => <y> := Set( _SET_DELIMITERS, <(x)> )

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET DELIMITERS (<x>)                       SAVE TO <y>         ;
      => <y> := Set( _SET_DELIMITERS, <x> )

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET DELIMITERS TO <c>                      SAVE TO <y>         ;
      => <y> := Set( _SET_DELIMCHARS, <c> )

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET DELIMITERS TO DEFAULT                  SAVE TO <y>         ;
      => <y> := Set( _SET_DELIMCHARS, "::" )

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET DELIMITERS TO                          SAVE TO <y>         ;
      => <y> := Set( _SET_DELIMCHARS, "::" )

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET WRAP <x:ON,OFF,&>                      SAVE TO <y>         ;
      => <y> := Set( _SET_WRAP, <(x)> )

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET WRAP (<x>)                             SAVE TO <y>         ;
      => <y> := Set( _SET_WRAP, <x> )

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET MESSAGE TO <n> [<cent: CENTER, CENTRE>] SAVE TO <y>        ;
      => <y> := {Set( _SET_MESSAGE, <n> ), Set( _SET_MCENTER, <.cent.> ) }

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET MESSAGE TO                             SAVE TO <y>         ;
      => <y> := {Set( _SET_MESSAGE, 0 ), Set( _SET_MCENTER, .f. ) }

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET TYPEAHEAD TO <n>                       SAVE TO <y>         ;
      => <y> := Set( _SET_TYPEAHEAD, <n> )

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET KEY <n> TO <proc>                      SAVE TO <y>         ;
      => <y> := SetKey( <n>, {|p, l, v| <proc>(p, l, v)} )

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET KEY <n> TO <proc> ( [<list,...>] )     SAVE TO <y>         ;
      => SET KEY <n> TO <proc> SAVE TO <y>

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET KEY <n> [TO]                           SAVE TO <y>         ;
      => <y> := SetKey( <n>, NIL )

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET FUNCTION <n> [TO] [<c>]                SAVE TO <y>         ;
      => <y> := __SetFunction( <n>, <c> )

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET EXCLUSIVE <x:ON,OFF,&>                 SAVE TO <y>         ;
      =>  <y> := Set( _SET_EXCLUSIVE, <(x)> )

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET EXCLUSIVE (<x>)                        SAVE TO <y>         ;
      =>  <y> := Set( _SET_EXCLUSIVE, <x> )

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET SOFTSEEK <x:ON,OFF,&>                  SAVE TO <y>         ;
      =>  <y> := Set( _SET_SOFTSEEK, <(x)> )

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET SOFTSEEK (<x>)                         SAVE TO <y>         ;
      =>  <y> := Set( _SET_SOFTSEEK, <x> )

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET UNIQUE <x:ON,OFF,&>                    SAVE TO <y>         ;
      =>  <y> := Set( _SET_UNIQUE, <(x)> )

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET UNIQUE (<x>)                           SAVE TO <y>         ;
      =>  <y> := Set( _SET_UNIQUE, <x> )

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET DELETED <x:ON,OFF,&>                   SAVE TO <y>         ;
      =>  <y> := Set( _SET_DELETED, <(x)> )

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET DELETED (<x>)                          SAVE TO <y>         ;
      =>  <y> := Set( _SET_DELETED, <x> )

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET ORDER TO <n>                           SAVE TO <y>         ;
      => <y> := dbSetOrder( <n> )

////////////////
////////////////
//
// Purpose:
//    SET Command with SAVE TO clause
//
// Syntax:
//    <command> SAVE TO <cMamVar>
//
// Description:
//    Saves the previous value of the SET command to <cMemVar>.
//
// Category:
//    Command Enhancement
//
// Revisions:
//    01/26/94 Added comment blocks
//
////////////////
////////////////

#command SET ORDER TO                               SAVE TO <y>         ;
      => <y> := dbSetOrder(0)

