#INCLUDE "CLASSY2.CH"
#INCLUDE "FUNCKY.CH"


//  Class Ŀ
//          Name: KeyCounter                                                 
//   Description: Wrapper class for key value and counter.                   
//        Author: Chris Pels                                                 
//  Date created: 04-15-94              Date updated: 04-15-94              
//  Time created: 03:02:01pm            Time updated: 03:02:01pm            
//     Copyright: Greenwich Bay Technologies, Inc.                           
// Ĵ
//  Parent class: None                                                       
//      See Also:                                                            
// 
CREATE CLASS KeyCounter

PROTECTED:

	VAR oCounter                         // Counter object.

EXPORT:

	VAR cKey READONLY                    // Unique key for counter.

	MESSAGE Inc TO oCounter              // Route messages to counter object.
	MESSAGE Dec TO oCounter
	MESSAGE Reset TO oCounter
	MESSAGE Assign TO oCounter
	MESSAGE Get TO oCounter
	METHOD Init

END CLASS

//  Method Ŀ
//          Name: Init()                                                     
//   Description: Package key value and counter object together.             
//        Author: Chris Pels                                                 
//  Date created: 04-15-94              Date updated: 04-15-94              
//  Time created: 03:02:39pm            Time updated: 03:02:39pm            
//     Copyright: Greenwich Bay Technologies, Inc.                           
// Ĵ
//     Arguments: cKey                                                       
//              : oCounter                                                   
//  Return Value: (self)                                                   
//      See Also:                                                            
// 
METHOD Init( cKey, oCounter )

	::cKey := cKey
	::oCounter := oCounter

RETURN (self)
