#INCLUDE "CLASSY2.CH"
#INCLUDE "FUNCKY.CH"


//  Class Ŀ
//          Name: CntFullASCII                                               
//   Description: Counter using the full ASCII character set.                
//        Author: Chris Pels                                                 
//  Date created: 04-13-94              Date updated: 04-13-94              
//  Time created: 03:02:14pm            Time updated: 03:02:14pm            
//     Copyright: Greenwich Bay Technologies                                 
// Ĵ
//  Parent class: CntASCII                                                   
//      See Also:                                                            
// 
//       History: $History: CNTFULL.PRG $
/**/
/******************  Version 3  ******************/
/*User: Chris        Date: 5/03/94    Time: 1:28p */
/*Updated in /GBTLib*/
/*Added History keyword for version control and changed copyright to GBT.*/
/**/
/******************  Version 2  ******************/
/*User: Chris        Date: 5/02/94    Time: 3:09p */
/*Updated in /GBTLib*/
/*Standardized and improved documentation.*/
//
CREATE CLASS CntFullASCII INHERIT CntASCII

PROTECTED:

	METHOD LastASCII                     // Determines last ASCII character.
	METHOD NextASCII                     // Determines next ASCII character.

EXPORT:

	METHOD Init
	METHOD Reset                      // Resets to first ASCII character.

END CLASS

//  Method Ŀ
//          Name: Init()                                                     
//   Description: Initializes the counter.                                   
//        Author: Chris Pels                                                 
//  Date created: 04-13-94              Date updated: 04-13-94              
//  Time created: 03:02:39pm            Time updated: 03:02:39pm            
//     Copyright: Greenwich Bay Technologies                                 
// Ĵ
//     Arguments: cInitial                                                   
//  Return Value: (self)                                                   
//      See Also:                                                            
// 
METHOD Init( cInitial ),( cInitial )
RETURN (self)

//  Method Ŀ
//          Name: LastASCII()                                                
//   Description: Determines the last ASCII counter.                         
//        Author: Chris Pels                                                 
//  Date created: 04-13-94              Date updated: 04-13-94              
//  Time created: 03:02:48pm            Time updated: 03:02:48pm            
//     Copyright: Greenwich Bay Technologies                                 
// Ĵ
//     Arguments: cChar                                                      
//  Return Value: @( if@( ASC@( cChar @) >= 255, @.T@., @.F@. @) @)                    
//      See Also:                                                            
// 
METHOD LastASCII( cChar )
RETURN( if( ASC( cChar ) >= 255, .T., .F. ) )

//  Method Ŀ
//          Name: Reset()                                                 
//   Description: Resets to the first ASCII character.                       
//        Author: Chris Pels                                                 
//  Date created: 04-13-94              Date updated: 04-13-94              
//  Time created: 03:03:00pm            Time updated: 03:03:00pm            
//     Copyright: Greenwich Bay Technologies                                 
// Ĵ
//     Arguments: None                                                       
//  Return Value: @( CHR@(1@) @)                                              
//      See Also:                                                            
// 
METHOD Reset()
RETURN ( CHR(1) )

//  Method Ŀ
//          Name: NextASCII()                                                
//   Description: Increments to the next ASCII character.                    
//        Author: Chris Pels                                                 
//  Date created: 04-13-94              Date updated: 04-13-94              
//  Time created: 03:03:17pm            Time updated: 03:03:17pm            
//     Copyright: Greenwich Bay Technologies                                 
// Ĵ
//     Arguments: cChar                                                      
//  Return Value: @( chr@( @(asc@(cChar@)@+1@) @) @)                                  
//      See Also:                                                            
// 
METHOD NextASCII( cChar )
RETURN ( chr( (asc(cChar)+1) ) )


