// Program 
//  Application: UMA MCAPTURE/Manager System
//  Description: Windows Task Scheduler
//    File Name: BACKGRD.PRG
//       Author: Darren Forcier
// Date created: 09-03-93              Date updated: 09-03-93
// Time created: 10:50:31am            Time updated: 10:50:31am
//    Make File: MAKEFILE.MAK
//    Exec File: MCAPMGR.EXE           Docs By: Darren Forcier
//    Copyright: (c) 1993 by Forcier Computer Services
//
                                                 && SourceNotes                                                                                                                                                                                               WIPMaking some good headway with Dynamic Dialogs. Have abasic prototype shell of an Add/Edit/Delete Window upand running.  Now I need to connect it to thedatabase and put in some fancy whizbang messageboxesto confirm deletes, etc.  Progress is going extremelywell.

/*
    This source code is for the use of the Aquarium subscribers, who may
    include it in their applications as they see fit.  Distribution and
    duplication by any means, (except for Ted of course), including
    printed and electronic, is prohibited without the express written
    consent of Grumpfish, Inc.
*/
#define WIN_WANT_ALL            // make sure we get all the #defines
#define APP_NAME       "test"
#include "windows.ch"
#include "dialog.ch"
#include "say.ch"
#include "setcurs.ch"
#include "backgrd.ch"
#include "common.ch"

#define TIMER_HANDLE   1        // Timer Handle (can have up to 16 of them!)
#define TIMER_INTERVAL 60000    // Approximately 60 seconds
#define PROGRAM        1        // Program array slot
#define STARTTIME      2        // Start Time array slot
#define ISRUNNING      3        // Is task already running?
#define OK_EXEC        32       // Threshold for WinExec() error return codes
#define IDI_ICON1      101

#define MINUTES(cTime) VAL(SUBSTR(cTime,1,2)) * 60 + VAL(SUBST(cTime,3,2))

STATIC aSchedule := {}          // Scheduler Array
STATIC hDlg                     // Modeless dialog box handle
STATIC hWnd                     // handle to main window
STATIC hWndDlg                  // handle to Window Dialog
STATIC hInst                    // Instance of previous window (if any)
STATIC nACurrent := 0
STATIC hDbug                    // Handle to a debugging output window
STATIC SAYLIST   := {}
STATIC lUpdate
STATIC aDlg := {}

FUNCTION MAIN()

   LOCAL nEvent                 // Last Windows event tracked
   LOCAL nTimerHandle           // Timer handle returned
   LOCAL hDC                    // Handle to Device Context
   LOCAL hIcon                  // Reference to internal icon
   LOCAL nRet                   // Return value from MessageBox()
   LOCAL aMenu
   LOCAL nCursor := SETCURSOR(SC_NONE)

   altd()

   hWnd := WinSetup( APP_NAME, "UMA Manager Windows Scheduler")
   //                 , 50, 50, 640, 480, NIL, NIL, WHITE_BRUSH )


   MenuSetup(hWnd,@aMenu)

   hInst := _GetInstance()  // Get Previous Instance (if any)


   hDbug := WinNew( "Debugging Output",;
                     0, 0, 350, 250,WS_OVERLAPPEDWINDOW)

   ShowWindow(hDBUG,SW_SHOWNORMAL)

   @ 10,10 say "Hello world, hDBUG="+str(hDBUG) IN WINDOW hDBUG

   //hIcon := LoadIcon(hInst,"icon")

   hDC   := GetDC(hWnd)     // Get Device Context

   // Minimize the Window first...  (use SW_MINIMIZE later on..)
   ShowWindow(hWnd,SW_SHOWNORMAL)
   ShowWindow(hDBUG,SW_SHOWNORMAL)

   // Set up a background event timer
   nTimerHandle := SetTimer(hWnd,TIMER_HANDLE,TIMER_INTERVAL)

   // Do initial display of scheduled items
   ShowSched(aSchedule,hWnd,hDC)

   // Main Event Loop
   WHILE  (nEvent := CHKEVENT()) != EVENT_QUIT

      TextOut(hDC,400,100, "Current Time: "+Time())

      UpdateWindow(hWnd)

      DO CASE
         CASE nEvent == EVENT_TIMER .and. _lastwParam() == TIMER_HANDLE
              ShowSched(aSchedule,hWnd,hDC)
              AEVAL(aSchedule,{|ele,n| TimeCheck(ele,hDC) })

      ENDCASE

   END

   // Kill the timer
   KillTimer(hWnd,nTimerHandle)

   SETCURSOR(nCursor)

RETURN NIL


// Function 
//         Name: GetSchedule()         Docs: Darren Forcier
//  Description: Open up SCHEDULR.DBF and collect scheduling array
//       Author: Darren Forcier
// Date created: 09-03-93              Date updated: 09-03-93
// Time created: 11:07:20am            Time updated: 11:07:20am
//    Copyright: Utilization Management Associates
//
//    Arguments: aSchedule
// Return Value: NIL
//     See Also:
//
STATIC FUNCTION GetSchedule(aSchedule)

   USE SCHEDULR NEW SHARED ALIAS SCHED
   SCHED->(dbEval({|| AADD(aSchedule,{SCHED->ProgName,SCHED->StartTime,.F.}) }))
   SCHED->(dbCloseArea())

RETURN NIL


STATIC FUNCTION PutSchedule(aSchedule)

   USE SCHEDULR NEW SHARED ALIAS SCHED
   SCHED->(dbEval({|| SCHED->Progname := aSchedule[RECNO(),1],;
                      SCHED->StartTime := aSchedule[RECNO(),2]  }))
   SCHED->(dbCloseArea())

RETURN NIL


// Function 
//         Name: TimeCheck()           Docs: Darren Forcier
//  Description: Check event's scheduled time against current time
//       Author: Darren Forcier
// Date created: 09-03-93              Date updated: 09-03-93
// Time created: 10:50:02am            Time updated: 10:50:02am
//    Copyright: Utilization Management Associates
//
//    Arguments: cProgram
//             : cTime
//             : cStartTime
// Return Value: None
//
STATIC FUNCTION TimeCheck(aPacket,hDC)

   LOCAL cGetTime
   LOCAL nStatus

   cGetTime := TIME()
   cGetTime := SUBSTR(cGetTime,1,2)+SUBSTR(cGetTime,4,2)

   // Check current time against start time for process
   IF ( MINUTES(cGetTime) == MINUTES(aPacket[STARTTIME]) .AND.;
        !aPacket[ISRUNNING])

      IF (nStatus := WINEXEC(aPacket[PROGRAM])) < OK_EXEC  // Uh Oh... Error!
         TextOut(100,100,"Something Bad Has Happened. Error Code is: "+;
                 ALLTRIM(STR(nStatus)))
      ELSE
         aPacket[ISRUNNING] := .T.            // Mark process as running
      ENDIF

   ENDIF

RETURN NIL

// Function 
//         Name: ShowSched()           Docs: Darren Forcier
//  Description: Show Schedule
//       Author: Darren Forcier
// Date created: 09-03-93              Date updated: 09-03-93
// Time created: 05:17:42pm            Time updated: 05:17:42pm
//    Copyright: Utilization Management Associates
//
//    Arguments: aSchedule - Scheduler Array
//             : hDC       - Handle to Device Context
// Return Value: None
//
STATIC FUNCTION ShowSched(aSchedule,hWnd,hDC)
   LOCAL i

   Textout(hDC,50,100,"Program"+SPACE(43)+' '+"Time    "+" "+"Running?")

   FOR i := 1 TO LEN(aSchedule)
       TextOut(hDC,50, (i * 30) + 130,;
               aSchedule[i][PROGRAM]+' '+;
               PADL(aSchedule[i][STARTTIME],8)+' '+;
               IIF(aSChedule[i][ISRUNNING],"Yes" ,"No" ))
   NEXT

   UpdateWindow(hWnd)

RETURN NIL



STATIC FUNCTION MenuSetup(hWnd,aMenu)

   LOCAL aPopupMenu

   aMenu      := CreateMenu()
   aPopupMenu := CreatePopupMenu()

   AppendMenu( aPopupMenu, "open", MF_ENABLED + MF_STRING,     ;
               "O&pen", {|cId| OpenFile() })

   AppendMenu( aPopupMenu, "exit", MF_ENABLED + MF_STRING,     ;
               "E&xit", {|cId| DoExit()} )

   AppendMenu( aMenu, "file", MF_ENABLED + MF_POPUP,           ;
                      "&File", aPopupMenu )

   aPopupMenu := CreatePopupMenu()

   AppendMenu( aPopupMenu, "add", MF_ENABLED + MF_STRING,   ;
                           "&Add", {|| AddRecord() })
   AppendMenu( aPopupMenu, "modify", MF_ENABLED + MF_STRING,;
                           "&Modify",{|| ModRecord() })
   AppendMenu( aPopupMenu, "delete", MF_ENABLED + MF_STRING,;
                           "&Delete", {|| DelRecord() })

   AppendMenu( aMenu, "edit", MF_ENABLED + MF_POPUP,           ;
                      "&Edit",aPopupMenu)

   SetMenu( hWnd, aMenu )

RETURN NIL


STATIC FUNCTION OpenFile()
   GetSchedule(aSchedule)       // Fill in scheduler array
   @ 13,10 say "OpenFile" IN WINDOW hDBUG
   PaintModalDialog()
   nAcurrent := 1
RETURN NIL

STATIC FUNCTION CloseFile()
   PutSchedule(aSchedule)
RETURN NIL

STATIC FUNCTION AddRecord()
   AADD(aSchedule,{space(50),space(4)})
   nACurrent++
   EditRecord()
   //
RETURN NIL

STATIC FUNCTION ModRecord()
   EditRecord()
RETURN NIL

STATIC FUNCTION DelRecord()
   ADEL(aSchedule,nACurrent)
   ASIZE(aSchedule,LEN(aSchedule)-1)
   nACurrent--
RETURN NIL

STATIC FUNCTION EditRecord()
RETURN NIL


STATIC FUNCTION PaintModalDialog()

   @ 15,10 say "PaintModalDialog" IN WINDOW hDBUG

/*
   Here is my first attempt at linking in the dlg dialog from test.rc
   No go, but at least this attempt isn't creating a GPF in USER.EXE...

   Why is hDlg always returning as a 0 though?  Very strange...

   MessageBox(,"hInst="+str(hInst))
   MessageBox(,"hWnd="+str(hWnd))

   hDlg := CreateDialog(hInst,"dlg", hWnd ,;
      { | hDlg, msg, wparam, lparam |      ;
      ResDlgModeless( hDlg, msg, wparam, lparam ) } )

   @ 17,10 say "hDlg = "+str(hDlg,10) IN WINDOW hDBUG
*/
   DynModeless()

RETURN NIL

/*
dlg DIALOG  6, 10, 185, 92
STYLE DS_MODALFRAME | WS_POPUP | WS_VISIBLE | WS_CAPTION | WS_SYSMENU
CAPTION "Dialog"
FONT 8, "MS Sans Serif"
BEGIN
    DEFPUSHBUTTON   "OK",IDOK,129,6,50,14
    PUSHBUTTON      "Cancel",IDCANCEL,129,23,50,14
    EDITTEXT        IDC_EDIT1,10,15,91,15,ES_AUTOHSCROLL
    PUSHBUTTON      "Next",IDC_BUTTON1,130,42,49,15
    PUSHBUTTON      "Prev",IDC_BUTTON2,131,62,48,15
    EDITTEXT        IDC_EDIT2,12,47,91,16,ES_UPPERCASE | ES_AUTOHSCROLL |
                    0x1000
END
*/

STATIC FUNCTION DynModeLess()

   LOCAL nDlgResult
   LOCAL button1
   LOCAL button2
   LOCAL button3
   LOCAL button4
   LOCAL cProgram
   LOCAL ctime
   LOCAL cText := SPACE(10)

   LOCAL lContinue := TRUE

   lUpdate := FALSE

   USE SCHEDULR NEW SHARED ALIAS SCHED

   SCHED->(dbGoTop())


   cProgram := TRIM(SCHED->progname)
   cTime    := SCHED->starttime

   hWndDlg := CreateDialog(hInst,"dlg",hWnd,;
           {|hDlg,nMsg,nwParam,nlParam| ;
                 ResDlgModeless(hDlg,nMsg,nwParam,nlParam) } )

   IF hWndDlg == 0
      @ 8,10 say "Bad Dialog Creation!"
   ENDIF

   @ 10,10 say "hWndDlg =" + STR(hWndDlg) IN WINDOW hDBUG
   // I know this routine is called DynModeless, but the
   // ModelessDialog() function seems to be either undocumented
   // or non-existant looking at John's Dialog.prg stuff. Is it
   // implemented in Clip4Win 1.2?

//   nDlgResult := ModalDialog(aDlg,,hWnd)

//    DO CASE
//       CASE nDlgResult == 0
//
//          lContinue := FALSE
//
//       CASE lUpdate
//       OTHERWISE
//          DO CASE
//             CASE GetDialogResult(aDlg,"Next")
//                SCHED->(DBSkip(1))
//                IF SCHED->(EOF())
//                   MessageBeep(MB_ICONEXCLAMATION)
//                   SCHED->(DBSkip(-1))
//                ENDIF
//             CASE GetDialogResult(aDlg,"Prev")
//                SCHED->(DBSkip(-1))
//                IF SCHED->(BOF())
//                   MessageBeep(MB_ICONEXCLAMATION)
//                   SCHED->(DBSkip(1))
//                ENDIF
//          ENDCASE
//    ENDCASE


   SCHED->(dbCloseArea())

RETURN NIL



FUNCTION ConfirmCancel(hDlg,nMsg,nwParam,nlParam)

   IF MessageBox(hDlg,"Really Cancel?","Cancel",MB_YESNO) == IDYES
      EndDialog(hDlg,0)
   ENDIF

RETURN TRUE


FUNCTION ConfirmWrite(hDlg,nMsg,nwParam,nlParam)

  IF lUpdate := (MessageBox(hDlg,"Really Overwrite?","Commit",MB_YESNO) == IDYES)

     IF SCHED->(RLock())
        //SCHED->progname  := GetDialogResult(aDlg,"edit1")
        //SCHED->starttime := GetDialogResult(aDlg,"edit2")
        @ 09,10 say GetDialogResult(aDlg,"edit1") IN WINDOW hDBUG
        @ 11,10 say GetDialogResult(aDlg,"edit2") IN WINDOW hDBUG
        SCHED->(dbCommit())
        SCHED->(dbUnlock())
     ELSE
        MessageBox(,"Can't Lock Record, sorry!","Lock Error")
     ENDIF

  ENDIF

RETURN lUpdate


FUNCTION DynMove(hDlg,nMsg,nwParam,nlParam,nDist)
   LOCAL nGoBack
   LOCAL bEval := {||  IIF(nDist>0, SCHED->(EOF()) ,SCHED->(BOF()) ) }

   SCHED->(dbSkip(nDist))


   IF EVAL(bEval)
      SCHED->(dbSkip(nDist * -1))
   ENDIF

RETURN TRUE


STATIC FUNCTION DoExit
   // Close Modal Dialog
   CLOSE DATABASE
   QUIT
RETURN NIL


FUNCTION ResDlgModeless( hWndDlg, nMsg, nwParam, nlParam )

   local     i, j
   local     GetList := {}        // NOTE: need to initialise like this
   local     cProg   :=  space(50)
   local     cTime   := space(4)
   local     lNext   := .F.
   local     lPrev   := .T.
   local     lOk     := .T.
   local     lCancel := .T.

   @ 16,10 say "Reached ResDlgModeless" IN WINDOW hDbug

   do case
      case nMsg == WM_INITDIALOG

         @ dialog hWndDlg id IDC_EDIT1   get cProg
         @ dialog hWndDlg id IDC_EDIT2   get cTime
         @ dialog hWndDlg id IDC_BUTTON1 get lNext
         @ dialog hWndDlg id IDC_BUTTON2 get lPrev
         @ dialog hWndDlg id IDOK        get lOk
         @ dialog hWndDlg id IDCANCEL    get lCancel

      case nMsg == WM_SYSCOMMAND
         @ 17,10 say "WM_SYSCOMMAND" IN WINDOW hDBUG
         if nwParam == SC_CLOSE
            CANCEL DIALOG hWndDlg
         endif

      case nMsg == WM_COMMAND
         @ 17,10 say "WM_COMMAND" IN WINDOW hDBUG

         do case
            case nwParam == IDOK             ;
                  .or. nWparam == IDOK               ;
                  .or. nWparam == IDYES

               if IsDialogOK(hWndDlg, nwParam)
                  DestroyWindow(hWndDlg)
               endif

            case nWparam == IDCANCEL         ;
                  .or. nWparam == IDABORT       ;
                  .or. nWparam == IDNO

               CANCEL DIALOG hWndDlg

               DestroyWindow(hWndDlg)

           case nWParam == IDC_BUTTON1
                SCHED->(DBSkip(1))
                IF SCHED->(EOF())
                   MessageBeep(MB_ICONEXCLAMATION)
                   SCHED->(DBSkip(-1))
                ENDIF
           case nWParam == IDC_BUTTON2
                SCHED->(DBSkip(-1))
                IF SCHED->(BOF())
                   MessageBeep(MB_ICONEXCLAMATION)
                   SCHED->(DBSkip(1))
                ENDIF
         endcase

         // Refresh the dialog from the array
   endcase

return .t.       // means msg has been processed


static function WinNew(cTitle, nX, nY, nWidth, nHeight, nStyle)
local hInst := _GetInstance()
local nCmdShow := _GetnCmdShow()
local hWin
if nStyle == NIL
   nStyle := WS_OVERLAPPEDWINDOW
endif
hWin := CreateWindow(APP_NAME,           ;       // window class
                    cTitle,              ;       // caption for title bar
                    nStyle,              ;       // window style
                    nX,                  ;       // x co-ordinate
                    nY,                  ;       // y co-ordinate
                    nWidth,              ;       // width
                    nHeight,             ;       // height
                    hWnd,                ;       // hWnd of parent
                    0,                   ;       // hMenu of menu (none yet)
                    hInst)                       // our own app instance
if hWin == 0
   // probably out of resources
   MessageBox( , "Can't create window", "Error", MB_ICONEXCLAMATION + MB_OK)
   return nil
endif
HideCaret(hWin)
// make sure it's displayed ...
ShowWindow(hWin, nCmdShow)
// ... and up to date
UpdateWindow(hWin)
return hWin


//
//                            EOF: BACKGRD.PRG
//
