// Program 
//  Application: Strada/Dolce Vita Excel DDE from Clipper Example
//  Description: This app is a simple DDE example showing how a Clipper app
//               can "talk" to Excel via Dynamic Data Exchange.  Basically
//               we input two numbers, fire them off into an Excel spreadsheet
//               which then adds the numbers up.  We then read the result
//               back into this application.
//
//               Interesting Dolce Vita Points:
//
//               1. This app can run as a simple DOS Clipper based app, no
//                  fancy Windows front end has to be provided.
//
//               2. Dolce Vita's ErrorSys codes aren't documented anywhere.
//                  This was really frustrating! !@**@*@
//
//               3. If you crash out too many times without executing the
//                  TerminateDDE() things get a might confused.  I had to
//                  bring Windows down a few times to untangle the DDE snarl.
//
//               4. Tried running Microsoft DDESpy to see what was happening
//                  behind the scenes but it didn't register anything going
//                  on.
//
//    File Name: TESTDV.PRG
//       Author: Darren Forcier
// Date created: 01-04-94              Date updated: 01-04-94
// Time created: 10:55:38pm            Time updated: 10:55:38pm
//    Make File: MAKEFILE.MAK
//    Exec File: CENSUS.EXE            Docs By: Darren Forcier
//    Copyright: (c) 1994 by Forcier Computer Services
//
#include "dolce.ch"

#define APP   1
#define TOPIC 2

FUNCTION MAIN()

   LOCAL cApplication  := "DFServer"
   LOCAL cTopic        := "GimmeANum"
   LOCAL nServCount
   LOCAL nError
   LOCAL nNum1         := 0.00
   LOCAL nNum2         := 0.00
   LOCAL aApp          := {}
   LOCAL aTemp         := {"",""}
   LOCAL I
   LOCAL hDDE
   LOCAL nErr
   LOCAL cTotal        := ""
   LOCAL cItem         := ""
   LOCAL cText         := space(10)
   LOCAL Getlist       := {}
   LOCAL bErrorBlock := ErrorBlock()


   ErrorBlock({|oError| MyErrBlock(oError,bErrorBlock) })

   nError := InitExec("TESTDV")


   // Scan all topics associated with Excel
   nServCount := ScanDDE("","")
   @ 20,10 say "ServerCount: "+alltrim(str(nServCount))

   CLS


   // Grab an array of specific topics. This will be scanned in the
   // the debugger to figure out whether Excel is loaded and what
   // the active topics are for Excel.  Under normal situations, Excel
   // provides all open worksheets as active topics, so you can "talk"
   // to specific worksheets.

   // The DV docs recommend running a EnumScanDDE() to scan all the
   // available topics.  Not sure why this is "recommended", but it
   // appears to be important if you have multiple DV apps doing DDE.

   FOR I := 1 TO nServCount
      EnumScanDDE(I,aTemp)
      AADD(aApp,{aTemp[APP],aTemp[TOPIC]})
   NEXT

   // Initialize conversation with Excel using Sheet1 Topic. Sheet1 is
   // the default worksheet that Excel opens up upon startup and should
   // be sufficient for this demo app.

   hDDE := InitiateDDE(cApplication,"GimmeANum")


   DDEStatus(hDDE,@nErr)

   // Poke some stuff into Excel via DDEPoke().  In order to converse
   // with Excel you need to talk to it in relative Row/Column offsets
   // within the spreadsheet.  You can't specifically refer to direct
   // cell addresses for some reason.  There is another method which
   // involves creating name ranges for cells which the Excel docs refer
   // to, but that involves a lot more work <g>.

   nError := RequestDDE(hDDE,"GimmeANum")

   cText := ReadDDEData(hDDE)

   DDEWaitLoop()

   @ 10,10 say "The Secret to the Universe is:"+cText
   // Terminate our DDE Link
   TerminateDDE(hDDE)

   EndExec()

RETURN NIL



// Function 
//         Name: DDEWaitLoop()         Docs: Darren Forcier
//  Description: Wait in infinite loop until DDE is un-busy
//       Author: Darren Forcier
// Date created: 01-04-94              Date updated: 01-04-94
// Time created: 11:18:40pm            Time updated: 11:18:40pm
//    Copyright: Forcier Computer Services, EngCo Technology, Inc.
//
//    Arguments: hDDE
// Return Value: NIL
//     See Also:
//
STATIC FUNCTION DDEWaitLoop(hDDE)
   LOCAL nStatus,nErr

   nStatus := DDEStatus(hDDE,@nErr)

   WHILE nStatus != DV_DDEFREE
      nStatus := DDEStatus(hDDE,@nStatus)
   END

RETURN NIL


STATIC FUNCTION MyErrBlock(oError,bErrBlock)

    EVAL(bErrBlock,oError)

RETURN NIL

