/*
      Program: DDETEST.PRG
      Author:  Andrew Kurtz
      Dialect: Clipper 5.01 (for use with Clip-4-Win)
      Notes:   Be sure to compile DDE.PRG and link in DDE.OBJ, because
               it contains the various DDE-related functions!!*/

  #include "windows.ch"
  #include "dde.ch"
  #include "say.ch"

  static  hWnd, hInst, hPrevInst, nCmdShow, hWndServer

  static saylist := {}

  function testdde
    local nEvent, cTime, cData, aData, nMsg, nAtom
    local cValue, hServer, cCell, nCr
    local n


    SET DEFAULT SAY FONT TO OEM_FIXED_FONT

    setcolor("n/w,w/n,w,w,w/n")
    hWnd = WinSetup( 'DDE test', 'DDE Test' )

    // set up the DDE link to Excel
    hWndServer := ddestart( hWnd, 'EXCEL', 'sheet1' )

    if hWndServer == nil
      messagebeep( MB_ICONEXCLAMATION )
      messagebox( hWnd, 'Unable To Establish DDE Link To Excel', ;
                  'DDE ERROR', MB_ICONEXCLAMATION )
    else
      // set up specific links to cells R1C1, R5C5, and R2C3
      ddeadvise( hWndServer, hWnd, , 'R1C1' )
      ddeadvise( hWndServer, hWnd, , 'R5C5' )
      ddeadvise( hWndServer, hWnd, , 'R2C3' )

      @ 10,10 say "Server      Cell       Value"
      @ 11,10 say "----------------------------"
      n := 12

      do while .t.
        nEvent := ChkEvent()
        do case
        case nEvent == EVENT_QUIT
          exit
        case nEvent == EVENT_OTHER
          nMsg := _lastmsg()
          do case
            case nMsg == WM_DDE_DATA
              hServer := _lastwparam()
              cData   := ddegetdata()
              aData   := bin2a( cData, 'string[ 28 ]' )
              nCr     := at( chr( 13 ), aData[ 1 ] )
              cValue  := left( aData[ 1 ], nCr - 1 )
              nAtom   := _lasthilParam()
              cCell   := globalgetatomname( nAtom )
              ? alltrim(str(hServer)),' ',cCell, cValue
          endcase
        endcase

        n++

        IF n == 15
           n:=12
        ENDIF

      enddo
      // terminate DDE links
      ddeunadvise( hWndServer, hWnd, , 'R1C1' )
      ddeunadvise( hWndServer, hWnd, , 'R5C5' )
      ddeunadvise( hWndServer, hWnd, , 'R2C3' )
      // terminate DDE conversation
      ddestop( hWndServer, hWnd )
    endif

  return nil

  // end of file DDETEST.PRG
