/*

  Program Ŀ
                                                                        
  File Name...: TIME.PRG                                                
  Author......: Vernon E. Six, Jr.                                      
  Date created: 02-20-94              Date updated: 07-31-94           
  Time created: 01:57:13pm            Time updated: 01:18:20am         
  CopyRight...: (c) 1994 by FrontLine Software                          
                                                                        
 
  

*/

static scBaseDate := "01/01/90"

// 123456789.12345

#include "BAS_VERN.CH"

// return a numeric value for a specified date and time
/* HYPERTEXT START
!short: basDateTime()   Return a numeric "date/time" value
basDateTime()   Return a numeric "date/time" value

^BDescription: ^B

   In my opinion, one of the major shortcomings of Clipper is its lack of
   ability to handle dates elegantly.  basDateTime() helps by returning a
   numeric value for a specified date and time value.


^BSyntax:^B

   nDateTime := basDateTime( [dDate], [cTime] )


^BPass:^B

   ^BdDate^B is an optional date expression that should contain the date
   you want to convert to a numeric date/time value.  If you don't pass
   ^BdDate^B, today's date is assumed.

   ^BcTime^B is an optional character expression that should contain a
   TIME() string for the time you want to convert to a numeric date/time
   value.  If you don't pass ^BcDate^B, the current value of TIME() is
   assumed.


^BReturns:^B

   ^BnDateTime^B is a numeric expression that will contain the date and
   time converted to a date/time numeric expression.  If you are going
   to store this variable to a database, the field should be defined as
   sixteen digits wide with five decimal places.


^BSource:^B

   TIME.PRG

HYPERTEXT END */
function basDateTime( pdSomeDate, pcTime )

   local nDays := 0
   local nSecs := 0

   assume pdSomeDate is date() if missing
   assume pcTime     is time() if missing

   nDays  := pdSomeDate - ctod(scBaseDate)
   nSecs  := val( substr(pcTime,1,2) ) * 3600 + ;
      val( substr(pcTime,4,2) ) * 60   + ;
      val( substr(pcTime,7,2) )

   return ( nDays + val( "." + StrZero(nSecs,5,0) ) )



/* HYPERTEXT START
!short: basGetDate()    Return a date value from a date/time numeric value
basGetDate()    Return a date value from a date/time numeric value

^BDescription: ^B

   basGetDate() will return a date expression from a date/time numeric
   expression.


^BSyntax:^B

   dDate := basGetDate( nDateTime )


^BPass:^B

   ^BnDateTime^B is a numeric expression that should contain the date/time
   value that you want to convert.


^BReturns:^B

   ^BdDate^B is a date expression that will contain the date portion of the
   ^BnDateTime^B date/time numeric expression.


^BSource:^B

   TIME.PRG

HYPERTEXT END */
function basGetDate( pnDateTime )

   return ( ctod(scBaseDate) + int(pnDateTime) )



/* HYPERTEXT START
!short: basGetTime()    Return a time value from a date/time numeric value
basGetTime()    Return a time value from a date/time numeric value

^BDescription: ^B

   basGetTime() will return a character expression that contains a TIME()
   string for the time portion of a date/time numeric expression.


^BSyntax:^B

   cTime := basGetDate( nDateTime )


^BPass:^B

   ^BnDateTime^B is a numeric expression that should contain the date/time
   value that you want to convert.


^BReturns:^B

   ^BcTime^B is a character expression that will contain a TIME() string for
   the time portion of the ^BnDateTime^B date/time numeric expression.


^BSource:^B

   TIME.PRG

HYPERTEXT END */
function basGetTime( pnDateTime ) // 795.24400

   local nSecs  := val( substr(StrZero(pnDateTime,15,5),11,5) ) // 24400
   local nHours := int( nSecs / 3600 ) // 6
   local nMins               // 0

   nSecs -= nHours * 3600    // 2800

   nMins := int( nSecs / 60 )// 46

   nSecs -= nMins * 60       // 40

   return (StrZero(nHours,2,0)+":"+StrZero(nMins,2,0)+":"+StrZero(nSecs,2,0) )




/* HYPERTEXT START
!short: basElapDays()   Get the number of days between two date/time values
basElapDays()   Get the number of days between two date/time values

^BDescription: ^B

   basElapDays() returns the number of days between two date/time numeric
   values.


^BSyntax:^B

   nDays := basElapDays( nDateTime1, nDateTime2 )


^BPass:^B

   ^BnDateTime1^B is a numeric expression that should contain the first
   date/time numeric value

   ^BnDateTime2^B is a numeric expression that should contain the second
   date/time numeric value


^BReturns:^B

   ^BnDays^B is a numeric expression that will contain the number of days
   between ^BnDateTime1^B and ^BnDateTime2^B.


^BSource:^B

   TIME.PRG

HYPERTEXT END */
function basElapDays( pnDT1, pnDT2 )

   return ( basElapSecs(pnDT1,pnDT2) / 86400 )



/* HYPERTEXT START
!short: basElapHours()  Get the number of hours between two date/time values
basElapHours()  Get the number of hours between two date/time values

^BDescription: ^B

   basElapHours() returns the number of hours between two date/time numeric
   values.


^BSyntax:^B

   nHours := basElapDays( nDateTime1, nDateTime2 )


^BPass:^B

   ^BnDateTime1^B is a numeric expression that should contain the first
   date/time numeric value

   ^BnDateTime2^B is a numeric expression that should contain the second
   date/time numeric value


^BReturns:^B

   ^BnHours^B is a numeric expression that will contain the number of hours
   between ^BnDateTime1^B and ^BnDateTime2^B.


^BSource:^B

   TIME.PRG

HYPERTEXT END */
function basElapHours( pnDT1, pnDT2 )

   return ( basElapSecs( pnDT1, pnDT2 ) / 3600 )



/* HYPERTEXT START
!short: basElapMins()   Get the number of minutes between two date/time values
basElapMins()   Get the number of minutes between two date/time values

^BDescription: ^B

   basElapMins() returns the number of minutes between two date/time numeric
   values.


^BSyntax:^B

   nMins := basElapDays( nDateTime1, nDateTime2 )


^BPass:^B

   ^BnDateTime1^B is a numeric expression that should contain the first
   date/time numeric value

   ^BnDateTime2^B is a numeric expression that should contain the second
   date/time numeric value


^BReturns:^B

   ^BnMins^B is a numeric expression that will contain the number of minutes
   between ^BnDateTime1^B and ^BnDateTime2^B.


^BSource:^B

   TIME.PRG

HYPERTEXT END */
function basElapMins( pnDT1, pnDT2 )

   return ( basElapSecs( pnDT1, pnDT2 ) / 60 )



/* HYPERTEXT START
!short: basElapSecs()   Get the number of seconds between two date/time values
basElapSecs()   Get the number of seconds between two date/time values

^BDescription: ^B

   basElapSecs() returns the number of seconds between two date/time numeric
   values.


^BSyntax:^B

   nSecs := basElapDays( nDateTime1, nDateTime2 )


^BPass:^B

   ^BnDateTime1^B is a numeric expression that should contain the first
   date/time numeric value

   ^BnDateTime2^B is a numeric expression that should contain the second
   date/time numeric value


^BReturns:^B

   ^BnSecs^B is a numeric expression that will contain the number of seconds
   between ^BnDateTime1^B and ^BnDateTime2^B.


^BSource:^B

   TIME.PRG

HYPERTEXT END */
function basElapSecs( pnDT1, pnDT2 )

   local nSecs1 := ( int( pnDT1 ) * 86400 ) + ( ( pnDT1 - int(pnDT1) ) * 100000 )
   local nSecs2 := ( int( pnDT2 ) * 86400 ) + ( ( pnDT2 - int(pnDT2) ) * 100000 )

   return ( abs( nSecs1 - nSecs2 ) )



/* HYPERTEXT START
!short: basAddSecs()    Add seconds to a date/time value
basAddSecs()    Add seconds to a date/time value

^BDescription: ^B

   basAddSecs() allows you to add seconds to a specified date/time numeric
   value.


^BSyntax:^B

   nNewDateTime := basAddSecs( nDateTime, nSecs )


^BPass:^B

   ^BnDateTime^B is a numeric expression that should contain the date/time
   numeric value that you want to add ^BnSecs^B to.

   ^BnSecs^B is a numeric expression that should contain the number of
   seconds that you want to add to ^BnDateTime^B.


^BReturns:^B

   ^BnNewDateTime^B is a numeric expression that will contain the numeric
   date/time value of ^BnDateTime^B plus ^BnSecs^B seconds.


^BSource:^B

   TIME.PRG

HYPERTEXT END */
function basAddSecs( pnDateTime, pnSecsToAdd )

   local dDate     := basGetDate( pnDateTime )
   local nSecs     := val( substr(StrZero(pnDateTime,15,5),11,5) ) + ;
      pnSecsToAdd

   while int(nSecs) > int(86399)
      nSecs -= 86400
      dDate++
   enddo

   while nSecs < 0
      nSecs += 86400
      dDate--
   enddo

   return ( ( dDate - ctod(scBaseDate) ) + val( "." + StrZero(nSecs,5,0)) )



/* HYPERTEXT START
!short: basAddMins()    Add minutes to a date/time value
basAddMins()    Add minutes to a date/time value

^BDescription: ^B

   basAddMins() allows you to add minutes to a specified date/time numeric
   value.


^BSyntax:^B

   nNewDateTime := basAddMins( nDateTime, nMins )


^BPass:^B

   ^BnDateTime^B is a numeric expression that should contain the date/time
   numeric value that you want to add ^BnSecs^B to.

   ^BnMins^B is a numeric expression that should contain the number of
   minutes that you want to add to ^BnDateTime^B.


^BReturns:^B

   ^BnNewDateTime^B is a numeric expression that will contain the numeric
   date/time value of ^BnDateTime^B plus ^BnMins^B minutes.


^BSource:^B

   TIME.PRG

HYPERTEXT END */
function basAddMins( pnDateTime, pnMinsToAdd )

   local dDate     := basGetDate( pnDateTime )
   local nSecs     := val( substr(StrZero(pnDateTime,15,5),11,5) ) + ;
      (pnMinsToAdd * 60)

   while nSecs > 86399
      nSecs -= 86400
      dDate++
   enddo

   while nSecs < 0
      nSecs += 86400
      dDate--
   enddo

   return ( ( dDate - ctod(scBaseDate) ) + val( "." + StrZero(nSecs,5,0)) )



/* HYPERTEXT START
!short: basAddHours()   Add hours to a date/time value
basAddHours()   Add hours to a date/time value

^BDescription: ^B

   basAddHours() allows you to add hours to a specified date/time numeric
   value.


^BSyntax:^B

   nNewDateTime := basAddHours( nDateTime, nHours )


^BPass:^B

   ^BnDateTime^B is a numeric expression that should contain the date/time
   numeric value that you want to add ^BnSecs^B to.

   ^BnHours^B is a numeric expression that should contain the number of
   hours that you want to add to ^BnDateTime^B.


^BReturns:^B

   ^BnNewDateTime^B is a numeric expression that will contain the numeric
   date/time value of ^BnDateTime^B plus ^BnHours^B hours.


^BSource:^B

   TIME.PRG

HYPERTEXT END */
function basAddHours( pnDateTime, pnHoursToAdd )

   local dDate     := basGetDate( pnDateTime )
   local nSecs     := val( substr(StrZero(pnDateTime,15,5),11,5) ) + ;
      (pnHoursToAdd * 3600)

   while nSecs > 86399
      nSecs -= 86400
      dDate++
   enddo

   while nSecs < 0
      nSecs += 86400
      dDate--
   enddo

   return ( ( dDate - ctod(scBaseDate) ) + val( "." + StrZero(nSecs,5,0)) )



/* HYPERTEXT START
!short: basAddDays()    Add days to a date/time value
basAddDays()    Add days to a date/time value

^BDescription: ^B

   basAddDays() allows you to add days to a specified date/time numeric
   value.


^BSyntax:^B

   nNewDateTime := basAddHours( nDateTime, nDays )


^BPass:^B

   ^BnDateTime^B is a numeric expression that should contain the date/time
   numeric value that you want to add ^BnSecs^B to.

   ^BnDays^B is a numeric expression that should contain the number of
   days that you want to add to ^BnDateTime^B.


^BReturns:^B

   ^BnNewDateTime^B is a numeric expression that will contain the numeric
   date/time value of ^BnDateTime^B plus ^BnDays^B days.


^BSource:^B

   TIME.PRG

HYPERTEXT END */
function basAddDays( pnDateTime, pnDaysToAdd )

   local dDate     := basGetDate( pnDateTime )
   local nSecs     := val( substr(StrZero(pnDateTime,15,5),11,5) ) + ;
      (pnDaysToAdd * 86400)

   while nSecs > 86399
      nSecs -= 86400
      dDate++
   enddo

   while nSecs < 0
      nSecs += 86400
      dDate--
   enddo

   return ( ( dDate - ctod(scBaseDate) ) + val( "." + StrZero(nSecs,5,0)) )



// wait a desired number of seconds
/* HYPERTEXT START
!short: basWaitSecs()   Wait a desired number of seconds
basWaitSecs()   Wait a desired number of seconds

^BDescription: ^B

   basWaitSecs() allows you to force your users to wait a specified number
   of seconds.  This is a better alternative than simply calling INKEY()
   since a user can exit INKEY() by simply pressing a key.

^BSyntax:^B

   basWaitSecs( nSecs )


^BPass:^B

   ^BnSecs^B is a numeric expression that should contain the number of
   seconds you want to force the user to wait.

^BReturns:^B

   Always nil


^BSource:^B

   TIME.PRG

HYPERTEXT END */
function basWaitSecs( pnSecs )

   tone( 0, pnSecs * 9 )

   return nil



