/*

  Program Ŀ
                                                                        
  File Name...: POSTLOG.PRG                                             
  Author......: Vernon E. Six, Jr.                                      
  Date created: 02-20-94              Date updated: 04-04-94           
  Time created: 07:46:04pm            Time updated: 09:36:46pm         
  CopyRight...: (c) 1994 by FrontLine Software                          
                                                                        
 
  

*/

#include "BAS_VERN.CH"
#include "fileio.ch"

static snHandle   := 0
static scFileName := "PROGRESS.LOG"


/* HYPERTEXT START
!short: basLogFile()    Get/Set the log file filename
basLogFile()    Get/Set the log file filename

^BDescription: ^B

   basLogFile() allows you get/set the current log file filename for
   basPostLog().


^BSyntax:^B

   cOrigFile := basPostLog( [cNewFile] )


^BPass:^B

   ^BcNewFile^B is an optional character expression that should contain the
   desired filename for the log file.


^BReturns:^B

   ^BcOrigFile^B is a character expression that will contain the current
   filename for the log file.  The original value is "PROGRESS.LOG"


^BSource:^B

   POSTLOG.PRG

HYPERTEXT END */
function basLogFile( pcNew )

   local cOldLog := scFileName

   if pcount() > 0

      if snHandle > 0
         fClose(snHandle)
      endif

      scFileName := pcNew
      snHandle   := 0

   endif

   return cOldLog



// create an entry in the log file (can be up to 70 chars long)
/* HYPERTEXT START
!short: basPostLog()    Create an entry in the log file
basPostLog()    Create an entry in the log file

^BDescription: ^B

   basPostLog() allows you to create an entry in the log file.


^BSyntax:^B

   basPostLog( cEntry, [lCallTree] )


^BPass:^B

   ^BcEntry^B is a character expression that should contain the text you
   want placed in the log file.  This value can be up to seventy (70)
   characters in length.

   ^BlCallTree^B is an optional logical expression that should be set to
   TRUE if you want basPostLog() to also post the call tree to the log
   file.  The default is TRUE.


^BReturns:^B

   Always nil


^BSource:^B

   POSTLOG.PRG

HYPERTEXT END */
function basPostLog( pcLogText, plCallTree )

   local nI    := 1
   local cLine := ""

   assume plCallTree is .t. if missing

   begin sequence

      if snHandle < 1

         if .not. file(scFileName)

            snHandle := fCreate(scFileName,FC_NORMAL)

            if snHandle < 1
               break
            endif

            fClose(snHandle)

         endif

         snHandle := fOpen(scFileName,FO_READWRITE)

         if snHandle < 1
            break
         endif

         // move the file pointer to the end of the file!
         fSeek( snHandle, 0, FS_END )

      endif

      if empty( pcLogText )
         break
      endif

      cLine := dtoc(date()) + "-" + time() + ": " + padr(pcLogText,70)

      if plCallTree

         cLine += " -- " + padr( alltrim(procname(1)) + " (" + nTrim(procline(1)) + ")", 17 ) + ;
            " -- " + padr( alltrim(procname(2)) + " (" + nTrim(procline(2)) + ")", 17 ) + ;
            " -- " + padr( alltrim(procname(3)) + " (" + nTrim(procline(3)) + ")", 17 ) + ;
            " -- " + padr( alltrim(procname(4)) + " (" + nTrim(procline(4)) + ")", 17 )

      endif

      fWrite( snHandle,cLine + chr(13) + chr(10) )

   end sequence

   return nil




