/*

 Ŀ
                                                                        
  File Name...: HELP.PRG                                                
  Author......: Vernon E. Six, Jr.                                      
  Date created: 09-06-94              Date updated: 09-06-94           
  Time created: 05:52:15pm            Time updated: 05:52:15pm         
  CopyRight...: (c) 1994 by FrontLine Software                          
                                                                        
 
  

*/

announce help

#include "BAS_VERN.CH"

#include "setcurs.ch"
#include "inkey.ch"
#include "memoedit.ch"


// these two values override everything else if these two variables are
// not null
static scPrgName  := ""
static scVarName  := ""

// 

// use values in GetActive():cargo ==> { cPrgName, cVarName }
// note: if GetActive() returns nil, it will default to _HLP_PASSED
#define _HLP_CARGO      1

// use values passed into hlpDisplay() and hlpCreate()
#define _HLP_PASSED     2

static snMode     := _HLP_PASSED

// 

// stuff for the memoedit()  (these have to be file wide statics so
// the MemoEdit() udf can see them)
static snTop     := 3
static snLeft    := 5
static snBottom  := 10
static snRight   := 75
static slDone    := .f.
static scPos     := "TL"


// open/create the HELP.DBF file
init procedure hlpInit

   // declare all the structures
   local aStruct := { ;
      { "PRG_NAME  ", "C", 10, 00 }, ;
      { "VAR_NAME  ", "C", 10, 00 }, ;
      { "TOP       ", "N", 02, 00 }, ;
      { "LEFT      ", "N", 02, 00 }, ;
      { "BOTTOM    ", "N", 02, 00 }, ;
      { "RIGHT     ", "N", 02, 00 }, ;
      { "TEXT      ", "M", 10, 00 }     }

   local aTags := { ;
      { "HELP01", "PRG_NAME+VAR_NAME", "" } }

   basStruct( "help", aStruct, aTags )

   return


// main help display facility
function hlpDisplay( pcPrgName, pnLineNmbr, pcVarName )

   local cPrgName := ""
   local cVarName := ""
   local nOldArea := select()
   local bF1      := SetKey( K_F1, nil )

   begin sequence

      if .not. basOpenDbf("help") == 0
         basMsg( " ERROR ", 3, "ERR(HELP-1): Unable to open file... HELP.DBF")
         break
      endif

      cPrgName := sPrgName(pcPrgName)
      cVarName := sVarName(pcVarName)

      // is there a help screen here
      if .not. help->( dbSeek( pcPrgName + pcVarName, .f. ) )
         basMsg( "", 2, "Sorry... no help available here." )
         break
      endif

      // display the help screen
      basSaveScrn()

      basWind( help->top, help->left, help->bottom, help->right, "", ;
         " Use [] and [] to scroll text, [ESC] to exit ", 2 )

      SetCursor(SC_NONE)

      MemoEdit( help->text, ;
         help->top    + 1,  ;
         help->left   + 1,  ;
         help->bottom - 1,  ;
         help->right  - 1,  ;
         .f.                  )  // don't allow editing, just scrolling

      basRestScrn()

   end sequence

   select(nOldArea)
   SetKey( K_F1, bF1 )

   return nil


// determine the cPrgName value
static function sPrgName(pcPrgName)

   local oGet     := nil
   local cPrgName := ""

   if empty(scPrgName)

      if snMode == _HLP_CARGO

         oGet := GetActive()

         if valtype(oGet) == "O"
            cPrgName := oGet:cargo[1]
         else
            cPrgName := pcPrgName
         endif

      else

         cPrgName := pcPrgName

      endif

   else

      cPrgName := scPrgName

   endif

   cPrgName := lower(padr(cPrgName,10))

   return cPrgName



// determine the cVarName value
static function sVarName( pcVarName )

   local oGet     := nil
   local cVarName := ""

   if empty(scVarName)

      if snMode == _HLP_CARGO

         oGet := GetActive()

         if valtype(oGet) == "O"
            cVarName := oGet:cargo[2]
         else
            cVarName := pcVarName
         endif

      else

         cVarName := pcVarName

      endif

   else

      cVarName := scVarName

   endif

   cVarName := lower(padr(cVarName,10))

   return cVarName




// main help creation facility
function hlpCreate(pcPrgName,pnLineNmbr,pcVarName)

   local lFound   := .f.
   local cHelpTxt := ""

   // some people use LEFT and RIGHT for menus, etc. so shut them off
   // while in here
   local bRight   := SetKey( K_RIGHT, nil )
   local bLeft    := SetKey( K_LEFT,  nil )

   local bAltH    := SetKey( K_ALT_H, nil )

   // start at the same place all the time
   snTop     := 3
   snLeft    := 5
   snBottom  := 10
   snRight   := 75
   slDone    := .f.
   scPos     := "TL"


   // Make sure that help is active
   if select("HELP") == 0
      vs_MsgDisp("HELP() NOT ACTIVE")
      vs_ErrSet ("HELP() NOT ACTIVE")
      return .f.
   endif


   // Make sure vs_MakeHlp() didn't call itself
   if pcPrgName == "VS_MAKEHLP"
      return .f.
   endif


   // Override the actual program name passed in {pcPrgName}?
   pcPrgName := if( empty(scPrgName), padr(pcPrgName,10), padr(scPrgName,10) )

   // Override the actual varname passed in 'pcVarName'?
   pcVarName := if( empty(scVarName), padr(pcVarName,10), padr(scVarName,10) )

   vs_GrabScrn()

   vs_Palette(VSP_HELP)


   @ maxrow()-2,00 say padr( "Program: " + alltrim(pcPrgName) + ;
      "   Variable: " + alltrim(pcVarName), 80 ) color vs_TextEnh(3)

   @ maxrow()-2,50 say "Corner: Top Left" color vs_TextEnh(3)

   @ maxrow()-1,00 say padr("Press [ALT-HOME] to change corners",80) color vs_TextEnh(3)

   @ maxrow()  ,00 say padr("Use [ALT] + arrow keys to move corner  Use [CTRL-W] to save",80) color vs_TextEnh(3)


   // Get the help text from the DBF if there is any, otherwise default
   if ( lFound := help->( dbSeek( pcPrgName + pcVarName, .f. ) ) )

      snTop      := help->toprow
      snLeft     := help->leftcol
      snBottom   := help->botrow
      snRight    := help->rightcol
      cHelpTxt   := help->helptext

   else

      snTop      :=  3
      snLeft     :=  5
      snBottom   := 10
      snRight    := 75
      cHelpTxt   := ""

   endif


   vs_GrabScrn()

   DispBegin()

   while .not. slDone

      vs_Wind(snTop,snLeft,snBottom,snRight,""," ..leave room for footer.. ",VSP_HELP)


      cHelpTxt := MemoEdit(                       ;
         cHelpTxt,             ;
         snTop+1,              ;
         snLeft+1,             ;
         snBottom-1,           ;
         snRight-1,            ;
         .t.,                  ;
         "vs_HelpMemo", ,      ;
         3                     ;
         )
      DispBegin()

      vs_PutScrn(.t.)

   enddo

   DispEnd()

   vs_PutScrn()

   if lastkey() = K_ALT_E
      cHelpTxt := ""
   endif



   *****
   * Update the HELP.DBF file, etc.
   *****
   do case

      case lastkey() = K_ESC

      case empty(cHelpTxt) .and. lFound // Erase help from dbf
         help->(vs_DelRec())

      case empty(cHelpTxt)   // Don't save it to dbf
         vs_MsgDisp("MAKEHLP() NOT SAVED")

      otherwise

         if lFound

            if help->(vs_RLock())
               help->program  := pcPrgName
               help->variable := pcVarName
               help->toprow   := snTop
               help->leftcol  := snLeft
               help->botrow   := snBottom
               help->rightcol := snRight
               help->helptext := cHelpTxt
               help->(dbUnlock())
            endif

         else

            if help->(vs_AddRec())
               help->program  := pcPrgName
               help->variable := pcVarName
               help->toprow   := snTop
               help->leftcol  := snLeft
               help->botrow   := snBottom
               help->rightcol := snRight
               help->helptext := cHelpTxt
               help->(dbUnlock())
            endif

         endif

   endcase

   vs_PutScrn()

   SetKey( K_RIGHT, bRight )
   SetKey( K_LEFT,  bLeft  )

   return (.t.)



function vs_HelpMemo( pnMode, pnRow, pnCol )
   *****
   * MemoEdit Function
   *****
   local nKey := lastkey()

   if pnMode = ME_INIT

      if ReadInsert()        // Is insert on?
         SetCursor(SC_INSERT)// Lower half block cursor
      else
         SetCursor(SC_NORMAL)// Underline cursor
      endif


      if scPos = "BR"
         @ maxrow()-2,50 say "Corner: Bottom Right" color vs_TextEnh(3)
      else
         @ maxrow()-2,50 say "Corner: Top Left    " color vs_TextEnh(3)
      endif


      DispEnd()

      return 0

   end

   if pnMode = ME_IDLE
      return ME_DEFAULT
   end

   do case

      case nKey = K_INS

         if ReadInsert()     // Is insert on?

            Tone( 1800,.5 )
            Tone( 1500,.5 )

            Tone( 1800,.5 )
            Tone( 1500,.5 )

            SetCursor(SC_NORMAL) // Underline cursor

         else

            Tone( 1000,.5 )
            Tone( 1800,.5 )

            Tone( 1000,.5 )
            Tone( 1800,.5 )

            SetCursor(SC_INSERT) // Lower half block cursor

         end

         return K_INS        // Toggle cursor ON/OFF


      case nKey = K_ESC .or. nKey = K_CTRL_END .or. nKey = K_ALT_E

         slDone := .t.

         return K_CTRL_END


      case nKey = K_ALT_HOME

         if scPos = "TL"

            scPos := "BR"

            @ maxrow()-2,50 say "Corner: Bottom Right" color vs_TextEnh(3)

         else

            scPos := "TL"

            @ maxrow()-2,50 say "Corner: Top Left    " color vs_TextEnh(3)

         end


      case nKey = K_ALT_UP

         if scPos == "TL"

            if snTop > 1
               snTop--
            end

         else

            if snBottom > snTop + 3
               snBottom--
            end

         end

         return K_CTRL_END



      case nKey = K_ALT_DOWN

         if scPos == "TL"

            if snTop < snBottom - 3
               snTop++
            end

         else

            if snBottom < maxrow() - 2
               snBottom++
            end

         end

         return K_CTRL_END



      case nKey = K_ALT_RIGHT

         if scPos == "TL"

            if snLeft < snRight - 30
               snLeft++
            end

         else

            if snRight < maxcol() - 2
               snRight++
            end

         end

         return K_CTRL_END


      case nKey = K_ALT_LEFT

         if scPos == "TL"

            if snLeft > 1
               snLeft--
            end

         else

            if snRight > snLeft+30
               snRight--
            end

         end

         return K_CTRL_END

   endcase

   return ME_DEFAULT




