/*

 Ŀ
                                                                        
  File Name...: MENUTO.PRG                                              
  Author......: Vernon E. Six, Jr.                                      
  Date created: 04-04-94              Date updated: 09-28-94           
  Time created: 09:11:51pm            Time updated: 05:37:30pm         
  CopyRight...: (c) 1994 by FrontLine Software                          
                                                                        
 
  

*/

#include "BAS_VERN.CH"
#include "inkey.ch"
#include "setcurs.ch"

#define __ROW       paPromptList[nCntr,1]
#define __COL       paPromptList[nCntr,2]
#define __PROMPT    paPromptList[nCntr,3]

#define __SELROW    paPromptList[nSel,1]
#define __SELCOL    paPromptList[nSel,2]
#define __SELPROMPT strtran( paPromptList[nSel,3], "|", "" )
#define __SELMSG    paPromptList[nSel,4]

static snRow    := -1
static snCol    := -1
static snWidth  := -1
static sanPos   := {0}
static sanOpts  := {0}
static saBlocks := { {||NIL} }


/* HYPERTEXT START
!short: basMenuPos()    Get position of cursor in basPROMPT/basMENU
basMenuPos()    Get position of cursor in basPROMPT/basMENU

^BDescription: ^B

   basMenuPos() allows your functions to get the cursor position within
   a basPROMPT/basMENU call.


^BSyntax:^B

   nPos := basMenuPos()


^BPass:^B

   Nothing


^BReturns:^B

   ^BnPos^B is a numeric expression that will contain the position of the
   cursor within the basPROMPT/basMENU call.  ie: if there are three items
   in the last call to basMENU and the cursor is setting on choice number
   two, then ^BnPos^B will be set to two.


^BSource:^B

   MENUTO.PRG

HYPERTEXT END */
function basMenuPos()
   return atail(sanPos)


/* HYPERTEXT START
!short: basMenuOpts()   Get number of choices on basPROMPT/basMENU menu
basMenuOpts()   Get number of choices on basPROMPT/basMENU menu

^BDescription: ^B

   basMenuOpts() allows your functions to determine how many choices there
   are on the most recent basPROMPT/basMENU menu.


^BSyntax:^B

   nChoices := basMenuPos()


^BPass:^B

   Nothing


^BReturns:^B

   ^BnChoices^B is a numeric expression that will contain the number of
   choices on the most recent basPROMPT/basMENU menu.


^BSource:^B

   MENUTO.PRG

HYPERTEXT END */
function basMenuOpts()
   return atail(sanOpts)


/* HYPERTEXT START
!short: basMsgRow()     Get/Set the row for basPROMPT/basMENU menu messages
basMsgRow()     Get/Set the row for basPROMPT/basMENU menu messages

^BDescription: ^B

   basMsgRow() allows your functions to get/set the row on which
   basPROMPT/basMENU menu messages should appear.


^BSyntax:^B

   nOrigRow := basMsgRow( [nNewRow] )


^BPass:^B

   ^BnNewRow^B is a numeric expression that should contain the row number
   where you want the basPROMPT/basMENU menu messages to appear.


^BReturns:^B

   ^BnOrigRow^B is a numeric expression that will contain the current row
   number where the basPROMPT/basMENU menu messages will appear.


^BSource:^B

   MENUTO.PRG

HYPERTEXT END */
function basMsgRow( pnRow )

   local nRow := snRow

   if pcount() != 0
      snRow := pnRow
   endif

   return nRow


/* HYPERTEXT START
!short: basMsgCol()     Get/Set the column for basPROMPT/basMENU menu messages
basMsgCol()     Get/Set the column for basPROMPT/basMENU menu messages

^BDescription: ^B

   basMsgCol() allows your functions to get/set the column on which
   basPROMPT/basMENU menu messages should appear.


^BSyntax:^B

   nOrigCol := basMsgCol( [nNewCol] )


^BPass:^B

   ^BnNewCol^B is a numeric expression that should contain the column number
   where you want the basPROMPT/basMENU menu messages to appear.


^BReturns:^B

   ^BnOrigCol^B is a numeric expression that will contain the current column
   number where the basPROMPT/basMENU menu messages will appear.


^BSource:^B

   MENUTO.PRG

HYPERTEXT END */
function basMsgCol( pnCol )

   local nCol := snCol

   if pcount() != 0
      snCol := pnCol
   endif

   return nCol


/* HYPERTEXT START
!short: basMsgWidth()   Get/Set the width for basPROMPT/basMENU menu messages
basMsgWidth()   Get/Set the width for basPROMPT/basMENU menu messages

^BDescription: ^B

   basMsgWidth() allows your functions to get/set the width for
   basPROMPT/basMENU menu messages.


^BSyntax:^B

   nOrigWidth := basMsgWidth( [nNewWidth] )


^BPass:^B

   ^BnNewWidth^B is a numeric expression that should contain the desired
   width for the basPROMPT/basMENU menu messages.


^BReturns:^B

   ^BnOrigWidth^B is a numeric expression that will contain the current
   width of the basPROMPT/basMENU menu messages.


^BSource:^B

   MENUTO.PRG

HYPERTEXT END */
function basMsgWidth( pnWidth )

   local nWidth := snWidth

   if pcount() != 0
      snWidth := pnWidth
   endif

   return nWidth






/* HYPERTEXT START
!short: @...basPROMPT   Paint a basMENU item and define a message
@...basPROMPT   Paint a basMENU item and define a message

^BDescription: ^B

   @...basPROMPT is a direct replacement for Clipper's own @...PROMPT
   command.  @...basPROMPT is much more robust and reliable.


^BSyntax:^B

   @ nRow,nCol basPROMPT cPrompt [message cMsg]


^BPass:^B

   ^BnRow^B is a numeric expression that should contain the row number for
   the row you want this item painted on.

   ^BnCol^B is a numeric expression that should contain the column number
   for the column you want this item painted on.

   ^BcPrompt^B is a character expression that should contain the prompt
   text to paint at ^BnRow,nCol^B.  If you place a vertical bar "|" in
   front of a character in ^BcPrompt^B, that character will be used as
   the "trigger" for this menu choice.  ie: "Your |Name"  would display
   "Your Name" with the "N" character highlighted and "N" will act just as
   though your users cursored to this menu item and pressed the [RETURN]
   key.

   ^BcMsg^B is an optional character expression that should contain the
   message text you want displayed when this menu item is highlighted by
   the cursor.

^BReturns:^B

   N/A


^BNotes:^B

   You ^BMUST^B add the following line to your source code that calls
   @...basPROMPT.

         local PromptList := {}

   You can think of PromptList[] as being VERY similar Clipper's own
   GetList[] except this is for menu items instead of get items.


^BSource:^B

   MENUTO.PRG  &  BAS_VERN.CH


HYPERTEXT END */



/* HYPERTEXT START
!short: basMENU TO      Execute a lightbar menu for defined basPROMPTs
basMENU TO      Execute a lightbar menu for defined basPROMPTs

^BDescription: ^B

   basMENU TO is a direct replacement for Clipper's own MENU TO command.
   basMENU TO is much more robust and reliable.


^BSyntax:^B

   basMENU TO <MemVar>        ;
      [START    nStart    ]   ;
      [TRIGGER  cTrigColor]   ;
      [MSGCOLOR cMsgColor ]   ;
      [BLOCK    bIdle     ]


^BPass:^B

   ^B<MemVar>^B is any valid Clipper variable name.

   ^BnStart^B is an optional numeric value that tells basMENU which choice
   to initially place the cursor on.  If you don't pass ^BnStart^B, the
   default is the first choice.

   ^BcTrigColor^B is an optional character expression that should contain
   the color for "trigger" keys.  The default is "n/r".

   ^BcMsgColor^B is an optional character expression that should contain
   the color for the messages.  The default is "w+/b".

   ^BbIdle^B is an optional code block that will get evaluated whenever
   basMENU is waiting for a key.


^BReturns:^B

   N/A


^BNotes:^B

   You ^BMUST^B add the following line to your source code that calls
   basMENU TO.

         local PromptList := {}

   You can think of PromptList[] as being VERY similar Clipper's own
   GetList[] except this is for menu items instead of get items.


^BSource:^B

   MENUTO.PRG  &  BAS_VERN.CH

HYPERTEXT END */



function basMenuRead( paPromptList, pnStart, pcTrigColor, pcMsgColor, pbBlock )

   local nCntr       := 0
   local nSel        := if( pnStart = nil, 1, max(pnStart,1) )
   local acTriggers  := {}
   local nPos        := 0
   local nKey        := 0
   local nWay        := 0

   local cNormal     := basNormal  ( SetColor() )
   local cEnhanced   := basEnhanced( SetColor() )
   local cUnselected := basNormal  ( SetColor() )

   local nLength     := 0

   local nCursor     := SetCursor( SC_NONE )

   if basMono()
      assume pcTrigColor is "N/W"
      assume pcMsgColor  is "W+/N"
   else
      assume pcTrigColor is "N/R"  if missing
      assume pcMsgColor  is "W+/B" if missing
   endif

   assume pcMsgColor  is "W+/B" if missing

   if snRow = -1 .or. snCol = -1 .or. snWidth = -1
      snRow   := maxrow()
      snCol   := 2
      snWidth := 40
   endif


   // Display the choices
   DispBegin()

   nLength := len( paPromptList )

   for nCntr := 1 to nLength

      @ __ROW,__COL say " " + strTran(__PROMPT,"|","") + " " color cUnselected

      nPos := at( "|", __PROMPT )

      if nPos == 0

         @ __ROW,__COL+1 say substr(__PROMPT,1,1) color pcTrigColor

         aAdd( acTriggers, upper( substr(__PROMPT,1,1) ) )

      else

         @ __ROW,__COL + nPos say substr(__PROMPT,nPos+1,1) color pcTrigColor

         aAdd( acTriggers, upper( substr(__PROMPT,nPos+1,1) ) )

      endif

   next nCntr

   // Highlight this prompt
   @ __SELROW,__SELCOL say "" + __SELPROMPT + "" color cEnhanced

   if snWidth != 0

      if __SELMSG = nil
         @ snRow,snCol say space(snWidth) color pcMsgColor
      else
         @ snRow,snCol say padc( __SELMSG, snWidth ) color pcMsgColor
      endif

   endif

   Dispend()


   // Add to the stack
   aAdd( sanOpts,  len( paPromptList ) )
   aAdd( sanPos,   0                   )
   aAdd( saBlocks, pbBlock             )


   // Stay here until we get a key
   while .t.

      sanPos[len(sanPos)] := nSel

      // Are we supposed to evaluate a code block when idle?
      if pbBlock != nil .and. nextKey() == 0
         eval( pbBlock )
      endif

      nKey := basInkeyZero()

      do case
         case nKey == K_ESC   ; nSel :=  0 ; EXIT
         case nKey == K_RIGHT ; nWay :=  1
         case nKey == K_DOWN  ; nWay :=  1
         case nKey == K_UP    ; nWay := -1
         case nKey == K_LEFT  ; nWay := -1
         case nKey == K_ENTER ; exit

         otherwise

            nWay := 0

            nCntr := aScan( acTriggers, {|x|x==upper(chr(nKey))} )

            if nCntr > 0
               nWay := nCntr - nSel
               keyboard chr(13)
            endif

      endcase


      DispBegin()

      // De-highlight the last prompt
      @ __SELROW,__SELCOL say " " + __SELPROMPT + " " color cUnselected

      nPos := AT( "|", paPromptList[nSel,3] )

      if nPos == 0

         @ __SELROW,__SELCOL + 1 say substr(paPromptList[nSel,3],1,1) color pcTrigColor

      else

         @ __SELROW,__SELCOL + nPos say substr(paPromptList[nSel,3],nPos+1,1) color pcTrigColor

      endif


      // Which way are we going?
      nSel += nWay

      if nSel < 1
         nSel := len(paPromptList)
      endif

      if nSel > len(paPromptList)
         nSel := 1
      endif

      // Highlight this prompt
      @ __SELROW,__SELCOL say "" + __SELPROMPT + "" color cEnhanced

      if snWidth != 0

         if __SELMSG = nil
            @ snRow,snCol say space(snWidth) color pcMsgColor
         else
            @ snRow,snCol say padc( __SELMSG, snWidth ) color pcMsgColor
         endif

      endif

      Dispend()


   enddo

   // Relieve the stack
   basShrink( sanOpts  )
   basShrink( sanPos   )
   basShrink( saBlocks )
   // (ahhh... that felt great!)  <grin>

   SetCursor( nCursor )

   return nSel



